/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.rule;

import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.parser.rule.AggregateTypeParser;
import com.tencent.supersonic.headless.chat.parser.rule.ContextInheritParser;
import com.tencent.supersonic.headless.chat.parser.rule.TimeRangeParser;
import com.tencent.supersonic.headless.chat.query.rule.RuleSemanticQuery;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSqlParser
implements SemanticParser {
    private static final Logger log = LoggerFactory.getLogger(RuleSqlParser.class);
    private static List<SemanticParser> auxiliaryParsers = Arrays.asList(new ContextInheritParser(), new TimeRangeParser(), new AggregateTypeParser());

    @Override
    public void parse(ChatQueryContext chatQueryContext) {
        if (!chatQueryContext.getText2SQLType().enableRule()) {
            return;
        }
        SchemaMapInfo mapInfo = chatQueryContext.getMapInfo();
        for (Long dataSetId : mapInfo.getMatchedDataSetInfos()) {
            List elementMatches = mapInfo.getMatchedElements(dataSetId);
            List<RuleSemanticQuery> queries = RuleSemanticQuery.resolve(dataSetId, elementMatches, chatQueryContext);
            for (RuleSemanticQuery query : queries) {
                query.fillParseInfo(chatQueryContext);
                chatQueryContext.getCandidateQueries().add(query);
            }
        }
        auxiliaryParsers.stream().forEach(p -> p.parse(chatQueryContext));
    }
}

