/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.rule;

import cn.hutool.core.date.DateUtil;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.chat.query.rule.RuleSemanticQuery;
import com.xkzhangsan.time.nlp.TimeNLP;
import com.xkzhangsan.time.nlp.TimeNLPUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRangeParser
implements SemanticParser {
    private static final Logger log = LoggerFactory.getLogger(TimeRangeParser.class);
    private static final Pattern RECENT_PATTERN_CN = Pattern.compile(".*(?<periodStr>(\u8fd1|\u8fc7\u53bb)((?<enNum>\\d+)|(?<zhNum>[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf]+))\u4e2a?(?<zhPeriod>[\u5929\u5468\u6708\u5e74])).*");
    private static final Pattern DATE_PATTERN_NUMBER = Pattern.compile("(\\d{8})");
    private static final DateFormat DATE_FORMAT_NUMBER = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void parse(ChatQueryContext queryContext) {
        String queryText = queryContext.getQueryText();
        DateConf dateConf = this.parseRecent(queryText);
        if (dateConf == null) {
            dateConf = TimeRangeParser.parseDateNumber(queryText);
        }
        if (dateConf == null) {
            dateConf = TimeRangeParser.parseDateCN(queryText);
        }
        if (dateConf != null) {
            if (queryContext.getCandidateQueries().size() > 0) {
                for (SemanticQuery query : queryContext.getCandidateQueries()) {
                    query.getParseInfo().setDateInfo(dateConf);
                    query.getParseInfo().setScore(query.getParseInfo().getScore() + (double)dateConf.getDetectWord().length());
                }
            } else if (QueryManager.containsRuleQuery(queryContext.getContextParseInfo().getQueryMode())) {
                RuleSemanticQuery semanticQuery = QueryManager.createRuleQuery(queryContext.getContextParseInfo().getQueryMode());
                queryContext.getContextParseInfo().setDateInfo(dateConf);
                queryContext.getContextParseInfo().setScore(queryContext.getContextParseInfo().getScore() + (double)dateConf.getDetectWord().length());
                semanticQuery.setParseInfo(queryContext.getContextParseInfo());
                queryContext.getCandidateQueries().add(semanticQuery);
            }
        }
    }

    private static DateConf parseDateCN(String queryText) {
        Date endDate;
        Date startDate = null;
        Object detectWord = null;
        List times = TimeNLPUtil.parse((String)queryText);
        if (times.size() <= 0) {
            return null;
        }
        startDate = ((TimeNLP)times.get(0)).getTime();
        detectWord = ((TimeNLP)times.get(0)).getTimeExpression();
        if (times.size() > 1) {
            endDate = ((TimeNLP)times.get(1)).getTime();
            detectWord = (String)detectWord + "~" + ((TimeNLP)times.get(0)).getTimeExpression();
        } else {
            endDate = TimeRangeParser.parseEndDate(startDate, queryText);
            if (null == endDate) {
                endDate = startDate;
            }
        }
        return TimeRangeParser.getDateConf(startDate, endDate, (String)detectWord);
    }

    private static Date parseEndDate(Date startDate, String text) {
        if (text.contains("\u6bcf\u65f6")) {
            return DateUtil.endOfDay((Date)startDate);
        }
        if (text.contains("\u6bcf\u5929") || text.contains("\u6bcf\u4e00\u5929") && text.contains("\u6708")) {
            return DateUtil.endOfMonth((Date)startDate);
        }
        return DateUtil.endOfYear((Date)startDate);
    }

    public static void main(String[] args) {
        TimeRangeParser.parseDateCN("2023\u5e743\u6708\u6bcf\u5929\u542b\u7a0e\u603b\u91d1\u989d\u7684\u589e\u957f\u8d8b\u52bf\u56fe");
    }

    private static DateConf parseDateNumber(String queryText) {
        String endDate = null;
        Object detectWord = null;
        Matcher dateMatcher = DATE_PATTERN_NUMBER.matcher(queryText);
        if (!dateMatcher.find()) {
            return null;
        }
        String startDate = dateMatcher.group();
        detectWord = startDate;
        if (dateMatcher.find()) {
            endDate = dateMatcher.group();
            detectWord = (String)detectWord + "~" + endDate;
        }
        endDate = endDate != null ? endDate : startDate;
        try {
            return TimeRangeParser.getDateConf(DATE_FORMAT_NUMBER.parse(startDate), DATE_FORMAT_NUMBER.parse(endDate), (String)detectWord);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private DateConf parseRecent(String queryText) {
        Matcher m = RECENT_PATTERN_CN.matcher(queryText);
        if (m.matches()) {
            int num = 0;
            String enNum = m.group("enNum");
            String zhNum = m.group("zhNum");
            if (enNum != null) {
                num = Integer.parseInt(enNum);
            } else if (zhNum != null) {
                num = this.zhNumParse(zhNum);
            }
            if (num > 0) {
                int days;
                String zhPeriod;
                DateConf info = new DateConf();
                switch (zhPeriod = m.group("zhPeriod")) {
                    case "\u5468": {
                        days = 7;
                        info.setPeriod("WEEK");
                        break;
                    }
                    case "\u6708": {
                        days = 30;
                        info.setPeriod("MONTH");
                        break;
                    }
                    case "\u5e74": {
                        days = 365;
                        info.setPeriod("YEAR");
                        break;
                    }
                    default: {
                        days = 1;
                        info.setPeriod("DAY");
                    }
                }
                days *= num;
                info.setDateMode(DateConf.DateMode.RECENT);
                Object detectWord = "\u8fd1" + num + zhPeriod;
                if (StringUtils.isNotEmpty((CharSequence)m.group("periodStr"))) {
                    detectWord = m.group("periodStr");
                }
                info.setDetectWord((String)detectWord);
                info.setStartDate(LocalDate.now().minusDays(days).toString());
                info.setEndDate(LocalDate.now().minusDays(1L).toString());
                info.setUnit(Integer.valueOf(num));
                return info;
            }
        }
        return null;
    }

    private int zhNumParse(String zhNumStr) {
        String[] ssArr;
        Stack<Integer> stack = new Stack<Integer>();
        String numStr = "\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
        String unitStr = "\u5341\u767e\u5343\u4e07\u4ebf";
        for (String e : ssArr = zhNumStr.split("")) {
            int numIndex = numStr.indexOf(e);
            int unitIndex = unitStr.indexOf(e);
            if (numIndex != -1) {
                stack.push(numIndex + 1);
                continue;
            }
            if (unitIndex == -1) continue;
            int unitNum = (int)Math.pow(10.0, unitIndex + 1);
            if (stack.isEmpty()) {
                stack.push(unitNum);
                continue;
            }
            stack.push((Integer)stack.pop() * unitNum);
        }
        return stack.stream().mapToInt(s -> s).sum();
    }

    private static DateConf getDateConf(Date startDate, Date endDate, String detectWord) {
        if (startDate == null || endDate == null) {
            return null;
        }
        DateConf info = new DateConf();
        info.setDateMode(DateConf.DateMode.BETWEEN);
        info.setStartDate(DATE_FORMAT.format(startDate));
        info.setEndDate(DATE_FORMAT.format(endDate));
        info.setDetectWord(detectWord);
        return info;
    }
}

