/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.llm.s2sql;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SqlInfo;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.llm.LLMSemanticQuery;
import com.tencent.supersonic.headless.chat.utils.QueryReqBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LLMSqlQuery
extends LLMSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(LLMSqlQuery.class);
    public static final String QUERY_MODE = "LLM_S2SQL";

    public LLMSqlQuery() {
        QueryManager.register(this);
    }

    @Override
    public String getQueryMode() {
        return QUERY_MODE;
    }

    @Override
    public SemanticQueryReq buildSemanticQueryReq() {
        return QueryReqBuilder.buildS2SQLReq(this.parseInfo.getSqlInfo(), this.parseInfo.getDataSetId());
    }

    @Override
    public void initS2Sql(DataSetSchema dataSetSchema, User user) {
        SqlInfo sqlInfo = this.parseInfo.getSqlInfo();
        sqlInfo.setCorrectedS2SQL(sqlInfo.getParsedS2SQL());
    }
}

