/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.rule.detail;

import com.tencent.supersonic.common.pojo.Constants;
import com.tencent.supersonic.common.pojo.Order;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.TagTypeDefaultConfig;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.query.rule.detail.DetailSemanticQuery;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public abstract class DetailListQuery
extends DetailSemanticQuery {
    @Override
    public void fillParseInfo(ChatQueryContext chatQueryContext) {
        super.fillParseInfo(chatQueryContext);
        this.addEntityDetailAndOrderByMetric(chatQueryContext, this.parseInfo);
    }

    private void addEntityDetailAndOrderByMetric(ChatQueryContext chatQueryContext, SemanticParseInfo parseInfo) {
        DataSetSchema dataSetSchema;
        Long dataSetId = parseInfo.getDataSetId();
        if (Objects.nonNull(dataSetId) && dataSetId > 0L && (dataSetSchema = (DataSetSchema)chatQueryContext.getSemanticSchema().getDataSetSchemaMap().get(dataSetId)) != null && Objects.nonNull(dataSetSchema.getEntity())) {
            Set<Object> dimensions = new LinkedHashSet();
            Set<Object> metrics = new LinkedHashSet();
            LinkedHashSet orders = new LinkedHashSet();
            TagTypeDefaultConfig tagTypeDefaultConfig = dataSetSchema.getTagTypeDefaultConfig();
            if (tagTypeDefaultConfig != null && tagTypeDefaultConfig.getDefaultDisplayInfo() != null) {
                if (CollectionUtils.isNotEmpty((Collection)tagTypeDefaultConfig.getDefaultDisplayInfo().getMetricIds())) {
                    metrics = tagTypeDefaultConfig.getDefaultDisplayInfo().getMetricIds().stream().map(id -> {
                        SchemaElement metric = dataSetSchema.getElement(SchemaElementType.METRIC, id.longValue());
                        if (metric != null) {
                            orders.add(new Order(metric.getBizName(), Constants.DESC_UPPER));
                        }
                        return metric;
                    }).filter(Objects::nonNull).collect(Collectors.toSet());
                }
                if (CollectionUtils.isNotEmpty((Collection)tagTypeDefaultConfig.getDefaultDisplayInfo().getDimensionIds())) {
                    dimensions = tagTypeDefaultConfig.getDefaultDisplayInfo().getDimensionIds().stream().map(id -> dataSetSchema.getElement(SchemaElementType.DIMENSION, id.longValue())).filter(Objects::nonNull).collect(Collectors.toSet());
                }
            }
            parseInfo.setDimensions(dimensions);
            parseInfo.setMetrics(metrics);
            parseInfo.setOrders(orders);
        }
    }
}

