/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.rule.metric;

import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.enums.TimeMode;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.TimeDefaultConfig;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.query.rule.QueryMatchOption;
import com.tencent.supersonic.headless.chat.query.rule.RuleSemanticQuery;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricSemanticQuery
extends RuleSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(MetricSemanticQuery.class);
    private static final Long METRIC_MAX_RESULTS = 365L;

    public MetricSemanticQuery() {
        this.queryMatcher.addOption(SchemaElementType.METRIC, QueryMatchOption.OptionType.REQUIRED, QueryMatchOption.RequireNumberType.AT_LEAST, 1);
    }

    @Override
    public List<SchemaElementMatch> match(List<SchemaElementMatch> candidateElementMatches, ChatQueryContext queryCtx) {
        return super.match(candidateElementMatches, queryCtx);
    }

    @Override
    public void fillParseInfo(ChatQueryContext chatQueryContext) {
        super.fillParseInfo(chatQueryContext);
        this.parseInfo.setLimit(METRIC_MAX_RESULTS);
        if (this.parseInfo.getDateInfo() == null) {
            DataSetSchema dataSetSchema = (DataSetSchema)chatQueryContext.getSemanticSchema().getDataSetSchemaMap().get(this.parseInfo.getDataSetId());
            TimeDefaultConfig timeDefaultConfig = dataSetSchema.getMetricTypeTimeDefaultConfig();
            DateConf dateInfo = new DateConf();
            if (Objects.nonNull(timeDefaultConfig) && Objects.nonNull(timeDefaultConfig.getUnit()) && timeDefaultConfig.getUnit() != -1) {
                String startDate;
                int unit = timeDefaultConfig.getUnit();
                String endDate = startDate = LocalDate.now().plusDays(-unit).toString();
                if (TimeMode.LAST.equals((Object)timeDefaultConfig.getTimeMode())) {
                    dateInfo.setDateMode(DateConf.DateMode.BETWEEN);
                } else if (TimeMode.RECENT.equals((Object)timeDefaultConfig.getTimeMode())) {
                    dateInfo.setDateMode(DateConf.DateMode.RECENT);
                    endDate = LocalDate.now().plusDays(-1L).toString();
                }
                dateInfo.setUnit(Integer.valueOf(unit));
                dateInfo.setPeriod(timeDefaultConfig.getPeriod());
                dateInfo.setStartDate(startDate);
                dateInfo.setEndDate(endDate);
                this.parseInfo.setDateInfo(dateInfo);
            }
        }
    }
}

