/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.rule.metric;

import com.tencent.supersonic.common.pojo.Constants;
import com.tencent.supersonic.common.pojo.Order;
import com.tencent.supersonic.common.pojo.enums.AggregateTypeEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.query.rule.QueryMatchOption;
import com.tencent.supersonic.headless.chat.query.rule.metric.MetricSemanticQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class MetricTopNQuery
extends MetricSemanticQuery {
    public static final String QUERY_MODE = "METRIC_ORDERBY";
    private static final Long ORDERBY_MAX_RESULTS = 3L;
    private static final Pattern INTENT_PATTERN = Pattern.compile("(.*)(\u6700\u5927|\u6700\u9ad8|\u6700\u591a)(.*)");

    public MetricTopNQuery() {
        this.queryMatcher.addOption(SchemaElementType.DIMENSION, QueryMatchOption.OptionType.REQUIRED, QueryMatchOption.RequireNumberType.AT_LEAST, 1);
        this.queryMatcher.addOption(SchemaElementType.VALUE, QueryMatchOption.OptionType.OPTIONAL, QueryMatchOption.RequireNumberType.AT_LEAST, 0);
        this.queryMatcher.setSupportOrderBy(true);
    }

    @Override
    public List<SchemaElementMatch> match(List<SchemaElementMatch> candidateElementMatches, ChatQueryContext queryCtx) {
        Matcher matcher = INTENT_PATTERN.matcher(queryCtx.getQueryText());
        if (matcher.matches()) {
            return super.match(candidateElementMatches, queryCtx);
        }
        return new ArrayList<SchemaElementMatch>();
    }

    @Override
    public String getQueryMode() {
        return QUERY_MODE;
    }

    @Override
    public void fillParseInfo(ChatQueryContext chatQueryContext) {
        super.fillParseInfo(chatQueryContext);
        this.parseInfo.setLimit(ORDERBY_MAX_RESULTS);
        this.parseInfo.setScore(this.parseInfo.getScore() + 2.0);
        this.parseInfo.setAggType(AggregateTypeEnum.SUM);
        SchemaElement metric = (SchemaElement)this.parseInfo.getMetrics().iterator().next();
        this.parseInfo.getOrders().add(new Order(metric.getBizName(), Constants.DESC_UPPER));
    }
}

