/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.aspect;

import com.tencent.supersonic.common.pojo.Pair;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.util.SignatureUtils;
import com.tencent.supersonic.headless.api.pojo.enums.AppStatus;
import com.tencent.supersonic.headless.api.pojo.response.AppDetailResp;
import com.tencent.supersonic.headless.server.web.service.AppService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=1)
public class ApiHeaderCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiHeaderCheckAspect.class);
    public static final String APPID = "appId";
    private static final String TIMESTAMP = "timestamp";
    private static final String SIGNATURE = "signature";
    @Autowired
    private AppService appService;

    @Pointcut(value="@annotation(com.tencent.supersonic.headless.server.annotation.ApiHeaderCheck)")
    private void apiPermissionCheck() {
    }

    @Around(value="apiPermissionCheck()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] objects = joinPoint.getArgs();
        HttpServletRequest request = (HttpServletRequest)objects[1];
        this.checkHeader(request);
        return joinPoint.proceed();
    }

    private void checkHeader(HttpServletRequest request) {
        String timestampStr = request.getHeader(TIMESTAMP);
        String signature = request.getHeader(SIGNATURE);
        String appId = request.getHeader(APPID);
        if (StringUtils.isBlank((CharSequence)timestampStr)) {
            throw new InvalidArgumentException("header\u4e2dtimestamp\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)signature)) {
            throw new InvalidArgumentException("header\u4e2dsignature\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new InvalidArgumentException("header\u4e2dappId\u4e0d\u53ef\u4e3a\u7a7a");
        }
        AppDetailResp appDetailResp = this.appService.getApp(Integer.parseInt(appId));
        if (appDetailResp == null) {
            throw new InvalidArgumentException("\u8be5appId\u5bf9\u5e94\u7684\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (!AppStatus.ONLINE.equals((Object)appDetailResp.getAppStatus())) {
            throw new InvalidArgumentException("\u8be5\u5e94\u7528\u6682\u65f6\u4e3a\u975e\u5728\u7ebf\u72b6\u6001");
        }
        Pair checkResult = SignatureUtils.isValidSignature((String)appId, (String)appDetailResp.getAppSecret(), (long)Long.parseLong(timestampStr), (String)signature);
        if (!((Boolean)checkResult.first).booleanValue()) {
            throw new InvalidArgumentException((String)checkResult.second);
        }
    }
}

