/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.aspect;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.headless.api.pojo.DrillDownDimension;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.response.DimSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.core.pojo.QueryStatement;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class MetricDrillDownChecker {
    private static final Logger log = LoggerFactory.getLogger(MetricDrillDownChecker.class);
    @Autowired
    private MetricService metricService;

    @Around(value="execution(* com.tencent.supersonic.headless.core.translator.DefaultSemanticTranslator.parse(..))")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] objects = joinPoint.getArgs();
        QueryStatement queryStatement = (QueryStatement)objects[0];
        if (queryStatement.getDataSetQueryParam() == null) {
            return joinPoint.proceed();
        }
        this.checkQuery(queryStatement.getSemanticSchemaResp(), queryStatement.getDataSetQueryParam().getSql());
        return joinPoint.proceed();
    }

    public void checkQuery(SemanticSchemaResp semanticSchemaResp, String sql) {
        List groupByFields = SqlSelectHelper.getGroupByFields((String)sql);
        List metricFields = SqlSelectHelper.getAggregateAsFields((String)sql);
        List whereFields = SqlSelectHelper.getWhereFields((String)sql);
        List<String> dimensionFields = this.getDimensionFields(groupByFields, whereFields);
        if (CollectionUtils.isEmpty((Collection)metricFields) || StringUtils.isBlank((CharSequence)sql)) {
            return;
        }
        for (String metricName : metricFields) {
            MetricSchemaResp metric = semanticSchemaResp.getMetric(metricName);
            List<DimensionResp> necessaryDimensions = this.getNecessaryDimensions(metric, semanticSchemaResp);
            List<DimensionResp> dimensionsMissing = this.getNecessaryDimensionMissing(necessaryDimensions, dimensionFields);
            if (CollectionUtils.isEmpty(dimensionsMissing)) continue;
            String errMsg = String.format("\u6307\u6807:%s \u7f3a\u5931\u5fc5\u8981\u4e0b\u94bb\u7ef4\u5ea6:%s", metric.getName(), dimensionsMissing.stream().map(SchemaItem::getName).collect(Collectors.toList()));
            throw new InvalidArgumentException(errMsg);
        }
        for (String dimensionBizName : groupByFields) {
            List<MetricResp> metricResps;
            if (TimeDimensionEnum.containsTimeDimension((String)dimensionBizName) || this.checkDrillDownDimension(dimensionBizName, metricResps = this.getMetrics(metricFields, semanticSchemaResp), semanticSchemaResp)) continue;
            DimSchemaResp dimSchemaResp = semanticSchemaResp.getDimension(dimensionBizName);
            String errMsg = String.format("\u7ef4\u5ea6:%s, \u4e0d\u5728\u5f53\u524d\u67e5\u8be2\u6307\u6807\u7684\u4e0b\u94bb\u7ef4\u5ea6\u914d\u7f6e\u4e2d, \u8bf7\u68c0\u67e5", dimSchemaResp.getName());
            throw new InvalidArgumentException(errMsg);
        }
    }

    private List<DimensionResp> getNecessaryDimensionMissing(List<DimensionResp> necessaryDimensions, List<String> dimensionFields) {
        return necessaryDimensions.stream().filter(dimension -> !dimensionFields.contains(dimension.getBizName())).collect(Collectors.toList());
    }

    private boolean checkDrillDownDimension(String dimensionName, List<MetricResp> metricResps, SemanticSchemaResp semanticSchemaResp) {
        if (CollectionUtils.isEmpty(metricResps)) {
            return true;
        }
        List relateDimensions = metricResps.stream().map(this::getDrillDownDimensions).filter(drillDownDimensions -> !CollectionUtils.isEmpty((Collection)drillDownDimensions)).map(drillDownDimensions -> drillDownDimensions.stream().map(DrillDownDimension::getDimensionId).collect(Collectors.toList())).flatMap(Collection::stream).map(id -> this.convertDimensionIdToBizName((Long)id, semanticSchemaResp)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(relateDimensions)) {
            return true;
        }
        return relateDimensions.contains(dimensionName);
    }

    private List<DimensionResp> getNecessaryDimensions(MetricSchemaResp metric, SemanticSchemaResp semanticSchemaResp) {
        if (metric == null) {
            return Lists.newArrayList();
        }
        List<DrillDownDimension> drillDownDimensions = this.getDrillDownDimensions((MetricResp)metric);
        if (CollectionUtils.isEmpty(drillDownDimensions)) {
            return Lists.newArrayList();
        }
        return drillDownDimensions.stream().filter(DrillDownDimension::isNecessary).map(DrillDownDimension::getDimensionId).map(arg_0 -> ((SemanticSchemaResp)semanticSchemaResp).getDimension(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<String> getDimensionFields(List<String> groupByFields, List<String> whereFields) {
        ArrayList dimensionFields = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(groupByFields)) {
            dimensionFields.addAll(groupByFields);
        }
        if (!CollectionUtils.isEmpty(whereFields)) {
            dimensionFields.addAll(whereFields);
        }
        return dimensionFields;
    }

    private List<MetricResp> getMetrics(List<String> metricFields, SemanticSchemaResp semanticSchemaResp) {
        return semanticSchemaResp.getMetrics().stream().filter(metricSchemaResp -> metricFields.contains(metricSchemaResp.getBizName())).collect(Collectors.toList());
    }

    private String convertDimensionIdToBizName(Long id, SemanticSchemaResp semanticSchemaResp) {
        DimSchemaResp dimension = semanticSchemaResp.getDimension(id);
        if (dimension == null) {
            return null;
        }
        return dimension.getBizName();
    }

    private List<DrillDownDimension> getDrillDownDimensions(MetricResp metricResp) {
        return this.metricService.getDrillDownDimension(metricResp.getId());
    }
}

