/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.aspect;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthRes;
import com.tencent.supersonic.auth.api.authorization.request.QueryAuthResReq;
import com.tencent.supersonic.auth.api.authorization.response.AuthorizedResourceResp;
import com.tencent.supersonic.auth.api.authorization.service.AuthService;
import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.QueryAuthorization;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.SensitiveLevelEnum;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.pojo.exception.InvalidPermissionException;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SchemaFilterReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.utils.QueryStructUtils;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Aspect
@Order(value=1)
public class S2DataPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(S2DataPermissionAspect.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
    @Autowired
    private QueryStructUtils queryStructUtils;
    @Autowired
    private DimensionService dimensionService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SchemaService schemaService;
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private AuthService authService;

    @Pointcut(value="@annotation(com.tencent.supersonic.headless.server.annotation.S2DataPermission)")
    private void s2PermissionCheck() {
    }

    @Around(value="s2PermissionCheck()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] objects = joinPoint.getArgs();
        SemanticQueryReq queryReq = (SemanticQueryReq)objects[0];
        if (!queryReq.isNeedAuth()) {
            log.info("needAuth is false, there is no need to check permissions.");
            return joinPoint.proceed();
        }
        User user = (User)objects[1];
        if (Objects.isNull(user) || StringUtils.isEmpty((CharSequence)user.getName())) {
            throw new RuntimeException("please provide user information");
        }
        List<Long> modelIds = this.getModelsInDataSet(queryReq);
        if (this.doModelAdmin(user, modelIds)) {
            return joinPoint.proceed();
        }
        this.doModelVisible(user, modelIds);
        if (queryReq instanceof QuerySqlReq) {
            return this.checkSqlPermission(joinPoint, (QuerySqlReq)queryReq);
        }
        if (queryReq instanceof QueryStructReq) {
            return this.checkStructPermission(joinPoint, (QueryStructReq)queryReq);
        }
        throw new InvalidArgumentException("queryReq is not Invalid:" + queryReq);
    }

    private Object checkSqlPermission(ProceedingJoinPoint joinPoint, QuerySqlReq querySqlReq) throws Throwable {
        Object[] objects = joinPoint.getArgs();
        User user = (User)objects[1];
        SchemaFilterReq filter = new SchemaFilterReq();
        filter.setModelIds(querySqlReq.getModelIds());
        filter.setDataSetId(querySqlReq.getDataSetId());
        SemanticSchemaResp semanticSchemaResp = this.schemaService.fetchSemanticSchema(filter);
        List<Long> modelIdInDataSet = semanticSchemaResp.getModelResps().stream().map(SchemaItem::getId).collect(Collectors.toList());
        Set<String> res4Privilege = this.queryStructUtils.getResNameEnExceptInternalCol(querySqlReq, semanticSchemaResp);
        log.info("modelId:{}, res4Privilege:{}", modelIdInDataSet, res4Privilege);
        Set<String> sensitiveResByModel = this.getHighSensitiveColsByModelId(semanticSchemaResp);
        Set<String> sensitiveResReq = res4Privilege.parallelStream().filter(sensitiveResByModel::contains).collect(Collectors.toSet());
        AuthorizedResourceResp authorizedResource = this.getAuthorizedResource(user, modelIdInDataSet, sensitiveResReq);
        Set<String> resAuthSet = this.getAuthResNameSet(authorizedResource, modelIdInDataSet);
        this.doFilterCheckLogic(querySqlReq, resAuthSet, sensitiveResReq);
        this.doRowPermission(querySqlReq, authorizedResource);
        SemanticQueryResp queryResultWithColumns = (SemanticQueryResp)joinPoint.proceed();
        if (CollectionUtils.isEmpty(sensitiveResReq) || this.allSensitiveResReqIsOk(sensitiveResReq, resAuthSet)) {
            log.info("sensitiveResReq is empty");
            return this.getQueryResultWithColumns(queryResultWithColumns, modelIdInDataSet, authorizedResource);
        }
        Set<String> need2Apply = sensitiveResReq.stream().filter(req -> !resAuthSet.contains(req)).collect(Collectors.toSet());
        log.info("need2Apply:{},sensitiveResReq:{},resAuthSet:{}", new Object[]{need2Apply, sensitiveResReq, resAuthSet});
        SemanticQueryResp queryResultAfterDesensitization = this.desensitizationData(queryResultWithColumns, need2Apply);
        this.addPromptInfoInfo(modelIdInDataSet, queryResultAfterDesensitization, authorizedResource, need2Apply);
        return queryResultAfterDesensitization;
    }

    private void doFilterCheckLogic(QuerySqlReq querySqlReq, Set<String> resAuthName, Set<String> sensitiveResReq) {
        Set<String> resFilterSet = this.queryStructUtils.getFilterResNameEnExceptInternalCol(querySqlReq);
        Set need2Apply = resFilterSet.stream().filter(res -> !resAuthName.contains(res) && sensitiveResReq.contains(res)).collect(Collectors.toSet());
        HashSet nameCnSet = new HashSet();
        ArrayList modelIds = Lists.newArrayList((Iterable)querySqlReq.getModelIds());
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setModelIds(modelIds);
        List<ModelResp> modelInfos = this.modelService.getModelList(modelFilter);
        String modelNameCn = "";
        if (!CollectionUtils.isEmpty(modelInfos)) {
            modelNameCn = modelInfos.get(0).getName();
        }
        MetaFilter metaFilter = new MetaFilter(modelIds);
        List<DimensionResp> dimensionDescList = this.dimensionService.getDimensions(metaFilter);
        String finalDomainNameCn = modelNameCn;
        dimensionDescList.stream().filter(dim -> need2Apply.contains(dim.getBizName())).forEach(dim -> nameCnSet.add(finalDomainNameCn + "-" + dim.getName()));
        if (!CollectionUtils.isEmpty(need2Apply)) {
            ModelResp modelResp = modelInfos.get(0);
            List<String> admins = this.modelService.getModelAdmin(modelResp.getId());
            log.info("in doFilterLogic, need2Apply:{}", need2Apply);
            String message = String.format("\u60a8\u6ca1\u6709\u4ee5\u4e0b\u7ef4\u5ea6%s\u6743\u9650, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s\u5f00\u901a", nameCnSet, admins);
            throw new InvalidPermissionException(message);
        }
    }

    private void doFilterCheckLogic(Set<String> resAuthName, Set<String> sensitiveResReq, List<Long> modelIdInDataSet, QueryStructReq queryStructReq) {
        Set<String> resFilterSet = this.queryStructUtils.getFilterResNameEnExceptInternalCol(queryStructReq);
        Set need2Apply = resFilterSet.stream().filter(res -> !resAuthName.contains(res) && sensitiveResReq.contains(res)).collect(Collectors.toSet());
        HashSet nameCnSet = new HashSet();
        ModelFilter modelFilter = new ModelFilter(false, modelIdInDataSet);
        Map<Long, ModelResp> modelRespMap = this.modelService.getModelMap(modelFilter);
        List<DimensionResp> dimensionDescList = this.dimensionService.getDimensions(new MetaFilter(modelIdInDataSet));
        dimensionDescList.stream().filter(dim -> need2Apply.contains(dim.getBizName())).forEach(dim -> nameCnSet.add(((ModelResp)modelRespMap.get(dim.getModelId())).getName() + "-" + dim.getName()));
        if (!CollectionUtils.isEmpty(need2Apply)) {
            List<String> admins = this.modelService.getModelAdmin(modelIdInDataSet.get(0));
            log.info("in doFilterLogic, need2Apply:{}", need2Apply);
            String message = String.format("\u60a8\u6ca1\u6709\u4ee5\u4e0b\u7ef4\u5ea6%s\u6743\u9650, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s\u5f00\u901a", nameCnSet, admins);
            throw new InvalidPermissionException(message);
        }
    }

    public Object checkStructPermission(ProceedingJoinPoint point, QueryStructReq queryStructReq) throws Throwable {
        Object[] args = point.getArgs();
        User user = (User)args[1];
        SchemaFilterReq filter = new SchemaFilterReq();
        filter.setModelIds(queryStructReq.getModelIds());
        filter.setDataSetId(queryStructReq.getDataSetId());
        SemanticSchemaResp semanticSchemaResp = this.schemaService.fetchSemanticSchema(filter);
        List<Long> modelIdInDataSet = semanticSchemaResp.getModelResps().stream().map(SchemaItem::getId).collect(Collectors.toList());
        Set<String> res4Privilege = this.queryStructUtils.getResNameEnExceptInternalCol(queryStructReq);
        log.info("modelId:{}, res4Privilege:{}", modelIdInDataSet, res4Privilege);
        Set<String> sensitiveResByModel = this.getHighSensitiveColsByModelId(semanticSchemaResp);
        Set<String> sensitiveResReq = res4Privilege.parallelStream().filter(sensitiveResByModel::contains).collect(Collectors.toSet());
        log.info("this query domainId:{}, sensitiveResReq:{}", modelIdInDataSet, sensitiveResReq);
        AuthorizedResourceResp authorizedResource = this.getAuthorizedResource(user, modelIdInDataSet, sensitiveResReq);
        Set<String> resAuthSet = this.getAuthResNameSet(authorizedResource, modelIdInDataSet);
        this.doFilterCheckLogic(resAuthSet, sensitiveResReq, modelIdInDataSet, queryStructReq);
        this.doRowPermission(queryStructReq, authorizedResource);
        SemanticQueryResp queryResultWithColumns = (SemanticQueryResp)point.proceed();
        if (CollectionUtils.isEmpty(sensitiveResReq) || this.allSensitiveResReqIsOk(sensitiveResReq, resAuthSet)) {
            log.info("sensitiveResReq is empty");
            return this.getQueryResultWithColumns(queryResultWithColumns, modelIdInDataSet, authorizedResource);
        }
        Set<String> need2Apply = sensitiveResReq.stream().filter(req -> !resAuthSet.contains(req)).collect(Collectors.toSet());
        SemanticQueryResp queryResultAfterDesensitization = this.desensitizationData(queryResultWithColumns, need2Apply);
        this.addPromptInfoInfo(modelIdInDataSet, queryResultAfterDesensitization, authorizedResource, need2Apply);
        return queryResultAfterDesensitization;
    }

    public boolean allSensitiveResReqIsOk(Set<String> sensitiveResReq, Set<String> resAuthSet) {
        if (resAuthSet.containsAll(sensitiveResReq)) {
            return true;
        }
        log.info("sensitiveResReq:{}, resAuthSet:{}", sensitiveResReq, resAuthSet);
        return false;
    }

    private void doRowPermission(QuerySqlReq querySqlReq, AuthorizedResourceResp authorizedResource) {
        log.debug("start doRowPermission logic");
        StringJoiner joiner = new StringJoiner(" OR ");
        ArrayList dimensionFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)authorizedResource.getFilters())) {
            authorizedResource.getFilters().stream().forEach(filter -> dimensionFilters.addAll(filter.getExpressions()));
        }
        if (CollectionUtils.isEmpty(dimensionFilters)) {
            log.debug("dimensionFilters is empty");
            return;
        }
        dimensionFilters.stream().forEach(filter -> {
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtils.isNotEmpty((CharSequence)filter.trim())) {
                joiner.add(" ( " + filter + " ) ");
            }
        });
        try {
            Expression expression = CCJSqlParserUtil.parseCondExpression((String)(" ( " + joiner + " ) "));
            if (StringUtils.isNotEmpty((CharSequence)joiner.toString())) {
                String sql = SqlAddHelper.addWhere((String)querySqlReq.getSql(), (Expression)expression);
                log.info("before doRowPermission, queryS2SQLReq:{}", (Object)querySqlReq.getSql());
                querySqlReq.setSql(sql);
                log.info("after doRowPermission, queryS2SQLReq:{}", (Object)querySqlReq.getSql());
            }
        }
        catch (JSQLParserException jsqlParserException) {
            log.info("jsqlParser has an exception:{}", (Object)jsqlParserException.toString());
        }
    }

    private void doRowPermission(QueryStructReq queryStructReq, AuthorizedResourceResp authorizedResource) {
        log.debug("start doRowPermission logic");
        StringJoiner joiner = new StringJoiner(" OR ");
        ArrayList dimensionFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)authorizedResource.getFilters())) {
            authorizedResource.getFilters().stream().forEach(filter -> dimensionFilters.addAll(filter.getExpressions()));
        }
        if (CollectionUtils.isEmpty(dimensionFilters)) {
            log.debug("dimensionFilters is empty");
            return;
        }
        dimensionFilters.stream().forEach(filter -> {
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtils.isNotEmpty((CharSequence)filter.trim())) {
                joiner.add(" ( " + filter + " ) ");
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)joiner.toString())) {
            log.info("before doRowPermission, queryStructReq:{}", (Object)queryStructReq);
            Filter filter2 = new Filter("", FilterOperatorEnum.SQL_PART, (Object)joiner.toString());
            List<Filter> filters = Objects.isNull(queryStructReq.getOriginalFilter()) ? new ArrayList() : queryStructReq.getOriginalFilter();
            filters.add(filter2);
            queryStructReq.setDimensionFilters(filters);
            log.info("after doRowPermission, queryStructReq:{}", (Object)queryStructReq);
        }
    }

    public boolean doModelAdmin(User user, List<Long> modelIds) {
        List<ModelResp> modelListAdmin = this.modelService.getModelListWithAuth(user, null, AuthType.ADMIN);
        if (CollectionUtils.isEmpty(modelListAdmin)) {
            return false;
        }
        Set modelAdmins = modelListAdmin.stream().map(SchemaItem::getId).collect(Collectors.toSet());
        return !CollectionUtils.isEmpty(modelAdmins) && modelAdmins.containsAll(modelIds);
    }

    public void doModelVisible(User user, List<Long> modelIds) {
        List modelListVisible = this.modelService.getModelListWithAuth(user, null, AuthType.VISIBLE).stream().map(SchemaItem::getId).collect(Collectors.toList());
        modelIds.removeAll(modelListVisible);
        if (!CollectionUtils.isEmpty(modelIds)) {
            MetaFilter metaFilter = new MetaFilter();
            metaFilter.setIds(modelIds);
            List<ModelResp> modelResps = this.modelService.getModelList(metaFilter);
            ModelResp modelResp = modelResps.stream().findFirst().orElse(null);
            if (modelResp == null) {
                throw new InvalidArgumentException("\u67e5\u8be2\u7684\u6a21\u578b\u4e0d\u5b58\u5728");
            }
            String message = String.format("\u60a8\u6ca1\u6709\u6a21\u578b[%s]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s\u5f00\u901a", modelResp.getName(), modelResp.getAdmins());
            throw new InvalidPermissionException(message);
        }
    }

    public Set<String> getHighSensitiveColsByModelId(SemanticSchemaResp semanticSchemaResp) {
        HashSet<String> highSensitiveCols = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)semanticSchemaResp.getDimensions())) {
            semanticSchemaResp.getDimensions().stream().filter(dimSchemaResp -> SensitiveLevelEnum.HIGH.getCode().equals(dimSchemaResp.getSensitiveLevel())).forEach(dim -> highSensitiveCols.add(dim.getBizName()));
        }
        if (!CollectionUtils.isEmpty((Collection)semanticSchemaResp.getMetrics())) {
            semanticSchemaResp.getMetrics().stream().filter(metricSchemaResp -> SensitiveLevelEnum.HIGH.getCode().equals(metricSchemaResp.getSensitiveLevel())).forEach(metric -> highSensitiveCols.add(metric.getBizName()));
        }
        return highSensitiveCols;
    }

    public AuthorizedResourceResp getAuthorizedResource(User user, List<Long> modelIds, Set<String> sensitiveResReq) {
        ArrayList resourceReqList = new ArrayList();
        sensitiveResReq.forEach(res -> resourceReqList.add(new AuthRes((Long)modelIds.get(0), res)));
        QueryAuthResReq queryAuthResReq = new QueryAuthResReq();
        queryAuthResReq.setResources(resourceReqList);
        queryAuthResReq.setModelIds(modelIds);
        AuthorizedResourceResp authorizedResource = this.fetchAuthRes(queryAuthResReq, user);
        log.info("user:{}, domainId:{}, after queryAuthorizedResources:{}", new Object[]{user.getName(), modelIds, authorizedResource});
        return authorizedResource;
    }

    private AuthorizedResourceResp fetchAuthRes(QueryAuthResReq queryAuthResReq, User user) {
        log.info("queryAuthResReq:{}", (Object)queryAuthResReq);
        return this.authService.queryAuthorizedResources(queryAuthResReq, user);
    }

    public Set<String> getAuthResNameSet(AuthorizedResourceResp authorizedResource, List<Long> modelIds) {
        HashSet<String> resAuthName = new HashSet<String>();
        List authResGrpList = authorizedResource.getResources();
        authResGrpList.stream().forEach(authResGrp -> {
            List cols = authResGrp.getGroup();
            if (!CollectionUtils.isEmpty((Collection)cols)) {
                cols.stream().filter(col -> modelIds.contains(col.getModelId())).forEach(col -> resAuthName.add(col.getName()));
            }
        });
        log.info("resAuthName:{}", resAuthName);
        return resAuthName;
    }

    public SemanticQueryResp getQueryResultWithColumns(SemanticQueryResp resultWithColumns, List<Long> modelIds, AuthorizedResourceResp authResource) {
        this.addPromptInfoInfo(modelIds, resultWithColumns, authResource, Sets.newHashSet());
        return resultWithColumns;
    }

    public SemanticQueryResp desensitizationData(SemanticQueryResp raw, Set<String> need2Apply) {
        log.debug("start desensitizationData logic");
        if (CollectionUtils.isEmpty(need2Apply)) {
            log.info("user has all sensitiveRes");
            return raw;
        }
        List columns = raw.getColumns();
        boolean doDesensitization = false;
        block2: for (QueryColumn queryColumn : columns) {
            for (String sensitiveCol : need2Apply) {
                if (!queryColumn.getNameEn().contains(sensitiveCol)) continue;
                doDesensitization = true;
                continue block2;
            }
        }
        if (!doDesensitization) {
            return raw;
        }
        SemanticQueryResp queryResultWithColumns = raw;
        try {
            queryResultWithColumns = this.deepCopyResult(raw);
        }
        catch (Exception e) {
            log.warn("deepCopyResult: ", (Throwable)e);
        }
        this.addAuthorizedSchemaInfo(queryResultWithColumns.getColumns(), need2Apply);
        this.desensitizationInternal(queryResultWithColumns.getResultList(), need2Apply);
        return queryResultWithColumns;
    }

    private void addAuthorizedSchemaInfo(List<QueryColumn> columns, Set<String> need2Apply) {
        if (CollectionUtils.isEmpty(need2Apply)) {
            return;
        }
        columns.stream().forEach(col -> {
            if (need2Apply.contains(this.getName(col.getNameEn()))) {
                col.setAuthorized(Boolean.valueOf(false));
            }
        });
    }

    private String getName(String nameEn) {
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(nameEn);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("`", "");
        }
        return nameEn;
    }

    private void desensitizationInternal(List<Map<String, Object>> result, Set<String> need2Apply) {
        log.info("start desensitizationInternal logic");
        for (int i = 0; i < result.size(); ++i) {
            Map<String, Object> row = result.get(i);
            HashMap<String, Object> newRow = new HashMap<String, Object>();
            for (String col : row.keySet()) {
                boolean sensitive = false;
                for (String sensitiveCol : need2Apply) {
                    if (!col.contains(sensitiveCol)) continue;
                    sensitive = true;
                    break;
                }
                if (sensitive) {
                    newRow.put(col, "******");
                    continue;
                }
                newRow.put(col, row.get(col));
            }
            result.set(i, newRow);
        }
    }

    private SemanticQueryResp deepCopyResult(SemanticQueryResp raw) throws Exception {
        SemanticQueryResp queryResultWithColumns = new SemanticQueryResp();
        BeanUtils.copyProperties((Object)raw, (Object)queryResultWithColumns);
        List columns = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)raw.getColumns())) {
            String columnsStr = MAPPER.writeValueAsString((Object)raw.getColumns());
            columns = (List)MAPPER.readValue(columnsStr, (TypeReference)new TypeReference<List<QueryColumn>>(){});
            queryResultWithColumns.setColumns(columns);
        }
        queryResultWithColumns.setColumns(columns);
        ArrayList resultData = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)raw.getResultList())) {
            for (Map line : raw.getResultList()) {
                HashMap newLine = new HashMap();
                newLine.putAll(line);
                resultData.add(newLine);
            }
        }
        queryResultWithColumns.setResultList(resultData);
        return queryResultWithColumns;
    }

    public void addPromptInfoInfo(List<Long> modelIds, SemanticQueryResp queryResultWithColumns, AuthorizedResourceResp authorizedResource, Set<String> need2Apply) {
        List filters = authorizedResource.getFilters();
        if (CollectionUtils.isEmpty(need2Apply) && CollectionUtils.isEmpty((Collection)filters)) {
            return;
        }
        List<String> admins = this.modelService.getModelAdmin(modelIds.get(0));
        if (!CollectionUtils.isEmpty(need2Apply)) {
            String promptInfo = String.format("\u5f53\u524d\u7ed3\u679c\u5df2\u7ecf\u8fc7\u8131\u654f\u5904\u7406\uff0c \u7533\u8bf7\u6743\u9650\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s", admins);
            queryResultWithColumns.setQueryAuthorization(new QueryAuthorization(promptInfo));
        }
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            log.debug("dimensionFilters:{}", (Object)filters);
            ModelResp modelResp = this.modelService.getModel(modelIds.get(0));
            ArrayList exprList = new ArrayList();
            ArrayList descList = new ArrayList();
            filters.stream().forEach(filter -> {
                if (StringUtils.isNotEmpty((CharSequence)filter.getDescription())) {
                    descList.add(filter.getDescription());
                }
                exprList.add(filter.getExpressions().toString());
            });
            String promptInfo = "\u5f53\u524d\u7ed3\u679c\u5df2\u7ecf\u8fc7\u884c\u6743\u9650\u8fc7\u6ee4\uff0c\u8be6\u7ec6\u8fc7\u6ee4\u6761\u4ef6\u5982\u4e0b:%s, \u7533\u8bf7\u6743\u9650\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s";
            String message = String.format(promptInfo, CollectionUtils.isEmpty(descList) ? exprList : descList, admins);
            queryResultWithColumns.setQueryAuthorization(new QueryAuthorization(modelResp.getName(), exprList, descList, message));
            log.info("queryResultWithColumns:{}", (Object)queryResultWithColumns);
        }
    }

    private List<Long> getModelsInDataSet(SemanticQueryReq queryReq) {
        List modelIds = queryReq.getModelIds();
        if (queryReq.getDataSetId() != null) {
            DataSetResp dataSetResp = this.dataSetService.getDataSet(queryReq.getDataSetId());
            modelIds = dataSetResp.getAllModels();
        }
        return modelIds;
    }
}

