/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.rest;

import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.ExecuteQueryReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryReq;
import com.tencent.supersonic.headless.api.pojo.response.MapResp;
import com.tencent.supersonic.headless.server.facade.service.ChatQueryService;
import com.tencent.supersonic.headless.server.facade.service.RetrieveService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/query"})
public class ChatQueryApiController {
    private static final Logger log = LoggerFactory.getLogger(ChatQueryApiController.class);
    @Autowired
    private ChatQueryService chatQueryService;
    @Autowired
    private RetrieveService retrieveService;

    @PostMapping(value={"/chat/search"})
    public Object search(@RequestBody QueryReq queryReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        queryReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.retrieveService.retrieve(queryReq);
    }

    @PostMapping(value={"/chat/map"})
    public MapResp map(@RequestBody QueryReq queryReq, HttpServletRequest request, HttpServletResponse response) {
        queryReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.performMapping(queryReq);
    }

    @PostMapping(value={"/chat/parse"})
    public Object parse(@RequestBody QueryReq queryReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        queryReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.performParsing(queryReq);
    }

    @PostMapping(value={"/chat/execute"})
    public Object execute(@RequestBody ExecuteQueryReq executeQueryReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        executeQueryReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatQueryService.performExecution(executeQueryReq);
    }
}

