/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.BatchDownloadReq;
import com.tencent.supersonic.headless.api.pojo.request.DownloadMetricReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryMetricReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.web.service.DownloadService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/query"})
public class MetricQueryApiController {
    private static final Logger log = LoggerFactory.getLogger(MetricQueryApiController.class);
    @Autowired
    private SemanticLayerService queryService;
    @Autowired
    private MetricService metricService;
    @Autowired
    private DownloadService downloadService;

    @PostMapping(value={"/metric"})
    public Object queryByMetric(@RequestBody QueryMetricReq queryMetricReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        QueryStructReq queryStructReq = this.metricService.convert(queryMetricReq);
        return this.queryService.queryByReq((SemanticQueryReq)queryStructReq.convert(true), user);
    }

    @PostMapping(value={"/download/metric"})
    public void downloadMetric(@RequestBody DownloadMetricReq downloadMetricReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.downloadService.downloadByStruct(downloadMetricReq, user, response);
    }

    @PostMapping(value={"/downloadBatch/metric"})
    public void downloadBatch(@RequestBody BatchDownloadReq batchDownloadReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.downloadService.batchDownload(batchDownloadReq, user, response);
    }
}

