/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.common.util.DateUtils;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.EntityInfo;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.SqlEvaluation;
import com.tencent.supersonic.headless.api.pojo.SqlInfo;
import com.tencent.supersonic.headless.api.pojo.enums.CostType;
import com.tencent.supersonic.headless.api.pojo.enums.QueryMethod;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.api.pojo.request.ExecuteQueryReq;
import com.tencent.supersonic.headless.api.pojo.request.ExplainSqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryDataReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryDimValueReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.api.pojo.request.QueryMapReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetMapInfo;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.ExplainResp;
import com.tencent.supersonic.headless.api.pojo.response.MapInfoResp;
import com.tencent.supersonic.headless.api.pojo.response.MapResp;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.api.pojo.response.QueryResult;
import com.tencent.supersonic.headless.api.pojo.response.QueryState;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.chat.QueryContext;
import com.tencent.supersonic.headless.chat.corrector.GrammarCorrector;
import com.tencent.supersonic.headless.chat.corrector.SchemaCorrector;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.knowledge.SearchService;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.server.facade.service.ChatQueryService;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.persistence.dataobject.StatisticsDO;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.utils.ComponentFactory;
import com.tencent.supersonic.headless.server.web.service.ChatContextService;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import com.tencent.supersonic.headless.server.web.service.WorkflowService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatQueryServiceImpl
implements ChatQueryService {
    private static final Logger log = LoggerFactory.getLogger(ChatQueryServiceImpl.class);
    @Autowired
    private SemanticLayerService semanticLayerService;
    @Autowired
    private SchemaService schemaService;
    @Autowired
    private ChatContextService chatContextService;
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private WorkflowService workflowService;

    @Override
    public MapResp performMapping(QueryReq queryReq) {
        MapResp mapResp = new MapResp();
        QueryContext queryCtx = this.buildQueryContext(queryReq);
        ComponentFactory.getSchemaMappers().forEach(mapper -> mapper.map(queryCtx));
        SchemaMapInfo mapInfo = queryCtx.getMapInfo();
        mapResp.setMapInfo(mapInfo);
        mapResp.setQueryText(queryReq.getQueryText());
        return mapResp;
    }

    @Override
    public MapInfoResp map(QueryMapReq queryMapReq) {
        QueryReq queryReq = new QueryReq();
        BeanUtils.copyProperties((Object)queryMapReq, (Object)queryReq);
        List<DataSetResp> dataSets = this.dataSetService.getDataSets(queryMapReq.getDataSetNames(), queryMapReq.getUser());
        Set<Long> dataSetIds = dataSets.stream().map(SchemaItem::getId).collect(Collectors.toSet());
        queryReq.setDataSetIds(dataSetIds);
        MapResp mapResp = this.performMapping(queryReq);
        dataSetIds.retainAll(mapResp.getMapInfo().getDataSetElementMatches().keySet());
        return this.convert(mapResp, queryMapReq.getTopN(), dataSetIds);
    }

    @Override
    public ParseResp performParsing(QueryReq queryReq) {
        ParseResp parseResult = new ParseResp(queryReq.getChatId(), queryReq.getQueryText());
        QueryContext queryCtx = this.buildQueryContext(queryReq);
        ChatContext chatCtx = this.chatContextService.getOrCreateContext(queryReq.getChatId());
        this.workflowService.startWorkflow(queryCtx, chatCtx, parseResult);
        List parseInfos = queryCtx.getCandidateQueries().stream().map(SemanticQuery::getParseInfo).collect(Collectors.toList());
        parseResult.setSelectedParses(parseInfos);
        return parseResult;
    }

    public QueryContext buildQueryContext(QueryReq queryReq) {
        SemanticSchema semanticSchema = this.schemaService.getSemanticSchema();
        Map<Long, List<Long>> modelIdToDataSetIds = this.dataSetService.getModelIdToDataSetIds();
        QueryContext queryCtx = QueryContext.builder().queryFilters(queryReq.getQueryFilters()).semanticSchema(semanticSchema).candidateQueries(new ArrayList()).mapInfo(new SchemaMapInfo()).modelIdToDataSetIds(modelIdToDataSetIds).text2SQLType(queryReq.getText2SQLType()).mapModeEnum(queryReq.getMapModeEnum()).dataSetIds(queryReq.getDataSetIds()).build();
        BeanUtils.copyProperties((Object)queryReq, (Object)queryCtx);
        return queryCtx;
    }

    @Override
    public QueryResult performExecution(ExecuteQueryReq queryReq) throws Exception {
        ArrayList<StatisticsDO> timeCostDOList = new ArrayList<StatisticsDO>();
        SemanticParseInfo parseInfo = queryReq.getParseInfo();
        SemanticQuery semanticQuery = QueryManager.createQuery((String)parseInfo.getQueryMode());
        if (semanticQuery == null) {
            return null;
        }
        semanticQuery.setParseInfo(parseInfo);
        ChatContext chatCtx = this.chatContextService.getOrCreateContext(queryReq.getChatId());
        long startTime = System.currentTimeMillis();
        SemanticQueryReq semanticQueryReq = semanticQuery.buildSemanticQueryReq();
        QueryResult queryResult = this.doExecution(semanticQueryReq, parseInfo, queryReq.getUser());
        timeCostDOList.add(StatisticsDO.builder().cost((int)(System.currentTimeMillis() - startTime)).interfaceName(semanticQuery.getClass().getSimpleName()).type(CostType.QUERY.getType()).build());
        queryResult.setQueryTimeCost(Long.valueOf(((StatisticsDO)timeCostDOList.get(0)).getCost().longValue()));
        queryResult.setChatContext(parseInfo);
        if (QueryState.SUCCESS.equals((Object)queryResult.getQueryState()) && queryReq.isSaveAnswer()) {
            chatCtx.setParseInfo(parseInfo);
            this.chatContextService.updateContext(chatCtx);
        }
        chatCtx.setQueryText(queryReq.getQueryText());
        chatCtx.setUser(queryReq.getUser().getName());
        return queryResult;
    }

    private QueryResult doExecution(SemanticQueryReq semanticQueryReq, SemanticParseInfo parseInfo, User user) throws Exception {
        SemanticQueryResp queryResp = this.semanticLayerService.queryByReq(semanticQueryReq, user);
        QueryResult queryResult = new QueryResult();
        if (queryResp != null) {
            queryResult.setQueryAuthorization(queryResp.getQueryAuthorization());
        }
        String sql = queryResp == null ? null : queryResp.getSql();
        List resultList = queryResp == null ? new ArrayList() : queryResp.getResultList();
        List columns = queryResp == null ? new ArrayList() : queryResp.getColumns();
        queryResult.setQuerySql(sql);
        queryResult.setQueryResults(resultList);
        queryResult.setQueryColumns(columns);
        queryResult.setQueryMode(parseInfo.getQueryMode());
        queryResult.setQueryState(QueryState.SUCCESS);
        return queryResult;
    }

    @Override
    public SemanticParseInfo queryContext(Integer chatId) {
        ChatContext context = this.chatContextService.getOrCreateContext(chatId);
        return context.getParseInfo();
    }

    @Override
    public QueryResult executeDirectQuery(QueryDataReq queryData, User user) throws Exception {
        String correctorSql;
        SemanticParseInfo parseInfo = this.getSemanticParseInfo(queryData);
        SemanticSchema semanticSchema = this.schemaService.getSemanticSchema();
        SemanticQuery semanticQuery = QueryManager.createQuery((String)parseInfo.getQueryMode());
        semanticQuery.setParseInfo(parseInfo);
        List<String> fields = new ArrayList<String>();
        if (Objects.nonNull(parseInfo.getSqlInfo()) && StringUtils.isNotBlank((CharSequence)parseInfo.getSqlInfo().getCorrectS2SQL())) {
            correctorSql = parseInfo.getSqlInfo().getCorrectS2SQL();
            fields = SqlSelectHelper.getAllFields((String)correctorSql);
        }
        if ("LLM_S2SQL".equalsIgnoreCase(parseInfo.getQueryMode()) && this.checkMetricReplace(fields, queryData.getMetrics())) {
            log.info("llm begin replace metrics!");
            SchemaElement metricToReplace = (SchemaElement)queryData.getMetrics().iterator().next();
            this.replaceMetrics(parseInfo, metricToReplace);
        } else if ("LLM_S2SQL".equalsIgnoreCase(parseInfo.getQueryMode())) {
            log.info("llm begin revise filters!");
            correctorSql = this.reviseCorrectS2SQL(queryData, parseInfo);
            parseInfo.getSqlInfo().setCorrectS2SQL(correctorSql);
            semanticQuery.setParseInfo(parseInfo);
            SemanticQueryReq semanticQueryReq = semanticQuery.buildSemanticQueryReq();
            ExplainSqlReq explainSqlReq = ExplainSqlReq.builder().queryReq((Object)semanticQueryReq).queryTypeEnum(QueryMethod.SQL).build();
            ExplainResp explain = this.semanticLayerService.explain(explainSqlReq, user);
            if (StringUtils.isNotBlank((CharSequence)explain.getSql())) {
                parseInfo.getSqlInfo().setQuerySQL(explain.getSql());
                parseInfo.getSqlInfo().setSourceId(explain.getSourceId());
            }
        } else {
            log.info("rule begin replace metrics and revise filters!");
            this.validFilter(semanticQuery.getParseInfo().getDimensionFilters());
            this.validFilter(semanticQuery.getParseInfo().getMetricFilters());
            semanticQuery.initS2Sql(semanticSchema, user);
            QueryReq queryReq = new QueryReq();
            queryReq.setQueryFilters(new QueryFilters());
            queryReq.setUser(user);
        }
        SemanticQueryReq semanticQueryReq = semanticQuery.buildSemanticQueryReq();
        QueryResult queryResult = this.doExecution(semanticQueryReq, semanticQuery.getParseInfo(), user);
        queryResult.setChatContext(semanticQuery.getParseInfo());
        DataSetSchema dataSetSchema = (DataSetSchema)semanticSchema.getDataSetSchemaMap().get(parseInfo.getDataSetId());
        SemanticLayerService semanticService = (SemanticLayerService)ContextUtils.getBean(SemanticLayerService.class);
        EntityInfo entityInfo = semanticService.getEntityInfo(parseInfo, dataSetSchema, user);
        queryResult.setEntityInfo(entityInfo);
        return queryResult;
    }

    private boolean checkMetricReplace(List<String> oriFields, Set<SchemaElement> metrics) {
        if (CollectionUtils.isEmpty(oriFields)) {
            return false;
        }
        if (CollectionUtils.isEmpty(metrics)) {
            return false;
        }
        List metricNames = metrics.stream().map(SchemaElement::getName).collect(Collectors.toList());
        return !oriFields.containsAll(metricNames);
    }

    public String reviseCorrectS2SQL(QueryDataReq queryData, SemanticParseInfo parseInfo) {
        HashMap<String, Map<String, String>> filedNameToValueMap = new HashMap<String, Map<String, String>>();
        HashMap havingFiledNameToValueMap = new HashMap();
        String correctorSql = parseInfo.getSqlInfo().getCorrectS2SQL();
        log.info("correctorSql before replacing:{}", (Object)correctorSql);
        List whereExpressionList = SqlSelectHelper.getWhereExpressions((String)correctorSql);
        List havingExpressionList = SqlSelectHelper.getHavingExpressions((String)correctorSql);
        ArrayList<Expression> addWhereConditions = new ArrayList<Expression>();
        ArrayList<Expression> addHavingConditions = new ArrayList<Expression>();
        HashSet<String> removeWhereFieldNames = new HashSet<String>();
        HashSet<String> removeHavingFieldNames = new HashSet<String>();
        this.updateFilters(whereExpressionList, queryData.getDimensionFilters(), parseInfo.getDimensionFilters(), addWhereConditions, removeWhereFieldNames);
        this.updateDateInfo(queryData, parseInfo, filedNameToValueMap, whereExpressionList, addWhereConditions, removeWhereFieldNames);
        correctorSql = SqlReplaceHelper.replaceValue((String)correctorSql, filedNameToValueMap);
        correctorSql = SqlRemoveHelper.removeWhereCondition((String)correctorSql, removeWhereFieldNames);
        this.updateFilters(havingExpressionList, queryData.getDimensionFilters(), parseInfo.getDimensionFilters(), addHavingConditions, removeHavingFieldNames);
        correctorSql = SqlReplaceHelper.replaceHavingValue((String)correctorSql, havingFiledNameToValueMap);
        correctorSql = SqlRemoveHelper.removeHavingCondition((String)correctorSql, removeHavingFieldNames);
        correctorSql = SqlAddHelper.addWhere((String)correctorSql, addWhereConditions);
        correctorSql = SqlAddHelper.addHaving((String)correctorSql, addHavingConditions);
        log.info("correctorSql after replacing:{}", (Object)correctorSql);
        return correctorSql;
    }

    private void replaceMetrics(SemanticParseInfo parseInfo, SchemaElement metric) {
        List oriMetrics = parseInfo.getMetrics().stream().map(SchemaElement::getName).collect(Collectors.toList());
        String correctorSql = parseInfo.getSqlInfo().getCorrectS2SQL();
        log.info("before replaceMetrics:{}", (Object)correctorSql);
        log.info("filteredMetrics:{},metrics:{}", oriMetrics, (Object)metric);
        HashMap<String, Pair> fieldMap = new HashMap<String, Pair>();
        if (CollectionUtils.isNotEmpty(oriMetrics) && !oriMetrics.contains(metric.getName())) {
            fieldMap.put((String)oriMetrics.get(0), Pair.of((Object)metric.getName(), (Object)metric.getDefaultAgg()));
            correctorSql = SqlReplaceHelper.replaceAggFields((String)correctorSql, fieldMap);
        }
        log.info("after replaceMetrics:{}", (Object)correctorSql);
        parseInfo.getSqlInfo().setCorrectS2SQL(correctorSql);
    }

    private void updateDateInfo(QueryDataReq queryData, SemanticParseInfo parseInfo, Map<String, Map<String, String>> filedNameToValueMap, List<FieldExpression> fieldExpressionList, List<Expression> addConditions, Set<String> removeFieldNames) {
        if (Objects.isNull(queryData.getDateInfo())) {
            return;
        }
        if (queryData.getDateInfo().getUnit() > 1) {
            queryData.getDateInfo().setStartDate(DateUtils.getBeforeDate((int)(queryData.getDateInfo().getUnit() + 1)));
            queryData.getDateInfo().setEndDate(DateUtils.getBeforeDate((int)1));
        }
        for (FieldExpression fieldExpression : fieldExpressionList) {
            if (!TimeDimensionEnum.DAY.getChName().equals(fieldExpression.getFieldName())) continue;
            removeFieldNames.add(TimeDimensionEnum.DAY.getChName());
            GreaterThanEquals greaterThanEquals = new GreaterThanEquals();
            this.addTimeFilters(queryData.getDateInfo().getStartDate(), greaterThanEquals, addConditions);
            MinorThanEquals minorThanEquals = new MinorThanEquals();
            this.addTimeFilters(queryData.getDateInfo().getEndDate(), minorThanEquals, addConditions);
            break;
        }
        block1: for (FieldExpression fieldExpression : fieldExpressionList) {
            for (QueryFilter queryFilter : queryData.getDimensionFilters()) {
                if (!queryFilter.getOperator().equals((Object)FilterOperatorEnum.LIKE) || !FilterOperatorEnum.LIKE.getValue().toLowerCase().equals(fieldExpression.getOperator().toLowerCase())) continue;
                HashMap<String, Object> replaceMap = new HashMap<String, Object>();
                String preValue = fieldExpression.getFieldValue().toString();
                Object curValue = queryFilter.getValue().toString();
                if (preValue.startsWith("%")) {
                    curValue = "%" + (String)curValue;
                }
                if (preValue.endsWith("%")) {
                    curValue = (String)curValue + "%";
                }
                replaceMap.put(preValue, curValue);
                filedNameToValueMap.put(fieldExpression.getFieldName(), replaceMap);
                continue block1;
            }
        }
        parseInfo.setDateInfo(queryData.getDateInfo());
    }

    private <T extends ComparisonOperator> void addTimeFilters(String date, T comparisonExpression, List<Expression> addConditions) {
        Column column = new Column(TimeDimensionEnum.DAY.getChName());
        StringValue stringValue = new StringValue(date);
        comparisonExpression.setLeftExpression((Expression)column);
        comparisonExpression.setRightExpression((Expression)stringValue);
        addConditions.add((Expression)comparisonExpression);
    }

    private void updateFilters(List<FieldExpression> fieldExpressionList, Set<QueryFilter> metricFilters, Set<QueryFilter> contextMetricFilters, List<Expression> addConditions, Set<String> removeFieldNames) {
        if (CollectionUtils.isEmpty(metricFilters)) {
            return;
        }
        block0: for (QueryFilter dslQueryFilter : metricFilters) {
            for (FieldExpression fieldExpression : fieldExpressionList) {
                if (fieldExpression.getFieldName() == null || !fieldExpression.getFieldName().contains(dslQueryFilter.getName())) continue;
                removeFieldNames.add(dslQueryFilter.getName());
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.EQUALS)) {
                    EqualsTo equalsTo = new EqualsTo();
                    this.addWhereFilters(dslQueryFilter, equalsTo, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.GREATER_THAN_EQUALS)) {
                    GreaterThanEquals greaterThanEquals = new GreaterThanEquals();
                    this.addWhereFilters(dslQueryFilter, greaterThanEquals, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.GREATER_THAN)) {
                    GreaterThan greaterThan = new GreaterThan();
                    this.addWhereFilters(dslQueryFilter, greaterThan, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.MINOR_THAN_EQUALS)) {
                    MinorThanEquals minorThanEquals = new MinorThanEquals();
                    this.addWhereFilters(dslQueryFilter, minorThanEquals, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.MINOR_THAN)) {
                    MinorThan minorThan = new MinorThan();
                    this.addWhereFilters(dslQueryFilter, minorThan, contextMetricFilters, addConditions);
                    continue block0;
                }
                if (!dslQueryFilter.getOperator().equals((Object)FilterOperatorEnum.IN)) continue block0;
                InExpression inExpression = new InExpression();
                this.addWhereInFilters(dslQueryFilter, inExpression, contextMetricFilters, addConditions);
                continue block0;
            }
        }
    }

    private void addWhereInFilters(QueryFilter dslQueryFilter, InExpression inExpression, Set<QueryFilter> contextMetricFilters, List<Expression> addConditions) {
        Column column = new Column(dslQueryFilter.getName());
        ParenthesedExpressionList parenthesedExpressionList = new ParenthesedExpressionList();
        List valueList = JsonUtil.toList((String)JsonUtil.toString((Object)dslQueryFilter.getValue()), String.class);
        if (CollectionUtils.isEmpty((Collection)valueList)) {
            return;
        }
        valueList.stream().forEach(o -> {
            StringValue stringValue = new StringValue(o);
            parenthesedExpressionList.add((Object)stringValue);
        });
        inExpression.setLeftExpression((Expression)column);
        inExpression.setRightExpression((Expression)parenthesedExpressionList);
        addConditions.add((Expression)inExpression);
        contextMetricFilters.stream().forEach(o -> {
            if (o.getName().equals(dslQueryFilter.getName())) {
                o.setValue(dslQueryFilter.getValue());
                o.setOperator(dslQueryFilter.getOperator());
            }
        });
    }

    private <T extends ComparisonOperator> void addWhereFilters(QueryFilter dslQueryFilter, T comparisonExpression, Set<QueryFilter> contextMetricFilters, List<Expression> addConditions) {
        Object columnName = dslQueryFilter.getName();
        if (StringUtils.isNotBlank((CharSequence)dslQueryFilter.getFunction())) {
            columnName = dslQueryFilter.getFunction() + "(" + dslQueryFilter.getName() + ")";
        }
        if (Objects.isNull(dslQueryFilter.getValue())) {
            return;
        }
        Column column = new Column((String)columnName);
        comparisonExpression.setLeftExpression((Expression)column);
        if (StringUtils.isNumeric((CharSequence)dslQueryFilter.getValue().toString())) {
            LongValue longValue = new LongValue(Long.parseLong(dslQueryFilter.getValue().toString()));
            comparisonExpression.setRightExpression((Expression)longValue);
        } else {
            StringValue stringValue = new StringValue(dslQueryFilter.getValue().toString());
            comparisonExpression.setRightExpression((Expression)stringValue);
        }
        addConditions.add((Expression)comparisonExpression);
        contextMetricFilters.stream().forEach(o -> {
            if (o.getName().equals(dslQueryFilter.getName())) {
                o.setValue(dslQueryFilter.getValue());
                o.setOperator(dslQueryFilter.getOperator());
            }
        });
    }

    private SemanticParseInfo getSemanticParseInfo(QueryDataReq queryData) {
        SemanticParseInfo parseInfo = queryData.getParseInfo();
        if ("LLM_S2SQL".equals(parseInfo.getQueryMode())) {
            return parseInfo;
        }
        if (CollectionUtils.isNotEmpty((Collection)queryData.getDimensions())) {
            parseInfo.setDimensions(queryData.getDimensions());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryData.getMetrics())) {
            parseInfo.setMetrics(queryData.getMetrics());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryData.getDimensionFilters())) {
            parseInfo.setDimensionFilters(queryData.getDimensionFilters());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryData.getMetricFilters())) {
            parseInfo.setMetricFilters(queryData.getMetricFilters());
        }
        if (Objects.nonNull(queryData.getDateInfo())) {
            parseInfo.setDateInfo(queryData.getDateInfo());
        }
        return parseInfo;
    }

    private void validFilter(Set<QueryFilter> filters) {
        for (QueryFilter queryFilter : filters) {
            if (Objects.isNull(queryFilter.getValue())) {
                filters.remove(queryFilter);
            }
            if (!queryFilter.getOperator().equals((Object)FilterOperatorEnum.IN) || !CollectionUtils.isEmpty((Collection)JsonUtil.toList((String)JsonUtil.toString((Object)queryFilter.getValue()), String.class))) continue;
            filters.remove(queryFilter);
        }
    }

    @Override
    public Object queryDimensionValue(DimensionValueReq dimensionValueReq, User user) throws Exception {
        SemanticQueryResp semanticQueryResp = new SemanticQueryResp();
        DimensionResp dimensionResp = this.schemaService.getDimension(dimensionValueReq.getElementID());
        Set dataSetIds = dimensionValueReq.getDataSetIds();
        dimensionValueReq.setModelId(dimensionResp.getModelId());
        List<String> dimensionValues = this.getDimensionValues(dimensionValueReq, dataSetIds);
        if (CollectionUtils.isEmpty(dimensionValues)) {
            semanticQueryResp = this.queryDatabase(dimensionValueReq, user);
            return semanticQueryResp;
        }
        ArrayList<QueryColumn> columns = new ArrayList<QueryColumn>();
        QueryColumn queryColumn = new QueryColumn();
        queryColumn.setNameEn(dimensionValueReq.getBizName());
        queryColumn.setShowType("CATEGORY");
        queryColumn.setAuthorized(Boolean.valueOf(true));
        queryColumn.setType("CHAR");
        columns.add(queryColumn);
        ArrayList resultList = new ArrayList();
        dimensionValues.stream().forEach(o -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(dimensionValueReq.getBizName(), (String)o);
            resultList.add(map);
        });
        semanticQueryResp.setColumns(columns);
        semanticQueryResp.setResultList(resultList);
        return semanticQueryResp;
    }

    private List<String> getDimensionValues(DimensionValueReq dimensionValueReq, Set<Long> dataSetIds) {
        if (StringUtils.isBlank((CharSequence)dimensionValueReq.getValue())) {
            return SearchService.getDimensionValue((DimensionValueReq)dimensionValueReq);
        }
        HashMap<Long, ArrayList<Long>> modelIdToDataSetIds = new HashMap<Long, ArrayList<Long>>();
        modelIdToDataSetIds.put(dimensionValueReq.getModelId(), new ArrayList<Long>(dataSetIds));
        List hanlpMapResultList = this.knowledgeBaseService.prefixSearch(dimensionValueReq.getValue(), 2000, modelIdToDataSetIds, dataSetIds);
        HanlpHelper.transLetterOriginal((List)hanlpMapResultList);
        return hanlpMapResultList.stream().filter(o -> {
            for (String nature : o.getNatures()) {
                Long elementID = NatureHelper.getElementID((String)nature);
                if (!dimensionValueReq.getElementID().equals(elementID)) continue;
                return true;
            }
            return false;
        }).map((? super T mapResult) -> mapResult.getName()).collect(Collectors.toList());
    }

    private SemanticQueryResp queryDatabase(DimensionValueReq dimensionValueReq, User user) {
        QueryDimValueReq queryDimValueReq = new QueryDimValueReq();
        queryDimValueReq.setValue(dimensionValueReq.getValue());
        queryDimValueReq.setModelId(dimensionValueReq.getModelId());
        queryDimValueReq.setDimensionBizName(dimensionValueReq.getBizName());
        return this.semanticLayerService.queryDimValue(queryDimValueReq, user);
    }

    @Override
    public void correct(QuerySqlReq querySqlReq, User user) {
        SemanticParseInfo semanticParseInfo = this.correctSqlReq(querySqlReq, user);
        querySqlReq.setSql(semanticParseInfo.getSqlInfo().getCorrectS2SQL());
    }

    @Override
    public SqlEvaluation validate(QuerySqlReq querySqlReq, User user) {
        SemanticParseInfo semanticParseInfo = this.correctSqlReq(querySqlReq, user);
        return semanticParseInfo.getSqlEvaluation();
    }

    private SemanticParseInfo correctSqlReq(QuerySqlReq querySqlReq, User user) {
        QueryContext queryCtx = new QueryContext();
        SemanticSchema semanticSchema = this.schemaService.getSemanticSchema();
        queryCtx.setSemanticSchema(semanticSchema);
        SemanticParseInfo semanticParseInfo = new SemanticParseInfo();
        SqlInfo sqlInfo = new SqlInfo();
        sqlInfo.setCorrectS2SQL(querySqlReq.getSql());
        sqlInfo.setS2SQL(querySqlReq.getSql());
        semanticParseInfo.setSqlInfo(sqlInfo);
        semanticParseInfo.setQueryType(QueryType.DETAIL);
        Long dataSetId = querySqlReq.getDataSetId();
        if (Objects.isNull(dataSetId)) {
            dataSetId = this.dataSetService.getDataSetIdFromSql(querySqlReq.getSql(), user);
        }
        SchemaElement dataSet = semanticSchema.getDataSet(dataSetId);
        semanticParseInfo.setDataSet(dataSet);
        ComponentFactory.getSemanticCorrectors().forEach(corrector -> {
            if (!(corrector instanceof GrammarCorrector) && !(corrector instanceof SchemaCorrector)) {
                corrector.correct(queryCtx, semanticParseInfo);
            }
        });
        log.info("chatQueryServiceImpl correct:{}", (Object)sqlInfo.getCorrectS2SQL());
        return semanticParseInfo;
    }

    private MapInfoResp convert(MapResp mapResp, Integer topN, Set<Long> dataSetIds) {
        MapInfoResp mapInfoResp = new MapInfoResp();
        if (Objects.isNull(mapResp)) {
            return mapInfoResp;
        }
        BeanUtils.copyProperties((Object)mapResp, (Object)mapInfoResp);
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setIds(new ArrayList<Long>(dataSetIds));
        List<DataSetResp> dataSetList = this.dataSetService.getDataSetList(metaFilter);
        Map<Long, DataSetResp> dataSetMap = dataSetList.stream().collect(Collectors.toMap(SchemaItem::getId, d -> d));
        mapInfoResp.setDataSetMapInfo(this.getDataSetInfo(mapResp.getMapInfo(), dataSetMap, topN));
        mapInfoResp.setTerms(this.getTerms(mapResp.getMapInfo(), dataSetMap));
        return mapInfoResp;
    }

    private Map<String, DataSetMapInfo> getDataSetInfo(SchemaMapInfo mapInfo, Map<Long, DataSetResp> dataSetMap, Integer topN) {
        HashMap<String, DataSetMapInfo> map = new HashMap<String, DataSetMapInfo>();
        Map<Long, List<SchemaElementMatch>> mapFields = this.getMapFields(mapInfo, dataSetMap);
        Map<Long, List<SchemaElementMatch>> topFields = this.getTopFields(topN, mapInfo, dataSetMap);
        for (Long dataSetId : mapInfo.getDataSetElementMatches().keySet()) {
            DataSetResp dataSetResp = dataSetMap.get(dataSetId);
            if (dataSetResp == null || CollectionUtils.isEmpty((Collection)mapFields.get(dataSetId))) continue;
            DataSetMapInfo dataSetMapInfo = new DataSetMapInfo();
            dataSetMapInfo.setMapFields(mapFields.getOrDefault(dataSetId, Lists.newArrayList()));
            dataSetMapInfo.setTopFields(topFields.getOrDefault(dataSetId, Lists.newArrayList()));
            dataSetMapInfo.setName(dataSetResp.getName());
            dataSetMapInfo.setDescription(dataSetResp.getDescription());
            map.put(dataSetMapInfo.getName(), dataSetMapInfo);
        }
        return map;
    }

    private Map<Long, List<SchemaElementMatch>> getMapFields(SchemaMapInfo mapInfo, Map<Long, DataSetResp> dataSetMap) {
        HashMap<Long, List<SchemaElementMatch>> result = new HashMap<Long, List<SchemaElementMatch>>();
        for (Map.Entry entry : mapInfo.getDataSetElementMatches().entrySet()) {
            List values = ((List)entry.getValue()).stream().filter(schemaElementMatch -> !SchemaElementType.TERM.equals((Object)schemaElementMatch.getElement().getType())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(values) || !dataSetMap.containsKey(entry.getKey())) continue;
            result.put((Long)entry.getKey(), values);
        }
        return result;
    }

    private Map<Long, List<SchemaElementMatch>> getTopFields(Integer topN, SchemaMapInfo mapInfo, Map<Long, DataSetResp> dataSetMap) {
        HashMap<Long, List<SchemaElementMatch>> result = new HashMap<Long, List<SchemaElementMatch>>();
        if (0 == topN) {
            return result;
        }
        SemanticSchema semanticSchema = this.schemaService.getSemanticSchema();
        for (Map.Entry entry : mapInfo.getDataSetElementMatches().entrySet()) {
            Long dataSetId = (Long)entry.getKey();
            List values = (List)entry.getValue();
            DataSetResp dataSetResp = dataSetMap.get(dataSetId);
            if (dataSetResp == null || CollectionUtils.isEmpty((Collection)values)) continue;
            String dataSetName = dataSetResp.getName();
            Set dimensions = semanticSchema.getDimensions(dataSetId).stream().sorted(Comparator.comparing(SchemaElement::getUseCnt).reversed()).limit(topN - 1).map(this.mergeFunction()).collect(Collectors.toSet());
            SchemaElementMatch timeDimensionMatch = this.getTimeDimension(dataSetId, dataSetName);
            dimensions.add(timeDimensionMatch);
            Set metrics = semanticSchema.getMetrics(dataSetId).stream().sorted(Comparator.comparing(SchemaElement::getUseCnt).reversed()).limit(topN.intValue()).map(this.mergeFunction()).collect(Collectors.toSet());
            dimensions.addAll(metrics);
            result.put(dataSetId, new ArrayList(dimensions));
        }
        return result;
    }

    private Map<String, List<SchemaElementMatch>> getTerms(SchemaMapInfo mapInfo, Map<Long, DataSetResp> dataSetNameMap) {
        HashMap<String, List<SchemaElementMatch>> termMap = new HashMap<String, List<SchemaElementMatch>>();
        Map dataSetElementMatches = mapInfo.getDataSetElementMatches();
        for (Map.Entry entry : dataSetElementMatches.entrySet()) {
            DataSetResp dataSetResp = dataSetNameMap.get(entry.getKey());
            if (dataSetResp == null) continue;
            List terms = ((List)entry.getValue()).stream().filter(schemaElementMatch -> SchemaElementType.TERM.equals((Object)schemaElementMatch.getElement().getType())).collect(Collectors.toList());
            termMap.put(dataSetResp.getName(), terms);
        }
        return termMap;
    }

    private SchemaElementMatch getTimeDimension(Long dataSetId, String dataSetName) {
        SchemaElement element = SchemaElement.builder().dataSet(dataSetId).dataSetName(dataSetName).type(SchemaElementType.DIMENSION).bizName(TimeDimensionEnum.DAY.getName()).build();
        SchemaElementMatch timeDimensionMatch = SchemaElementMatch.builder().element(element).detectWord(TimeDimensionEnum.DAY.getChName()).word(TimeDimensionEnum.DAY.getChName()).similarity(1.0).frequency(BaseWordBuilder.DEFAULT_FREQUENCY).build();
        return timeDimensionMatch;
    }

    private Function<SchemaElement, SchemaElementMatch> mergeFunction() {
        return schemaElement -> SchemaElementMatch.builder().element(schemaElement).frequency(BaseWordBuilder.DEFAULT_FREQUENCY).word(schemaElement.getName()).similarity(1.0).detectWord(schemaElement.getName()).build();
    }
}

