/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.api.pojo.request.QueryReq;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.api.pojo.response.SearchResult;
import com.tencent.supersonic.headless.chat.QueryContext;
import com.tencent.supersonic.headless.chat.knowledge.DataSetInfoStat;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import com.tencent.supersonic.headless.chat.mapper.MatchText;
import com.tencent.supersonic.headless.chat.mapper.ModelWithSemanticType;
import com.tencent.supersonic.headless.chat.mapper.SearchMatchStrategy;
import com.tencent.supersonic.headless.server.facade.service.RetrieveService;
import com.tencent.supersonic.headless.server.web.service.ChatContextService;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetrieveServiceImpl
implements RetrieveService {
    private static final Logger log = LoggerFactory.getLogger(RetrieveServiceImpl.class);
    private static final int RESULT_SIZE = 10;
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private ChatContextService chatContextService;
    @Autowired
    private SchemaService schemaService;
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Autowired
    private SearchMatchStrategy searchMatchStrategy;

    @Override
    public List<SearchResult> retrieve(QueryReq queryReq) {
        String queryText = queryReq.getQueryText();
        SemanticSchema semanticSchemaDb = this.schemaService.getSemanticSchema();
        List metricsDb = semanticSchemaDb.getMetrics();
        Map dataSetIdToName = semanticSchemaDb.getDataSetIdToName();
        Map<Long, List<Long>> modelIdToDataSetIds = this.dataSetService.getModelIdToDataSetIds(new ArrayList<Long>(dataSetIdToName.keySet()), User.getFakeUser());
        List originals = this.knowledgeBaseService.getTerms(queryText, modelIdToDataSetIds);
        log.debug("hanlp parse result: {}", (Object)originals);
        Set dataSetIds = queryReq.getDataSetIds();
        QueryContext queryContext = new QueryContext();
        BeanUtils.copyProperties((Object)queryReq, (Object)queryContext);
        queryContext.setModelIdToDataSetIds(this.dataSetService.getModelIdToDataSetIds());
        Map regTextMap = this.searchMatchStrategy.match(queryContext, originals, dataSetIds);
        regTextMap.entrySet().stream().forEach(m -> HanlpHelper.transLetterOriginal((List)((List)m.getValue())));
        Optional<Map.Entry> mostSimilarSearchResult = regTextMap.entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))).reduce((entry1, entry2) -> ((MatchText)entry1.getKey()).getDetectSegment().length() >= ((MatchText)entry2.getKey()).getDetectSegment().length() ? entry1 : entry2);
        if (!mostSimilarSearchResult.isPresent()) {
            return Lists.newArrayList();
        }
        Map.Entry searchTextEntry = mostSimilarSearchResult.get();
        log.debug("searchTextEntry:{},queryReq:{}", (Object)searchTextEntry, (Object)queryReq);
        LinkedHashSet<SearchResult> searchResults = new LinkedHashSet<SearchResult>();
        DataSetInfoStat dataSetInfoStat = NatureHelper.getDataSetStat((List)originals);
        List<Long> possibleDataSets = this.getPossibleDataSets(queryReq, originals, dataSetInfoStat, dataSetIds);
        boolean existMetricAndDimension = this.searchMetricAndDimension(new HashSet<Long>(possibleDataSets), dataSetIdToName, searchTextEntry, searchResults);
        MatchText matchText = (MatchText)searchTextEntry.getKey();
        Map<String, String> natureToNameMap = this.getNatureToNameMap(searchTextEntry, new HashSet<Long>(possibleDataSets));
        log.debug("possibleDataSets:{},natureToNameMap:{}", possibleDataSets, natureToNameMap);
        for (Map.Entry<String, String> natureToNameEntry : natureToNameMap.entrySet()) {
            Set<SearchResult> searchResultSet = this.searchDimensionValue(metricsDb, dataSetIdToName, dataSetInfoStat.getMetricDataSetCount(), existMetricAndDimension, matchText, natureToNameMap, natureToNameEntry, queryReq.getQueryFilters());
            searchResults.addAll(searchResultSet);
        }
        return searchResults.stream().limit(10L).collect(Collectors.toList());
    }

    private List<Long> getPossibleDataSets(QueryReq queryCtx, List<S2Term> originals, DataSetInfoStat dataSetInfoStat, Set<Long> dataSetIds) {
        if (CollectionUtils.isNotEmpty(dataSetIds)) {
            return new ArrayList<Long>(dataSetIds);
        }
        List possibleDataSets = NatureHelper.selectPossibleDataSets(originals);
        Long contextModel = this.chatContextService.getContextModel(queryCtx.getChatId());
        log.debug("possibleDataSets:{},dataSetInfoStat:{},contextModel:{}", new Object[]{possibleDataSets, dataSetInfoStat, contextModel});
        if (this.nothingOrOnlyMetric(dataSetInfoStat)) {
            return Lists.newArrayList((Object[])new Long[]{contextModel});
        }
        return possibleDataSets;
    }

    private boolean nothingOrOnlyMetric(DataSetInfoStat modelStat) {
        return modelStat.getMetricDataSetCount() >= 0L && modelStat.getDimensionDataSetCount() <= 0L && modelStat.getDimensionValueDataSetCount() <= 0L && modelStat.getDataSetCount() <= 0L;
    }

    private Set<SearchResult> searchDimensionValue(List<SchemaElement> metricsDb, Map<Long, String> modelToName, long metricModelCount, boolean existMetricAndDimension, MatchText matchText, Map<String, String> natureToNameMap, Map.Entry<String, String> natureToNameEntry, QueryFilters queryFilters) {
        LinkedHashSet<SearchResult> searchResults = new LinkedHashSet<SearchResult>();
        String nature = natureToNameEntry.getKey();
        String wordName = natureToNameEntry.getValue();
        Long modelId = NatureHelper.getDataSetId((String)nature);
        SchemaElementType schemaElementType = NatureHelper.convertToElementType((String)nature);
        if (SchemaElementType.ENTITY.equals((Object)schemaElementType)) {
            return searchResults;
        }
        SearchResult searchResult = SearchResult.builder().modelId(modelId).modelName(modelToName.get(modelId)).recommend(matchText.getRegText() + wordName).schemaElementType(schemaElementType).subRecommend(wordName).build();
        if (metricModelCount <= 0L && !existMetricAndDimension) {
            if (this.filterByQueryFilter(wordName, queryFilters)) {
                return searchResults;
            }
            searchResults.add(searchResult);
            int metricSize = this.getMetricSize(natureToNameMap);
            List metrics = this.filerMetricsByModel(metricsDb, modelId, metricSize * 3).stream().limit(metricSize).collect(Collectors.toList());
            for (String metric : metrics) {
                SearchResult result = SearchResult.builder().modelId(modelId).modelName(modelToName.get(modelId)).recommend(matchText.getRegText() + wordName + " " + metric).subRecommend(wordName + " " + metric).isComplete(false).build();
                searchResults.add(result);
            }
        } else {
            searchResults.add(searchResult);
        }
        return searchResults;
    }

    private int getMetricSize(Map<String, String> natureToNameMap) {
        int metricSize = 10 / natureToNameMap.entrySet().size();
        if (metricSize <= 1) {
            metricSize = 1;
        }
        return metricSize;
    }

    private boolean filterByQueryFilter(String wordName, QueryFilters queryFilters) {
        if (queryFilters == null || CollectionUtils.isEmpty((Collection)queryFilters.getFilters())) {
            return false;
        }
        List filters = queryFilters.getFilters();
        for (QueryFilter filter : filters) {
            if (!wordName.equalsIgnoreCase(String.valueOf(filter.getValue()))) continue;
            return false;
        }
        return true;
    }

    protected List<String> filerMetricsByModel(List<SchemaElement> metricsDb, Long model, int metricSize) {
        if (CollectionUtils.isEmpty(metricsDb)) {
            return Lists.newArrayList();
        }
        return metricsDb.stream().filter(mapDO -> Objects.nonNull(mapDO) && model.equals(mapDO.getDataSet())).sorted(Comparator.comparing(SchemaElement::getUseCnt).reversed()).flatMap(entry -> {
            ArrayList<String> result = new ArrayList<String>();
            result.add(entry.getName());
            return result.stream();
        }).limit(metricSize).collect(Collectors.toList());
    }

    private Map<String, String> getNatureToNameMap(Map.Entry<MatchText, List<HanlpMapResult>> recommendTextListEntry, Set<Long> possibleModels) {
        List<HanlpMapResult> recommendValues = recommendTextListEntry.getValue();
        return recommendValues.stream().flatMap(entry -> entry.getNatures().stream().filter(nature -> {
            if (CollectionUtils.isEmpty((Collection)possibleModels)) {
                return true;
            }
            Long model = NatureHelper.getDataSetId((String)nature);
            return possibleModels.contains(model);
        }).map(nature -> {
            DictWord posDO = new DictWord();
            posDO.setWord(entry.getName());
            posDO.setNature(nature);
            return posDO;
        })).sorted(Comparator.comparingInt(a -> a.getWord().length())).collect(Collectors.toMap(DictWord::getNature, DictWord::getWord, (value1, value2) -> value1, LinkedHashMap::new));
    }

    private boolean searchMetricAndDimension(Set<Long> possibleDataSets, Map<Long, String> modelToName, Map.Entry<MatchText, List<HanlpMapResult>> searchTextEntry, Set<SearchResult> searchResults) {
        boolean existMetric = false;
        log.debug("searchMetricAndDimension searchTextEntry:{}", searchTextEntry);
        MatchText matchText = searchTextEntry.getKey();
        List<HanlpMapResult> hanlpMapResults = searchTextEntry.getValue();
        for (HanlpMapResult hanlpMapResult : hanlpMapResults) {
            List dimensionMetricClassIds = hanlpMapResult.getNatures().stream().map(nature -> new ModelWithSemanticType(NatureHelper.getDataSetId((String)nature), NatureHelper.convertToElementType((String)nature))).filter(entry -> this.matchCondition((ModelWithSemanticType)entry, possibleDataSets)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(dimensionMetricClassIds)) continue;
            for (ModelWithSemanticType modelWithSemanticType : dimensionMetricClassIds) {
                existMetric = true;
                Long modelId = modelWithSemanticType.getModel();
                SchemaElementType schemaElementType = modelWithSemanticType.getSchemaElementType();
                SearchResult searchResult = SearchResult.builder().modelId(modelId).modelName(modelToName.get(modelId)).recommend(matchText.getRegText() + hanlpMapResult.getName()).subRecommend(hanlpMapResult.getName()).schemaElementType(schemaElementType).build();
                searchResults.add(searchResult);
            }
            log.debug("parseResult:{},dimensionMetricClassIds:{},possibleDataSets:{}", new Object[]{hanlpMapResult, dimensionMetricClassIds, possibleDataSets});
        }
        log.info("searchMetricAndDimension searchResults:{}", searchResults);
        return existMetric;
    }

    private boolean matchCondition(ModelWithSemanticType entry, Set<Long> possibleDataSets) {
        if (!SchemaElementType.METRIC.equals((Object)entry.getSchemaElementType()) && !SchemaElementType.DIMENSION.equals((Object)entry.getSchemaElementType())) {
            return false;
        }
        if (CollectionUtils.isEmpty(possibleDataSets)) {
            return true;
        }
        return possibleDataSets.contains(entry.getModel());
    }
}

