/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.persistence.repository.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tencent.supersonic.headless.server.persistence.dataobject.ClassDO;
import com.tencent.supersonic.headless.server.persistence.mapper.ClassMapper;
import com.tencent.supersonic.headless.server.persistence.repository.ClassRepository;
import com.tencent.supersonic.headless.server.pojo.ClassFilter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ClassRepositoryImpl
implements ClassRepository {
    private final ClassMapper mapper;

    public ClassRepositoryImpl(ClassMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Long create(ClassDO classDO) {
        this.mapper.insert(classDO);
        return classDO.getId();
    }

    @Override
    public Long update(ClassDO classDO) {
        this.mapper.updateById(classDO);
        return classDO.getId();
    }

    @Override
    public Integer delete(List<Long> ids) {
        return this.mapper.deleteBatchIds(ids);
    }

    @Override
    public ClassDO getClassById(Long id) {
        return (ClassDO)this.mapper.selectById(id);
    }

    @Override
    public List<ClassDO> getClassDOList(ClassFilter filter) {
        QueryWrapper wrapper = new QueryWrapper();
        if (Objects.nonNull(filter.getDomainId())) {
            wrapper.lambda().eq(ClassDO::getDomainId, (Object)filter.getDomainId());
        }
        if (Objects.nonNull(filter.getDataSetId())) {
            wrapper.lambda().eq(ClassDO::getDataSetId, (Object)filter.getDataSetId());
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getType())) {
            wrapper.lambda().eq(ClassDO::getType, (Object)filter.getType());
        }
        if (CollectionUtils.isNotEmpty(filter.getIds())) {
            wrapper.lambda().in(ClassDO::getId, filter.getIds());
        }
        if (Objects.nonNull(filter.getCreatedBy())) {
            wrapper.lambda().eq(ClassDO::getCreatedBy, (Object)filter.getCreatedBy());
        }
        if (Objects.nonNull(filter.getStatus())) {
            wrapper.lambda().eq(ClassDO::getStatus, (Object)filter.getStatus());
        }
        if (Objects.nonNull(filter.getBizName())) {
            wrapper.lambda().eq(ClassDO::getBizName, (Object)filter.getBizName());
        }
        return this.mapper.selectList((Wrapper)wrapper);
    }

    @Override
    public List<ClassDO> getAllClassDOList() {
        QueryWrapper wrapper = new QueryWrapper();
        return this.mapper.selectList((Wrapper)wrapper);
    }
}

