/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.persistence.repository.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.headless.api.pojo.QueryStat;
import com.tencent.supersonic.headless.api.pojo.request.ItemUseReq;
import com.tencent.supersonic.headless.api.pojo.response.ItemUseResp;
import com.tencent.supersonic.headless.server.persistence.mapper.StatMapper;
import com.tencent.supersonic.headless.server.persistence.repository.StatRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class StatRepositoryImpl
implements StatRepository {
    private static final Logger log = LoggerFactory.getLogger(StatRepositoryImpl.class);
    private final StatMapper statMapper;
    private final ObjectMapper mapper = new ObjectMapper();

    public StatRepositoryImpl(StatMapper statMapper) {
        this.statMapper = statMapper;
    }

    @Override
    public Boolean createRecord(QueryStat queryStatInfo) {
        return this.statMapper.createRecord(queryStatInfo);
    }

    @Override
    public List<ItemUseResp> getStatInfo(ItemUseReq itemUseReq) {
        ArrayList result = new ArrayList();
        List<QueryStat> statInfos = this.statMapper.getStatInfo(itemUseReq);
        ConcurrentHashMap<String, Long> map = new ConcurrentHashMap<String, Long>();
        statInfos.stream().forEach(stat -> {
            String dimensions = stat.getDimensions();
            String metrics = stat.getMetrics();
            if (Objects.nonNull(stat.getDataSetId())) {
                this.updateStatMapInfo(map, dimensions, TypeEnums.DIMENSION.name().toLowerCase(), stat.getDataSetId());
                this.updateStatMapInfo(map, metrics, TypeEnums.METRIC.name().toLowerCase(), stat.getDataSetId());
            }
        });
        map.forEach((k, v) -> {
            Long classId = Long.parseLong(k.split("@@")[0]);
            String type = k.split("@@")[1];
            String nameEn = k.split("@@")[2];
            result.add(new ItemUseResp(classId, type, nameEn, v));
        });
        return result.stream().sorted(Comparator.comparing(ItemUseResp::getUseCnt).reversed()).collect(Collectors.toList());
    }

    @Override
    public List<QueryStat> getQueryStatInfoWithoutCache(ItemUseReq itemUseCommend) {
        return this.statMapper.getStatInfo(itemUseCommend);
    }

    private void updateStatMapInfo(Map<String, Long> map, String dimensions, String type, Long dataSetId) {
        if (StringUtils.isNotEmpty((CharSequence)dimensions)) {
            try {
                List dimensionList = (List)this.mapper.readValue(dimensions, (TypeReference)new TypeReference<List<String>>(){});
                dimensionList.stream().forEach(dimension -> {
                    String key = dataSetId + "@@" + type + "@@" + dimension;
                    if (map.containsKey(key)) {
                        map.put(key, (Long)map.get(key) + 1L);
                    } else {
                        map.put(key, 1L);
                    }
                });
            }
            catch (Exception e) {
                log.warn("e:{}", (Throwable)e);
            }
        }
    }

    private void updateStatMapInfo(Map<String, Long> map, Long modelId, String type) {
        if (Objects.nonNull(modelId)) {
            String key = type + "@@" + modelId;
            if (map.containsKey(key)) {
                map.put(key, map.get(key) + 1L);
            } else {
                map.put(key, 1L);
            }
        }
    }
}

