/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.persistence.repository.impl;

import com.tencent.supersonic.headless.api.pojo.request.TagDeleteReq;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.TagDO;
import com.tencent.supersonic.headless.server.persistence.mapper.TagCustomMapper;
import com.tencent.supersonic.headless.server.persistence.mapper.TagMapper;
import com.tencent.supersonic.headless.server.persistence.repository.TagRepository;
import com.tencent.supersonic.headless.server.pojo.TagFilter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TagRepositoryImpl
implements TagRepository {
    private static final Logger log = LoggerFactory.getLogger(TagRepositoryImpl.class);
    private final TagMapper mapper;
    private final TagCustomMapper tagCustomMapper;

    public TagRepositoryImpl(TagMapper mapper, TagCustomMapper tagCustomMapper) {
        this.mapper = mapper;
        this.tagCustomMapper = tagCustomMapper;
    }

    @Override
    public Long create(TagDO tagDO) {
        this.mapper.insert(tagDO);
        return tagDO.getId();
    }

    @Override
    public void update(TagDO tagDO) {
        this.mapper.updateById(tagDO);
    }

    @Override
    public TagDO getTagById(Long id) {
        return (TagDO)this.mapper.selectById(id);
    }

    @Override
    public List<TagDO> getTagDOList(TagFilter tagFilter) {
        return this.tagCustomMapper.getTagDOList(tagFilter);
    }

    @Override
    public List<TagResp> queryTagRespList(TagFilter tagFilter) {
        return this.tagCustomMapper.queryTagRespList(tagFilter);
    }

    @Override
    public Boolean delete(Long id) {
        return this.tagCustomMapper.deleteById(id);
    }

    @Override
    public void deleteBatch(TagDeleteReq tagDeleteReq) {
        if (CollectionUtils.isNotEmpty((Collection)tagDeleteReq.getIds())) {
            this.tagCustomMapper.deleteBatchByIds(tagDeleteReq.getIds());
        }
        if (Objects.nonNull(tagDeleteReq.getTagDefineType()) && CollectionUtils.isNotEmpty((Collection)tagDeleteReq.getItemIds())) {
            this.tagCustomMapper.deleteBatchByType(tagDeleteReq.getItemIds(), tagDeleteReq.getTagDefineType().name());
        }
    }
}

