/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.processor;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.SqlInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.chat.QueryContext;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.server.processor.ResultProcessor;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ParseInfoProcessor
implements ResultProcessor {
    private static final Logger log = LoggerFactory.getLogger(ParseInfoProcessor.class);

    @Override
    public void process(ParseResp parseResp, QueryContext queryContext, ChatContext chatContext) {
        List candidateQueries = queryContext.getCandidateQueries();
        if (CollectionUtils.isEmpty((Collection)candidateQueries)) {
            return;
        }
        List<SemanticParseInfo> candidateParses = candidateQueries.stream().map(SemanticQuery::getParseInfo).collect(Collectors.toList());
        candidateParses.forEach(this::updateParseInfo);
    }

    public void updateParseInfo(SemanticParseInfo parseInfo) {
        SqlInfo sqlInfo = parseInfo.getSqlInfo();
        String correctS2SQL = sqlInfo.getCorrectS2SQL();
        if (StringUtils.isBlank((CharSequence)correctS2SQL)) {
            return;
        }
        if (correctS2SQL.equals(sqlInfo.getS2SQL())) {
            return;
        }
        List expressions = SqlSelectHelper.getFilterExpression((String)correctS2SQL);
        try {
            DateConf dateInfo;
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)expressions) && (dateInfo = this.getDateInfo(expressions)) != null && parseInfo.getDateInfo() == null) {
                parseInfo.setDateInfo(dateInfo);
            }
        }
        catch (Exception e) {
            log.error("set dateInfo error :", (Throwable)e);
        }
        Long dataSetId = parseInfo.getDataSetId();
        try {
            Map<String, SchemaElement> fieldNameToElement = this.getNameToElement(dataSetId);
            List<QueryFilter> result = this.getDimensionFilter(fieldNameToElement, expressions);
            parseInfo.getDimensionFilters().addAll(result);
        }
        catch (Exception e) {
            log.error("set dimensionFilter error :", (Throwable)e);
        }
        SemanticSchema semanticSchema = ((SchemaService)ContextUtils.getBean(SchemaService.class)).getSemanticSchema();
        if (Objects.isNull(semanticSchema)) {
            return;
        }
        List<String> allFields = this.getFieldsExceptDate(SqlSelectHelper.getAllFields((String)sqlInfo.getCorrectS2SQL()));
        Set<SchemaElement> metrics = this.getElements(dataSetId, allFields, semanticSchema.getMetrics());
        parseInfo.setMetrics(metrics);
        if (QueryType.METRIC.equals((Object)parseInfo.getQueryType())) {
            List groupByFields = SqlSelectHelper.getGroupByFields((String)sqlInfo.getCorrectS2SQL());
            List<String> groupByDimensions = this.getFieldsExceptDate(groupByFields);
            parseInfo.setDimensions(this.getElements(dataSetId, groupByDimensions, semanticSchema.getDimensions()));
        } else if (QueryType.DETAIL.equals((Object)parseInfo.getQueryType())) {
            List selectFields = SqlSelectHelper.getSelectFields((String)sqlInfo.getCorrectS2SQL());
            List<String> selectDimensions = this.getFieldsExceptDate(selectFields);
            parseInfo.setDimensions(this.getElements(dataSetId, selectDimensions, semanticSchema.getDimensions()));
        }
    }

    private Set<SchemaElement> getElements(Long dataSetId, List<String> allFields, List<SchemaElement> elements) {
        return elements.stream().filter(schemaElement -> {
            if (CollectionUtils.isEmpty((Collection)schemaElement.getAlias())) {
                return dataSetId.equals(schemaElement.getDataSet()) && allFields.contains(schemaElement.getName());
            }
            HashSet allFieldsSet = new HashSet(allFields);
            HashSet aliasSet = new HashSet(schemaElement.getAlias());
            List intersection = allFieldsSet.stream().filter(aliasSet::contains).collect(Collectors.toList());
            return dataSetId.equals(schemaElement.getDataSet()) && (allFields.contains(schemaElement.getName()) || !CollectionUtils.isEmpty(intersection));
        }).collect(Collectors.toSet());
    }

    private List<String> getFieldsExceptDate(List<String> allFields) {
        if (CollectionUtils.isEmpty(allFields)) {
            return new ArrayList<String>();
        }
        return allFields.stream().filter(entry -> !TimeDimensionEnum.DAY.getChName().equalsIgnoreCase((String)entry)).collect(Collectors.toList());
    }

    private List<QueryFilter> getDimensionFilter(Map<String, SchemaElement> fieldNameToElement, List<FieldExpression> fieldExpressions) {
        ArrayList result = Lists.newArrayList();
        for (FieldExpression expression : fieldExpressions) {
            QueryFilter dimensionFilter = new QueryFilter();
            dimensionFilter.setValue(expression.getFieldValue());
            SchemaElement schemaElement = fieldNameToElement.get(expression.getFieldName());
            if (Objects.isNull(schemaElement)) continue;
            dimensionFilter.setName(schemaElement.getName());
            dimensionFilter.setBizName(schemaElement.getBizName());
            dimensionFilter.setElementID(schemaElement.getId());
            FilterOperatorEnum operatorEnum = FilterOperatorEnum.getSqlOperator((String)expression.getOperator());
            dimensionFilter.setOperator(operatorEnum);
            dimensionFilter.setFunction(expression.getFunction());
            result.add(dimensionFilter);
        }
        return result;
    }

    private DateConf getDateInfo(List<FieldExpression> fieldExpressions) {
        List<FieldExpression> dateExpressions = fieldExpressions.stream().filter(expression -> TimeDimensionEnum.DAY.getChName().equalsIgnoreCase(expression.getFieldName())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dateExpressions)) {
            return null;
        }
        DateConf dateInfo = new DateConf();
        dateInfo.setDateMode(DateConf.DateMode.BETWEEN);
        FieldExpression firstExpression = (FieldExpression)dateExpressions.get(0);
        FilterOperatorEnum firstOperator = FilterOperatorEnum.getSqlOperator((String)firstExpression.getOperator());
        if (FilterOperatorEnum.EQUALS.equals((Object)firstOperator) && Objects.nonNull(firstExpression.getFieldValue())) {
            dateInfo.setStartDate(firstExpression.getFieldValue().toString());
            dateInfo.setEndDate(firstExpression.getFieldValue().toString());
            dateInfo.setDateMode(DateConf.DateMode.BETWEEN);
            return dateInfo;
        }
        if (this.containOperators(firstExpression, firstOperator, FilterOperatorEnum.GREATER_THAN, FilterOperatorEnum.GREATER_THAN_EQUALS)) {
            dateInfo.setStartDate(firstExpression.getFieldValue().toString());
            if (this.hasSecondDate(dateExpressions)) {
                dateInfo.setEndDate(dateExpressions.get(1).getFieldValue().toString());
            }
        }
        if (this.containOperators(firstExpression, firstOperator, FilterOperatorEnum.MINOR_THAN, FilterOperatorEnum.MINOR_THAN_EQUALS)) {
            dateInfo.setEndDate(firstExpression.getFieldValue().toString());
            if (this.hasSecondDate(dateExpressions)) {
                dateInfo.setStartDate(dateExpressions.get(1).getFieldValue().toString());
            }
        }
        return dateInfo;
    }

    private boolean containOperators(FieldExpression expression, FilterOperatorEnum firstOperator, FilterOperatorEnum ... operatorEnums) {
        return Arrays.asList(operatorEnums).contains(firstOperator) && Objects.nonNull(expression.getFieldValue());
    }

    private boolean hasSecondDate(List<FieldExpression> dateExpressions) {
        return dateExpressions.size() > 1 && Objects.nonNull(dateExpressions.get(1).getFieldValue());
    }

    protected Map<String, SchemaElement> getNameToElement(Long dataSetId) {
        SemanticSchema semanticSchema = ((SchemaService)ContextUtils.getBean(SchemaService.class)).getSemanticSchema();
        List dimensions = semanticSchema.getDimensions(dataSetId);
        List metrics = semanticSchema.getMetrics(dataSetId);
        ArrayList allElements = Lists.newArrayList();
        allElements.addAll(dimensions);
        allElements.addAll(metrics);
        return allElements.stream().flatMap(schemaElement -> {
            HashSet<Pair> result = new HashSet<Pair>();
            result.add(Pair.of((Object)schemaElement.getName(), (Object)schemaElement));
            List aliasList = schemaElement.getAlias();
            if (!CollectionUtils.isEmpty((Collection)aliasList)) {
                for (String alias : aliasList) {
                    result.add(Pair.of((Object)alias, (Object)schemaElement));
                }
            }
            return result.stream();
        }).collect(Collectors.toMap(pair -> (String)pair.getLeft(), pair -> (SchemaElement)pair.getRight(), (value1, value2) -> value2));
    }
}

