/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.task;

import com.tencent.supersonic.headless.server.web.service.impl.DictWordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class DictionaryReloadTask
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DictionaryReloadTask.class);
    @Autowired
    private DictWordService dictWordService;

    public void run(String ... args) {
        this.updateKnowledgeDimValue();
    }

    public void updateKnowledgeDimValue() {
        try {
            log.debug("ApplicationStartedInit start");
            this.dictWordService.loadDictWord();
            log.debug("ApplicationStartedInit end");
        }
        catch (Exception e) {
            log.error("ApplicationStartedInit error", (Throwable)e);
        }
    }

    @Scheduled(cron="${reload.knowledge.corn:0 0/30 * * * ?}")
    public void reloadKnowledge() {
        log.debug("reloadKnowledge start");
        try {
            this.dictWordService.reloadDictWord();
        }
        catch (Exception e) {
            log.error("reloadKnowledge error", (Throwable)e);
        }
        log.debug("reloadKnowledge end");
    }
}

