/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.task;

import com.tencent.supersonic.headless.server.facade.service.FlightService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class FlightServerInitTask
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(FlightServerInitTask.class);
    @Value(value="${s2.flightSql.enable:false}")
    private Boolean enable = false;
    @Value(value="${s2.flightSql.host:localhost}")
    private String host = "localhost";
    @Value(value="${s2.flightSql.port:9081}")
    private Integer port = 9081;
    @Value(value="${s2.flightSql.executor:4}")
    private Integer executor = 4;
    @Value(value="${s2.flightSql.queue:128}")
    private Integer queue = 128;
    @Value(value="${s2.flightSql.expireMinute:10}")
    private Integer expireMinute = 10;
    private final FlightService flightService;
    private ExecutorService executorService;
    private FlightServer flightServer;
    private BufferAllocator allocator = new RootAllocator();
    private Boolean isRunning = false;

    public FlightServerInitTask(FlightService flightService) {
        this.flightService = flightService;
        this.flightService.setLocation(this.host, this.port);
        this.executorService = Executors.newFixedThreadPool(this.executor);
        this.flightService.setExecutorService(this.executorService, this.queue, this.expireMinute);
        Location listenLocation = Location.forGrpcInsecure((String)this.host, (int)this.port);
        this.flightServer = FlightServer.builder((BufferAllocator)this.allocator, (Location)listenLocation, (FlightProducer)this.flightService).build();
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void startServer() {
        try {
            log.info("Arrow Flight JDBC server started on {} {}", (Object)this.host, (Object)this.port);
            this.flightServer.start();
            this.isRunning = true;
        }
        catch (Exception e) {
            log.error("FlightServerInitTask start error {}", (Throwable)e);
        }
    }

    public Boolean isRunning() {
        return this.isRunning;
    }

    @PreDestroy
    public void onShutdown() {
        try {
            log.info("Arrow Flight JDBC server stop on {} {}", (Object)this.host, (Object)this.port);
            this.flightServer.close();
            this.allocator.close();
        }
        catch (Exception e) {
            log.error("FlightServerInitTask start error {}", (Throwable)e);
        }
    }

    public void run(String ... args) throws Exception {
        if (this.enable.booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        FlightServerInitTask.this.startServer();
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            try {
                                FlightServerInitTask.this.flightServer.close();
                                FlightServerInitTask.this.allocator.close();
                            }
                            catch (Exception e) {
                                log.error("flightServer close error {}", (Throwable)e);
                            }
                        }));
                    }
                    catch (Exception e) {
                        log.error("run error {}", (Throwable)e);
                    }
                }
            }.start();
        }
    }
}

