/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.google.common.collect.Lists;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.DimValueMap;
import com.tencent.supersonic.headless.api.pojo.RelateDimension;
import com.tencent.supersonic.headless.api.pojo.RelatedSchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.SchemaValueMap;
import com.tencent.supersonic.headless.api.pojo.response.DataSetSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.DimSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.TermResp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class DataSetSchemaBuilder {
    public static DataSetSchema build(DataSetSchemaResp resp) {
        DataSetSchema dataSetSchema = new DataSetSchema();
        dataSetSchema.setQueryConfig(resp.getQueryConfig());
        SchemaElement dataSet = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).id(resp.getId()).name(resp.getName()).bizName(resp.getBizName()).type(SchemaElementType.DATASET).businessType(resp.getBusinessType()).build();
        dataSetSchema.setDataSet(dataSet);
        Set<SchemaElement> metrics = DataSetSchemaBuilder.getMetrics(resp);
        dataSetSchema.getMetrics().addAll(metrics);
        Set<SchemaElement> metricTags = DataSetSchemaBuilder.getMetricTags(resp);
        dataSetSchema.getTags().addAll(metricTags);
        Set<SchemaElement> dimensions = DataSetSchemaBuilder.getDimensions(resp);
        dataSetSchema.getDimensions().addAll(dimensions);
        Set<SchemaElement> dimensionTags = DataSetSchemaBuilder.getDimensionTags(resp);
        dataSetSchema.getTags().addAll(dimensionTags);
        Set<SchemaElement> dimensionValues = DataSetSchemaBuilder.getDimensionValues(resp);
        dataSetSchema.getDimensionValues().addAll(dimensionValues);
        Set<SchemaElement> terms = DataSetSchemaBuilder.getTerms(resp);
        dataSetSchema.getTerms().addAll(terms);
        SchemaElement entity = DataSetSchemaBuilder.getEntity(resp);
        if (Objects.nonNull(entity)) {
            dataSetSchema.setEntity(entity);
        }
        return dataSetSchema;
    }

    private static Set<SchemaElement> getMetricTags(DataSetSchemaResp resp) {
        HashSet<SchemaElement> tags = new HashSet<SchemaElement>();
        for (MetricSchemaResp metric : resp.getMetrics()) {
            List alias = SchemaItem.getAliasList((String)metric.getAlias());
            if (metric.getIsTag() != 1) continue;
            SchemaElement tagToAdd = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).model(metric.getModelId()).id(metric.getId()).name(metric.getName()).bizName(metric.getBizName()).type(SchemaElementType.TAG).useCnt(metric.getUseCnt()).alias(alias).defaultAgg(metric.getDefaultAgg()).isTag(metric.getIsTag()).description(metric.getDescription()).build();
            tags.add(tagToAdd);
        }
        return tags;
    }

    private static Set<SchemaElement> getDimensionTags(DataSetSchemaResp resp) {
        HashSet<SchemaElement> tags = new HashSet<SchemaElement>();
        for (DimSchemaResp dim : resp.getDimensions()) {
            List alias = SchemaItem.getAliasList((String)dim.getAlias());
            List dimValueMaps = dim.getDimValueMaps();
            ArrayList<SchemaValueMap> schemaValueMaps = new ArrayList<SchemaValueMap>();
            if (!CollectionUtils.isEmpty((Collection)dimValueMaps)) {
                for (DimValueMap dimValueMap : dimValueMaps) {
                    SchemaValueMap schemaValueMap = new SchemaValueMap();
                    BeanUtils.copyProperties((Object)dimValueMap, (Object)schemaValueMap);
                    schemaValueMaps.add(schemaValueMap);
                }
            }
            if (dim.getIsTag() != 1) continue;
            SchemaElement tagToAdd = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).model(dim.getModelId()).id(dim.getId()).name(dim.getName()).bizName(dim.getBizName()).type(SchemaElementType.TAG).useCnt(dim.getUseCnt()).alias(alias).schemaValueMaps(schemaValueMaps).isTag(dim.getIsTag()).description(dim.getDescription()).build();
            tags.add(tagToAdd);
        }
        return tags;
    }

    private static SchemaElement getEntity(DataSetSchemaResp resp) {
        DimSchemaResp dim = resp.getPrimaryKey();
        if (Objects.isNull(dim)) {
            return null;
        }
        return SchemaElement.builder().dataSet(resp.getId()).model(dim.getModelId()).id(dim.getId()).name(dim.getName()).bizName(dim.getBizName()).type(SchemaElementType.ENTITY).useCnt(dim.getUseCnt()).alias(dim.getEntityAlias()).build();
    }

    private static Set<SchemaElement> getDimensions(DataSetSchemaResp resp) {
        HashSet<SchemaElement> dimensions = new HashSet<SchemaElement>();
        for (DimSchemaResp dim : resp.getDimensions()) {
            List alias = SchemaItem.getAliasList((String)dim.getAlias());
            List dimValueMaps = dim.getDimValueMaps();
            ArrayList<SchemaValueMap> schemaValueMaps = new ArrayList<SchemaValueMap>();
            if (!CollectionUtils.isEmpty((Collection)dimValueMaps)) {
                for (DimValueMap dimValueMap : dimValueMaps) {
                    SchemaValueMap schemaValueMap = new SchemaValueMap();
                    BeanUtils.copyProperties((Object)dimValueMap, (Object)schemaValueMap);
                    schemaValueMaps.add(schemaValueMap);
                }
            }
            SchemaElement dimToAdd = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).model(dim.getModelId()).id(dim.getId()).name(dim.getName()).bizName(dim.getBizName()).type(SchemaElementType.DIMENSION).useCnt(dim.getUseCnt()).alias(alias).schemaValueMaps(schemaValueMaps).isTag(dim.getIsTag()).description(dim.getDescription()).build();
            dimensions.add(dimToAdd);
        }
        return dimensions;
    }

    private static Set<SchemaElement> getDimensionValues(DataSetSchemaResp resp) {
        HashSet<SchemaElement> dimensionValues = new HashSet<SchemaElement>();
        for (DimSchemaResp dim : resp.getDimensions()) {
            HashSet<String> dimValueAlias = new HashSet<String>();
            List dimValueMaps = dim.getDimValueMaps();
            if (!CollectionUtils.isEmpty((Collection)dimValueMaps)) {
                for (DimValueMap dimValueMap : dimValueMaps) {
                    if (StringUtils.isNotEmpty((CharSequence)dimValueMap.getBizName())) {
                        dimValueAlias.add(dimValueMap.getBizName());
                    }
                    if (CollectionUtils.isEmpty((Collection)dimValueMap.getAlias())) continue;
                    dimValueAlias.addAll(dimValueMap.getAlias());
                }
            }
            SchemaElement dimValueToAdd = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).model(dim.getModelId()).id(dim.getId()).name(dim.getName()).bizName(dim.getBizName()).type(SchemaElementType.VALUE).useCnt(dim.getUseCnt()).alias(new ArrayList<String>(Arrays.asList(dimValueAlias.toArray(new String[0])))).isTag(dim.getIsTag()).description(dim.getDescription()).build();
            dimensionValues.add(dimValueToAdd);
        }
        return dimensionValues;
    }

    private static Set<SchemaElement> getMetrics(DataSetSchemaResp resp) {
        HashSet<SchemaElement> metrics = new HashSet<SchemaElement>();
        for (MetricSchemaResp metric : resp.getMetrics()) {
            List alias = SchemaItem.getAliasList((String)metric.getAlias());
            SchemaElement metricToAdd = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).model(metric.getModelId()).id(metric.getId()).name(metric.getName()).bizName(metric.getBizName()).type(SchemaElementType.METRIC).useCnt(metric.getUseCnt()).alias(alias).relatedSchemaElements(DataSetSchemaBuilder.getRelateSchemaElement(metric)).defaultAgg(metric.getDefaultAgg()).dataFormatType(metric.getDataFormatType()).isTag(metric.getIsTag()).description(metric.getDescription()).build();
            metrics.add(metricToAdd);
        }
        return metrics;
    }

    private static Set<SchemaElement> getTerms(DataSetSchemaResp resp) {
        HashSet<SchemaElement> terms = new HashSet<SchemaElement>();
        for (TermResp termResp : resp.getTermResps()) {
            List alias = termResp.getAlias();
            SchemaElement metricToAdd = SchemaElement.builder().dataSet(resp.getId()).dataSetName(resp.getName()).model(Long.valueOf(-1L)).id(termResp.getId()).name(termResp.getName()).bizName(termResp.getName()).type(SchemaElementType.TERM).useCnt(Long.valueOf(0L)).alias(alias).description(termResp.getDescription()).build();
            terms.add(metricToAdd);
        }
        return terms;
    }

    private static List<RelatedSchemaElement> getRelateSchemaElement(MetricSchemaResp metricSchemaResp) {
        RelateDimension relateDimension = metricSchemaResp.getRelateDimension();
        if (relateDimension == null || CollectionUtils.isEmpty((Collection)relateDimension.getDrillDownDimensions())) {
            return Lists.newArrayList();
        }
        return relateDimension.getDrillDownDimensions().stream().map(dimension -> {
            RelatedSchemaElement relateSchemaElement = new RelatedSchemaElement();
            BeanUtils.copyProperties((Object)dimension, (Object)relateSchemaElement);
            return relateSchemaElement;
        }).collect(Collectors.toList());
    }
}

