/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.Constants;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.Order;
import com.tencent.supersonic.common.pojo.enums.AggOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.pojo.enums.TaskStatusEnum;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.Dim;
import com.tencent.supersonic.headless.api.pojo.ItemValueConfig;
import com.tencent.supersonic.headless.api.pojo.request.DictItemReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DictItemResp;
import com.tencent.supersonic.headless.api.pojo.response.DictTaskResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.persistence.dataobject.DictConfDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.DictTaskDO;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DictUtils {
    private static final Logger log = LoggerFactory.getLogger(DictUtils.class);
    @Value(value="${s2.dimension.multi.value.split:#}")
    private String dimMultiValueSplit;
    @Value(value="${s2.item.value.max.count:100000}")
    private Long itemValueMaxCount;
    @Value(value="${s2.item.value.white.frequency:999999}")
    private Long itemValueWhiteFrequency;
    @Value(value="${s2.item.value.date.start:1}")
    private Integer itemValueDateStart;
    @Value(value="${s2.item.value.date.end:1}")
    private Integer itemValueDateEnd;
    private final DimensionService dimensionService;
    private final MetricService metricService;
    private final SemanticLayerService queryService;
    private final ModelService modelService;
    private final TagMetaService tagMetaService;

    public DictUtils(DimensionService dimensionService, MetricService metricService, SemanticLayerService queryService, ModelService modelService, @Lazy TagMetaService tagMetaService) {
        this.dimensionService = dimensionService;
        this.metricService = metricService;
        this.queryService = queryService;
        this.modelService = modelService;
        this.tagMetaService = tagMetaService;
    }

    public String fetchDictFileName(DictItemResp dictItemResp) {
        return String.format("dic_value_%d_%s_%s", dictItemResp.getModelId(), dictItemResp.getType().name(), dictItemResp.getItemId());
    }

    public DictTaskDO generateDictTaskDO(DictItemResp dictItemResp, User user, TaskStatusEnum status) {
        DictTaskDO taskDO = new DictTaskDO();
        Date createAt = new Date();
        String name = dictItemResp.fetchDictFileName();
        taskDO.setName(name);
        taskDO.setType(dictItemResp.getType().name());
        taskDO.setItemId(dictItemResp.getItemId());
        taskDO.setConfig(JsonUtil.toString((Object)dictItemResp.getConfig()));
        taskDO.setStatus(status.getStatus());
        taskDO.setCreatedAt(createAt);
        String creator = Objects.isNull(user) || StringUtils.isEmpty((CharSequence)user.getName()) ? "" : user.getName();
        taskDO.setCreatedBy(creator);
        return taskDO;
    }

    public DictConfDO generateDictConfDO(DictItemReq itemValueReq, User user) {
        DictConfDO confDO = new DictConfDO();
        BeanUtils.copyProperties((Object)itemValueReq, (Object)confDO);
        confDO.setType(itemValueReq.getType().name());
        confDO.setConfig(JsonUtil.toString((Object)itemValueReq.getConfig()));
        Date createAt = new Date();
        confDO.setCreatedAt(createAt);
        String creator = StringUtils.isEmpty((CharSequence)user.getName()) ? "" : user.getName();
        confDO.setCreatedBy(creator);
        confDO.setStatus(itemValueReq.getStatus().name());
        return confDO;
    }

    public List<DictItemResp> dictDOList2Req(List<DictConfDO> dictConfDOList) {
        ArrayList<DictItemResp> dictItemReqList = new ArrayList<DictItemResp>();
        dictConfDOList.stream().forEach(conf -> dictItemReqList.add(this.dictDO2Req((DictConfDO)conf)));
        return dictItemReqList;
    }

    public DictItemResp dictDO2Req(DictConfDO dictConfDO) {
        DictItemResp dictItemResp = new DictItemResp();
        BeanUtils.copyProperties((Object)dictConfDO, (Object)dictItemResp);
        dictItemResp.setType(TypeEnums.valueOf((String)dictConfDO.getType()));
        dictItemResp.setConfig((ItemValueConfig)JsonUtil.toObject((String)dictConfDO.getConfig(), ItemValueConfig.class));
        dictItemResp.setStatus(StatusEnum.of((String)dictConfDO.getStatus()));
        if (TypeEnums.DIMENSION.equals((Object)TypeEnums.valueOf((String)dictConfDO.getType()))) {
            DimensionResp dimension = this.dimensionService.getDimension(dictConfDO.getItemId());
            dictItemResp.setModelId(dimension.getModelId());
            dictItemResp.setBizName(dimension.getBizName());
        }
        if (TypeEnums.TAG.equals((Object)TypeEnums.valueOf((String)dictConfDO.getType()))) {
            TagResp tagResp = this.tagMetaService.getTag(dictConfDO.getItemId(), User.getFakeUser());
            dictItemResp.setModelId(tagResp.getModelId());
            dictItemResp.setBizName(tagResp.getBizName());
        }
        return dictItemResp;
    }

    public List<String> fetchItemValue(DictItemResp dictItemResp) {
        ArrayList<String> lines = new ArrayList<String>();
        SemanticQueryReq semanticQueryReq = this.constructQueryReq(dictItemResp);
        semanticQueryReq.setNeedAuth(false);
        String bizName = dictItemResp.getBizName();
        try {
            SemanticQueryResp semanticQueryResp = this.queryService.queryByReq(semanticQueryReq, null);
            if (Objects.isNull(semanticQueryResp) || CollectionUtils.isEmpty((Collection)semanticQueryResp.getResultList())) {
                return lines;
            }
            HashMap<String, Long> valueAndFrequencyPair = new HashMap<String, Long>(2000);
            for (Map line : semanticQueryResp.getResultList()) {
                if (CollectionUtils.isEmpty((Map)line) || !line.containsKey(bizName) || line.get(bizName) == null || line.size() != 2) continue;
                String dimValue = line.get(bizName).toString();
                Object metricObject = null;
                for (String key : line.keySet()) {
                    if (bizName.equalsIgnoreCase(key)) continue;
                    metricObject = line.get(key);
                }
                if (StringUtils.isEmpty((CharSequence)dimValue) || !Objects.nonNull(metricObject)) continue;
                Long metric = Math.round(Double.parseDouble(metricObject.toString()));
                this.mergeMultivaluedValue(valueAndFrequencyPair, dimValue, metric);
            }
            String nature = dictItemResp.getNature();
            this.constructDictLines(valueAndFrequencyPair, lines, nature);
            this.addWhiteValueLines(dictItemResp, lines, nature);
        }
        catch (Exception e) {
            log.error("dictItemResp:{},fetchItemValue error:", (Object)dictItemResp, (Object)e);
        }
        return lines;
    }

    private void addWhiteValueLines(DictItemResp dictItemResp, List<String> lines, String nature) {
        if (Objects.isNull(dictItemResp) || Objects.isNull(dictItemResp.getConfig()) || CollectionUtils.isEmpty((Collection)dictItemResp.getConfig().getWhiteList())) {
            return;
        }
        List whiteList = dictItemResp.getConfig().getWhiteList();
        whiteList.forEach(white -> {
            if (!StringUtils.isEmpty((CharSequence)white)) {
                white = white.replace(Constants.SPACE, Constants.POUND);
            }
            lines.add(String.format("%s %s %s", white, nature, this.itemValueWhiteFrequency));
        });
    }

    private void constructDictLines(Map<String, Long> valueAndFrequencyPair, List<String> lines, String nature) {
        if (CollectionUtils.isEmpty(valueAndFrequencyPair)) {
            return;
        }
        valueAndFrequencyPair.forEach((value, frequency) -> {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                value = value.replace(Constants.SPACE, Constants.POUND);
            }
            lines.add(String.format("%s %s %s", value, nature, frequency));
        });
    }

    private void mergeMultivaluedValue(Map<String, Long> valueAndFrequencyPair, String dimValue, Long metric) {
        if (StringUtils.isEmpty((CharSequence)dimValue)) {
            return;
        }
        HashMap<String, Long> tmp = new HashMap<String, Long>();
        if (dimValue.contains(this.dimMultiValueSplit)) {
            Arrays.stream(dimValue.split(this.dimMultiValueSplit)).forEach(dimValueSingle -> tmp.put((String)dimValueSingle, metric));
        } else {
            tmp.put(dimValue, metric);
        }
        for (String value : tmp.keySet()) {
            long metricOld = valueAndFrequencyPair.containsKey(value) ? valueAndFrequencyPair.get(value) : 0L;
            valueAndFrequencyPair.put(value, metric + metricOld);
        }
    }

    private SemanticQueryReq constructQueryReq(DictItemResp dictItemResp) {
        if (TypeEnums.DIMENSION.equals((Object)dictItemResp.getType())) {
            return this.constructDimQueryReq(dictItemResp);
        }
        log.warn("constructQueryReq failed");
        return null;
    }

    private QuerySqlReq constructTagQueryReq(DictItemResp dictItemResp) {
        String sqlPattern = "select %s, %s from tbl %s group by %s order by %s desc limit %d";
        String bizName = dictItemResp.getBizName();
        String whereStr = this.generateWhereStr(dictItemResp);
        Object where = StringUtils.isEmpty((CharSequence)whereStr) ? "" : "WHERE" + whereStr;
        ItemValueConfig config = dictItemResp.getConfig();
        Long limit = Objects.isNull(config) || Objects.isNull(config.getLimit()) ? this.itemValueMaxCount : dictItemResp.getConfig().getLimit();
        HashSet<Long> modelIds = new HashSet<Long>();
        String metric = "count(1)";
        if (Objects.nonNull(dictItemResp.getConfig()) && Objects.nonNull(dictItemResp.getConfig().getMetricId())) {
            Long metricId = dictItemResp.getConfig().getMetricId();
            MetricResp metricResp = this.metricService.getMetric(metricId);
            String metricBizName = metricResp.getBizName();
            metric = String.format("sum(%s)", metricBizName);
            modelIds.add(metricResp.getModelId());
        }
        String sql = String.format(sqlPattern, bizName, metric, where, bizName, metric, limit);
        modelIds.add(dictItemResp.getModelId());
        QuerySqlReq querySqlReq = new QuerySqlReq();
        querySqlReq.setSql(sql);
        querySqlReq.setNeedAuth(false);
        querySqlReq.setModelIds(modelIds);
        return querySqlReq;
    }

    private QuerySqlReq constructDimQueryReq(DictItemResp dictItemResp) {
        if (Objects.nonNull(dictItemResp) && Objects.nonNull(dictItemResp.getConfig()) && Objects.nonNull(dictItemResp.getConfig().getMetricId())) {
            QueryStructReq queryStructReq = this.generateQueryStruct(dictItemResp);
            return queryStructReq.convert(true);
        }
        return this.constructQuerySqlReq(dictItemResp);
    }

    private QuerySqlReq constructQuerySqlReq(DictItemResp dictItemResp) {
        String sqlPattern = "select %s,count(1) from tbl %s group by %s order by count(1) desc limit %d";
        String bizName = dictItemResp.getBizName();
        String whereStr = this.generateWhereStr(dictItemResp);
        Object where = StringUtils.isEmpty((CharSequence)whereStr) ? "" : "WHERE" + whereStr;
        ItemValueConfig config = dictItemResp.getConfig();
        Long limit = Objects.isNull(config) || Objects.isNull(config.getLimit()) ? this.itemValueMaxCount : dictItemResp.getConfig().getLimit();
        String sql = String.format(sqlPattern, bizName, where, bizName, limit);
        HashSet<Long> modelIds = new HashSet<Long>();
        modelIds.add(dictItemResp.getModelId());
        QuerySqlReq querySqlReq = new QuerySqlReq();
        querySqlReq.setSql(sql);
        querySqlReq.setNeedAuth(false);
        querySqlReq.setModelIds(modelIds);
        return querySqlReq;
    }

    private QueryStructReq generateQueryStruct(DictItemResp dictItemResp) {
        QueryStructReq queryStructReq = new QueryStructReq();
        HashSet<Long> modelIds = new HashSet<Long>(Arrays.asList(dictItemResp.getModelId()));
        ArrayList<String> groups = new ArrayList<String>(Arrays.asList(dictItemResp.getBizName()));
        queryStructReq.setGroups(groups);
        List<Filter> filters = this.generateFilters(dictItemResp);
        queryStructReq.setDimensionFilters(filters);
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        Long metricId = dictItemResp.getConfig().getMetricId();
        MetricResp metric = this.metricService.getMetric(metricId);
        String metricBizName = metric.getBizName();
        aggregators.add(new Aggregator(metricBizName, AggOperatorEnum.SUM));
        queryStructReq.setAggregators(aggregators);
        modelIds.add(metric.getModelId());
        queryStructReq.setModelIds(modelIds);
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.add(new Order(metricBizName, Constants.DESC_UPPER));
        queryStructReq.setOrders(orders);
        this.fillStructDateInfo(queryStructReq, dictItemResp);
        Long limit = Objects.isNull(dictItemResp.getConfig().getLimit()) ? this.itemValueMaxCount : dictItemResp.getConfig().getLimit();
        queryStructReq.setLimit(limit);
        queryStructReq.setNeedAuth(false);
        return queryStructReq;
    }

    private void fillStructDateInfo(QueryStructReq queryStructReq, DictItemResp dictItemResp) {
        List timeDims;
        ModelResp model = this.modelService.getModel(dictItemResp.getModelId());
        if (Objects.nonNull(model) && !CollectionUtils.isEmpty((Collection)(timeDims = model.getTimeDimension()))) {
            DateConf dateConf = new DateConf();
            dateConf.setDateMode(DateConf.DateMode.BETWEEN);
            String format = ((Dim)timeDims.get(0)).getDateFormat();
            String start = LocalDate.now().minusDays(this.itemValueDateStart.intValue()).format(DateTimeFormatter.ofPattern(format));
            String end = LocalDate.now().minusDays(this.itemValueDateEnd.intValue()).format(DateTimeFormatter.ofPattern(format));
            dateConf.setStartDate(start);
            dateConf.setEndDate(end);
            queryStructReq.setDateInfo(dateConf);
        }
    }

    private List<Filter> generateFilters(DictItemResp dictItemResp) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (Objects.isNull(dictItemResp)) {
            return new ArrayList<Filter>();
        }
        String whereStr = this.generateWhereStr(dictItemResp);
        if (StringUtils.isEmpty((CharSequence)whereStr)) {
            return new ArrayList<Filter>();
        }
        Filter filter = new Filter("", FilterOperatorEnum.SQL_PART, (Object)whereStr);
        filters.add(filter);
        return filters;
    }

    public String generateWhereStr(DictItemResp dictItemResp) {
        List timeDims;
        ModelResp model;
        StringJoiner joiner = new StringJoiner(Constants.SPACE + Constants.AND_UPPER + Constants.SPACE);
        String bizName = dictItemResp.getBizName();
        ItemValueConfig config = dictItemResp.getConfig();
        if (Objects.nonNull(config)) {
            if (!CollectionUtils.isEmpty((Collection)config.getBlackList())) {
                StringJoiner joinerBlack = new StringJoiner(",");
                config.getBlackList().stream().forEach(black -> joinerBlack.add("'" + black + "'"));
                joiner.add(String.format("(%s not in (%s))", bizName, joinerBlack.toString()));
            }
            if (!CollectionUtils.isEmpty((Collection)config.getRuleList())) {
                config.getRuleList().stream().forEach(rule -> joiner.add("(" + rule + ")"));
            }
        }
        if (Objects.nonNull(model = this.modelService.getModel(dictItemResp.getModelId())) && !CollectionUtils.isEmpty((Collection)(timeDims = model.getTimeDimension()))) {
            String format = "yyyy-MM-dd";
            String start = LocalDate.now().minusDays(this.itemValueDateStart.intValue()).format(DateTimeFormatter.ofPattern(format));
            String end = LocalDate.now().minusDays(this.itemValueDateEnd.intValue()).format(DateTimeFormatter.ofPattern(format));
            joiner.add(String.format("( %s >= '%s' and %s <= '%s' )", TimeDimensionEnum.DAY.getName(), start, TimeDimensionEnum.DAY.getName(), end));
        }
        return joiner.toString();
    }

    public DictTaskResp taskDO2Resp(DictTaskDO dictTaskDO) {
        DictTaskResp resp = new DictTaskResp();
        BeanUtils.copyProperties((Object)dictTaskDO, (Object)resp);
        resp.setTaskStatus(dictTaskDO.getStatus());
        resp.setType(TypeEnums.valueOf((String)dictTaskDO.getType()));
        resp.setConfig((ItemValueConfig)JsonUtil.toObject((String)dictTaskDO.getConfig(), ItemValueConfig.class));
        return resp;
    }
}

