/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.headless.api.pojo.request.DomainReq;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.DomainDO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class DomainConvert {
    public static DomainDO convert(DomainReq domainReq, User user) {
        DomainDO domainDO = new DomainDO();
        domainReq.createdBy(user.getName());
        BeanUtils.copyProperties((Object)domainReq, (Object)domainDO);
        domainDO.setAdmin(String.join((CharSequence)",", domainReq.getAdmins()));
        domainDO.setAdminOrg(String.join((CharSequence)",", domainReq.getAdminOrgs()));
        domainDO.setViewer(String.join((CharSequence)",", domainReq.getViewers()));
        domainDO.setViewOrg(String.join((CharSequence)",", domainReq.getViewOrgs()));
        return domainDO;
    }

    public static DomainResp convert(DomainDO domainDO, Map<Long, String> domainFullPathMap) {
        DomainResp domainResp = new DomainResp();
        BeanUtils.copyProperties((Object)domainDO, (Object)domainResp);
        domainResp.setFullPath(domainFullPathMap.get(domainDO.getId()));
        domainResp.setAdmins((List)(StringUtils.isBlank((CharSequence)domainDO.getAdmin()) ? Lists.newArrayList() : Arrays.asList(domainDO.getAdmin().split(","))));
        domainResp.setAdminOrgs((List)(StringUtils.isBlank((CharSequence)domainDO.getAdminOrg()) ? Lists.newArrayList() : Arrays.asList(domainDO.getAdminOrg().split(","))));
        domainResp.setViewers((List)(StringUtils.isBlank((CharSequence)domainDO.getViewer()) ? Lists.newArrayList() : Arrays.asList(domainDO.getViewer().split(","))));
        domainResp.setViewOrgs((List)(StringUtils.isBlank((CharSequence)domainDO.getViewOrg()) ? Lists.newArrayList() : Arrays.asList(domainDO.getViewOrg().split(","))));
        return domainResp;
    }

    public static DomainResp convert(DomainDO domainDO) {
        return DomainConvert.convert(domainDO, new HashMap<Long, String>());
    }
}

