/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.response.ModelSchemaResp;
import com.tencent.supersonic.headless.server.pojo.ModelCluster;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ModelClusterBuilder {
    public static Map<String, ModelCluster> buildModelClusters(List<Long> modelIds) {
        SchemaService schemaService = (SchemaService)ContextUtils.getBean(SchemaService.class);
        List<ModelSchemaResp> modelSchemaResps = schemaService.fetchModelSchemaResps(modelIds);
        Map<Long, ModelSchemaResp> modelIdToModelSchema = modelSchemaResps.stream().collect(Collectors.toMap(SchemaItem::getId, value -> value, (k1, k2) -> k1));
        HashSet<Long> visited = new HashSet<Long>();
        ArrayList<HashSet<Long>> modelClusters = new ArrayList<HashSet<Long>>();
        for (ModelSchemaResp model : modelSchemaResps) {
            if (visited.contains(model.getId())) continue;
            HashSet<Long> modelCluster = new HashSet<Long>();
            ModelClusterBuilder.dfs(model, modelIdToModelSchema, visited, modelCluster);
            modelClusters.add(modelCluster);
        }
        return modelClusters.stream().map(ModelCluster::build).collect(Collectors.toMap(ModelCluster::getKey, value -> value, (k1, k2) -> k1));
    }

    private static void dfs(ModelSchemaResp model, Map<Long, ModelSchemaResp> modelMap, Set<Long> visited, Set<Long> modelCluster) {
        visited.add(model.getId());
        modelCluster.add(model.getId());
        for (Long neighborId : model.getModelClusterSet()) {
            if (visited.contains(neighborId)) continue;
            ModelClusterBuilder.dfs(modelMap.get(neighborId), modelMap, visited, modelCluster);
        }
    }
}

