/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.ItemDateResp;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.common.util.DateModeUtils;
import com.tencent.supersonic.common.util.SqlFilterUtils;
import com.tencent.supersonic.headless.api.pojo.ItemDateFilter;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QueryStructUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryStructUtils.class);
    public static Set<String> internalTimeCols = new HashSet<String>(Arrays.asList("dayno", "sys_imp_date", "sys_imp_week", "sys_imp_month"));
    public static Set<String> internalCols = new HashSet<String>(Arrays.asList("plat_sys_var"));
    private final DateModeUtils dateModeUtils;
    private final SqlFilterUtils sqlFilterUtils;
    private final SchemaService schemaService;
    private String variablePrefix = "'${";

    public QueryStructUtils(DateModeUtils dateModeUtils, SqlFilterUtils sqlFilterUtils, SchemaService schemaService) {
        this.dateModeUtils = dateModeUtils;
        this.sqlFilterUtils = sqlFilterUtils;
        this.schemaService = schemaService;
    }

    private List<Long> getDimensionIds(QueryStructReq queryStructReq) {
        ArrayList<Long> dimensionIds = new ArrayList<Long>();
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setDataSetId(queryStructReq.getDataSetId());
        List<DimensionResp> dimensions = this.schemaService.getDimensions(metaFilter);
        Map<String, List<DimensionResp>> pair = dimensions.stream().collect(Collectors.groupingBy(SchemaItem::getBizName));
        for (String group : queryStructReq.getGroups()) {
            if (!pair.containsKey(group)) continue;
            dimensionIds.add(pair.get(group).get(0).getId());
        }
        List filtersCols = this.sqlFilterUtils.getFiltersCol(queryStructReq.getOriginalFilter());
        for (String col : filtersCols) {
            if (!pair.containsKey(col)) continue;
            dimensionIds.add(pair.get(col).get(0).getId());
        }
        return dimensionIds;
    }

    private List<Long> getMetricIds(QueryStructReq queryStructCmd) {
        ArrayList<Long> metricIds = new ArrayList<Long>();
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setDataSetId(queryStructCmd.getDataSetId());
        List<MetricResp> metrics = this.schemaService.getMetrics(metaFilter);
        Map<String, List<MetricResp>> pair = metrics.stream().collect(Collectors.groupingBy(SchemaItem::getBizName));
        for (Aggregator agg : queryStructCmd.getAggregators()) {
            if (!pair.containsKey(agg.getColumn())) continue;
            metricIds.add(pair.get(agg.getColumn()).get(0).getId());
        }
        List filtersCols = this.sqlFilterUtils.getFiltersCol(queryStructCmd.getOriginalFilter());
        for (String col : filtersCols) {
            if (!pair.containsKey(col)) continue;
            metricIds.add(pair.get(col).get(0).getId());
        }
        return metricIds;
    }

    public Set<String> getResNameEn(QueryStructReq queryStructCmd) {
        HashSet<String> resNameEnSet = new HashSet<String>();
        queryStructCmd.getAggregators().stream().forEach(agg -> resNameEnSet.add(agg.getColumn()));
        resNameEnSet.addAll(queryStructCmd.getGroups());
        queryStructCmd.getOrders().stream().forEach(order -> resNameEnSet.add(order.getColumn()));
        this.sqlFilterUtils.getFiltersCol(queryStructCmd.getOriginalFilter()).stream().forEach(col -> resNameEnSet.add((String)col));
        return resNameEnSet;
    }

    public Set<String> getResName(QuerySqlReq querySqlReq) {
        Set<String> resNameSet = SqlSelectHelper.getAllFields((String)querySqlReq.getSql()).stream().collect(Collectors.toSet());
        return resNameSet;
    }

    public Set<String> getResNameEnExceptInternalCol(QueryStructReq queryStructCmd) {
        Set<String> resNameEnSet = this.getResNameEn(queryStructCmd);
        return resNameEnSet.stream().filter(res -> !internalCols.contains(res)).collect(Collectors.toSet());
    }

    public Set<String> getResNameEnExceptInternalCol(QuerySqlReq querySqlReq, SemanticSchemaResp semanticSchemaResp) {
        Set<String> resNameSet = this.getResName(querySqlReq);
        HashSet resNameEnSet = new HashSet();
        if (semanticSchemaResp != null) {
            List metrics = semanticSchemaResp.getMetrics();
            List dimensions = semanticSchemaResp.getDimensions();
            metrics.stream().forEach(o -> {
                if (resNameSet.contains(o.getName()) || resNameSet.contains(o.getBizName())) {
                    resNameEnSet.add(o.getBizName());
                }
            });
            dimensions.stream().forEach(o -> {
                if (resNameSet.contains(o.getName()) || resNameSet.contains(o.getBizName())) {
                    resNameEnSet.add(o.getBizName());
                }
            });
        }
        return resNameEnSet.stream().filter(res -> !internalCols.contains(res)).collect(Collectors.toSet());
    }

    public Set<String> getFilterResNameEn(QueryStructReq queryStructCmd) {
        HashSet<String> resNameEnSet = new HashSet<String>();
        this.sqlFilterUtils.getFiltersCol(queryStructCmd.getOriginalFilter()).stream().forEach(col -> resNameEnSet.add((String)col));
        return resNameEnSet;
    }

    public Set<String> getFilterResNameEnExceptInternalCol(QueryStructReq queryStructCmd) {
        Set<String> resNameEnSet = this.getFilterResNameEn(queryStructCmd);
        return resNameEnSet.stream().filter(res -> !internalCols.contains(res)).collect(Collectors.toSet());
    }

    public Set<String> getFilterResNameEnExceptInternalCol(QuerySqlReq querySqlReq) {
        String sql = querySqlReq.getSql();
        Set resNameEnSet = SqlSelectHelper.getWhereFields((String)sql).stream().collect(Collectors.toSet());
        return resNameEnSet.stream().filter(res -> !internalCols.contains(res)).collect(Collectors.toSet());
    }

    public ItemDateResp getItemDateResp(QueryStructReq queryStructCmd) {
        List<Long> dimensionIds = this.getDimensionIds(queryStructCmd);
        List<Long> metricIds = this.getMetricIds(queryStructCmd);
        ItemDateResp dateDate = this.schemaService.getItemDate(new ItemDateFilter(dimensionIds, TypeEnums.DIMENSION.name()), new ItemDateFilter(metricIds, TypeEnums.METRIC.name()));
        return dateDate;
    }

    public Triple<String, String, String> getBeginEndTime(QueryStructReq queryStructCmd) {
        if (Objects.isNull(queryStructCmd.getDateInfo())) {
            return Triple.of((Object)"", (Object)"", (Object)"");
        }
        DateConf dateConf = queryStructCmd.getDateInfo();
        String dateInfo = this.dateModeUtils.getSysDateCol(dateConf);
        if (dateInfo.isEmpty()) {
            return Triple.of((Object)"", (Object)"", (Object)"");
        }
        switch (dateConf.getDateMode()) {
            case AVAILABLE: 
            case BETWEEN: {
                return Triple.of((Object)dateInfo, (Object)dateConf.getStartDate(), (Object)dateConf.getEndDate());
            }
            case LIST: {
                return Triple.of((Object)dateInfo, (Object)((String)Collections.min(dateConf.getDateList())), (Object)((String)Collections.max(dateConf.getDateList())));
            }
            case RECENT: {
                ItemDateResp dateDate = this.getItemDateResp(queryStructCmd);
                LocalDate dateMax = LocalDate.now().minusDays(1L);
                LocalDate dateMin = dateMax.minusDays(dateConf.getUnit() - 1);
                if (Objects.isNull(dateDate)) {
                    return Triple.of((Object)dateInfo, (Object)dateMin.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), (Object)dateMax.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                switch (dateConf.getPeriod()) {
                    case "DAY": {
                        ImmutablePair dayInfo = this.dateModeUtils.recentDay(dateDate, dateConf);
                        return Triple.of((Object)dateInfo, (Object)((String)dayInfo.left), (Object)((String)dayInfo.right));
                    }
                    case "WEEK": {
                        ImmutablePair weekInfo = this.dateModeUtils.recentWeek(dateDate, dateConf);
                        return Triple.of((Object)dateInfo, (Object)((String)weekInfo.left), (Object)((String)weekInfo.right));
                    }
                    case "MONTH": {
                        List rets = this.dateModeUtils.recentMonth(dateDate, dateConf);
                        Optional<String> minBegins = rets.stream().map(i -> (String)i.left).sorted().findFirst();
                        Optional<String> maxBegins = rets.stream().map(i -> (String)i.right).sorted(Comparator.reverseOrder()).findFirst();
                        if (!minBegins.isPresent() || !maxBegins.isPresent()) break;
                        return Triple.of((Object)dateInfo, (Object)minBegins.get(), (Object)maxBegins.get());
                    }
                }
                break;
            }
        }
        return Triple.of((Object)"", (Object)"", (Object)"");
    }

    public DateConf getDateConfBySql(String sql) {
        List fieldExpressions = SqlSelectHelper.getFilterExpression((String)sql);
        if (!CollectionUtils.isEmpty((Collection)fieldExpressions)) {
            HashSet<String> dateList = new HashSet<String>();
            String startDate = "";
            String endDate = "";
            String period = "";
            for (FieldExpression f : fieldExpressions) {
                if (Objects.isNull(f.getFieldName()) || !internalCols.contains(f.getFieldName().toLowerCase()) || Objects.isNull(f.getFieldValue()) || !this.dateModeUtils.isDateStr(f.getFieldValue().toString()) || "".equals(period = this.dateModeUtils.getPeriodByCol(f.getFieldName().toLowerCase()))) continue;
                if ("=".equals(f.getOperator())) {
                    dateList.add(f.getFieldValue().toString());
                    continue;
                }
                if ("<".equals(f.getOperator()) || "<=".equals(f.getOperator())) {
                    if (!startDate.isEmpty() && startDate.compareTo(f.getFieldValue().toString()) <= 0) continue;
                    startDate = f.getFieldValue().toString();
                    continue;
                }
                if (!">".equals(f.getOperator()) && !">=".equals(f.getOperator()) || !endDate.isEmpty() && endDate.compareTo(f.getFieldValue().toString()) >= 0) continue;
                endDate = f.getFieldValue().toString();
            }
            if (!"".equals(period)) {
                DateConf dateConf = new DateConf();
                dateConf.setPeriod(period);
                if (!CollectionUtils.isEmpty(dateList)) {
                    dateConf.setDateList(new ArrayList(dateList));
                    dateConf.setDateMode(DateConf.DateMode.LIST);
                    return dateConf;
                }
                if (!"".equals(startDate) && !"".equals(endDate)) {
                    dateConf.setStartDate(startDate);
                    dateConf.setEndDate(endDate);
                    dateConf.setDateMode(DateConf.DateMode.BETWEEN);
                    return dateConf;
                }
            }
        }
        return null;
    }

    public List<String> getDateCol() {
        return this.dateModeUtils.getDateCol();
    }

    public String getVariablePrefix() {
        return this.variablePrefix;
    }

    static {
        internalCols.addAll(internalTimeCols);
    }
}

