/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.SemanticType;
import com.tencent.supersonic.headless.api.pojo.request.QueryMultiStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.core.pojo.QueryStatement;
import com.tencent.supersonic.headless.core.utils.SqlGenerateUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class QueryUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryUtils.class);
    private static final String pattern = "\\(`(.*?)`\\)";
    private static final String no_quotation_pattern = "\\((.*?)\\)";
    private final Set<Pattern> patterns = new HashSet<Pattern>();
    @Value(value="${s2.query-optimizer.enable:true}")
    private Boolean optimizeEnable;

    @PostConstruct
    public void fillPattern() {
        HashSet<String> aggFunctions = new HashSet<String>(Arrays.asList("MAX", "MIN", "SUM", "AVG"));
        String patternStr = "\\s*(%s\\((.*)\\)) AS";
        for (String agg : aggFunctions) {
            this.patterns.add(Pattern.compile(String.format(patternStr, agg)));
        }
    }

    public void fillItemNameInfo(SemanticQueryResp semanticQueryResp, SemanticSchemaResp semanticSchemaResp) {
        List metricDescList = semanticSchemaResp.getMetrics();
        List dimSchemaResps = semanticSchemaResp.getDimensions();
        Map<String, MetricResp> metricRespMap = metricDescList.stream().collect(Collectors.toMap(SchemaItem::getBizName, a -> a, (k1, k2) -> k1));
        HashMap<String, String> namePair = new HashMap<String, String>();
        HashMap<String, String> nameTypePair = new HashMap<String, String>();
        QueryUtils.addSysTimeDimension(namePair, nameTypePair);
        metricDescList.forEach(metricDesc -> {
            namePair.put(metricDesc.getBizName(), metricDesc.getName());
            nameTypePair.put(metricDesc.getBizName(), SemanticType.NUMBER.name());
        });
        dimSchemaResps.forEach(dimensionDesc -> {
            namePair.put(dimensionDesc.getBizName(), dimensionDesc.getName());
            nameTypePair.put(dimensionDesc.getBizName(), dimensionDesc.getSemanticType());
        });
        List columns = semanticQueryResp.getColumns();
        columns.forEach(column -> {
            String nameEn = this.getName(column.getNameEn().toLowerCase());
            if (nameEn.contains("__")) {
                nameEn = nameEn.split("__")[1];
            }
            if (namePair.containsKey(nameEn)) {
                column.setName((String)namePair.get(nameEn));
            } else {
                String nameEnByRegex = this.getNameEnByRegex(nameEn, pattern);
                if (StringUtils.isEmpty((CharSequence)nameEnByRegex)) {
                    nameEnByRegex = this.getNameEnByRegex(nameEn, no_quotation_pattern);
                }
                if (StringUtils.isNotEmpty((CharSequence)nameEnByRegex) && StringUtils.isNotEmpty((CharSequence)((CharSequence)namePair.get(nameEnByRegex)))) {
                    String filedName = (String)namePair.get(nameEnByRegex);
                    column.setName(nameEn.replaceAll(nameEnByRegex, filedName));
                }
            }
            if (nameTypePair.containsKey(nameEn)) {
                column.setShowType((String)nameTypePair.get(nameEn));
            }
            if (!nameTypePair.containsKey(nameEn) && this.isNumberType(column.getType())) {
                column.setShowType(SemanticType.NUMBER.name());
            }
            if (metricRespMap.containsKey(nameEn)) {
                column.setDataFormatType(((MetricResp)metricRespMap.get(nameEn)).getDataFormatType());
                column.setDataFormat(((MetricResp)metricRespMap.get(nameEn)).getDataFormat());
            }
            if (StringUtils.isEmpty((CharSequence)column.getShowType())) {
                column.setShowType(SemanticType.CATEGORY.name());
            }
        });
    }

    private String getName(String nameEn) {
        Pattern pattern = Pattern.compile(no_quotation_pattern);
        Matcher matcher = pattern.matcher(nameEn);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("`", "");
        }
        return nameEn;
    }

    private String getNameEnByRegex(String nameEn, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(nameEn);
        if (m.find()) {
            String result = m.group(1);
            return result;
        }
        return null;
    }

    private boolean isNumberType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("bigint") || type.equalsIgnoreCase("float") || type.equalsIgnoreCase("double")) {
            return true;
        }
        return type.toLowerCase().startsWith("uint") || type.toLowerCase().startsWith("int");
    }

    private static void addSysTimeDimension(Map<String, String> namePair, Map<String, String> nameTypePair) {
        for (TimeDimensionEnum timeDimensionEnum : TimeDimensionEnum.values()) {
            namePair.put(timeDimensionEnum.getName(), "date");
            nameTypePair.put(timeDimensionEnum.getName(), "DATE");
        }
    }

    public QueryStatement sqlParserUnion(QueryMultiStructReq queryMultiStructCmd, List<QueryStatement> sqlParsers) {
        QueryStatement sqlParser = new QueryStatement();
        StringBuilder unionSqlBuilder = new StringBuilder();
        for (int i = 0; i < sqlParsers.size(); ++i) {
            String selectStr = SqlGenerateUtils.getUnionSelect((QueryStructReq)((QueryStructReq)queryMultiStructCmd.getQueryStructReqs().get(i)));
            unionSqlBuilder.append(String.format("select %s from ( %s ) sub_sql_%s", selectStr, sqlParsers.get(i).getSql(), i));
            unionSqlBuilder.append(" union all ");
        }
        String unionSql = unionSqlBuilder.substring(0, unionSqlBuilder.length() - " union all ".length());
        sqlParser.setSql(unionSql);
        sqlParser.setSourceId(sqlParsers.get(0).getSourceId());
        log.info("union sql parser:{}", (Object)sqlParser);
        return sqlParser;
    }

    public Boolean enableOptimize() {
        return this.optimizeEnable;
    }
}

