/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.TaskStatusEnum;
import com.tencent.supersonic.common.util.SqlFilterUtils;
import com.tencent.supersonic.headless.api.pojo.QueryStat;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.QueryMethod;
import com.tencent.supersonic.headless.api.pojo.enums.QueryOptMode;
import com.tencent.supersonic.headless.api.pojo.enums.QueryTypeBack;
import com.tencent.supersonic.headless.api.pojo.request.ItemUseReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryMultiStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryTagReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.ItemUseResp;
import com.tencent.supersonic.headless.server.persistence.repository.StatRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StatUtils {
    private static final Logger log = LoggerFactory.getLogger(StatUtils.class);
    private static final TransmittableThreadLocal<QueryStat> STATS = new TransmittableThreadLocal();
    private final StatRepository statRepository;
    private final SqlFilterUtils sqlFilterUtils;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public StatUtils(StatRepository statRepository, SqlFilterUtils sqlFilterUtils) {
        this.statRepository = statRepository;
        this.sqlFilterUtils = sqlFilterUtils;
    }

    public static QueryStat get() {
        return (QueryStat)STATS.get();
    }

    public static void set(QueryStat queryStatInfo) {
        STATS.set((Object)queryStatInfo);
    }

    public static void remove() {
        STATS.remove();
    }

    public void statInfo2DbAsync(TaskStatusEnum state) {
        QueryStat queryStatInfo = StatUtils.get();
        queryStatInfo.setElapsedMs(Long.valueOf(System.currentTimeMillis() - queryStatInfo.getStartTime()));
        queryStatInfo.setQueryState(state.getStatus());
        CompletableFuture.runAsync(() -> this.statRepository.createRecord(queryStatInfo)).exceptionally(exception -> {
            log.warn("queryStatInfo, exception:", exception);
            return null;
        });
        StatUtils.remove();
    }

    public Boolean updateResultCacheKey(String key) {
        ((QueryStat)STATS.get()).setResultCacheKey(key);
        return true;
    }

    public void initStatInfo(SemanticQueryReq semanticQueryReq, User facadeUser) {
        if (semanticQueryReq instanceof QuerySqlReq) {
            this.initSqlStatInfo((QuerySqlReq)semanticQueryReq, facadeUser);
        }
        if (semanticQueryReq instanceof QueryStructReq) {
            this.initStructStatInfo((QueryStructReq)semanticQueryReq, facadeUser);
        }
        if (semanticQueryReq instanceof QueryMultiStructReq) {
            QueryStructReq queryStructCmd = (QueryStructReq)((QueryMultiStructReq)semanticQueryReq).getQueryStructReqs().get(0);
            this.initStructStatInfo(queryStructCmd, facadeUser);
        }
        if (semanticQueryReq instanceof QueryTagReq) {
            this.initTagStatInfo((QueryTagReq)semanticQueryReq, facadeUser);
        }
    }

    public void initTagStatInfo(QueryTagReq queryTagReq, User facadeUser) {
        QueryStat queryStatInfo = new QueryStat();
        String traceId = "";
        List dimensions = queryTagReq.getGroups();
        ArrayList metrics = new ArrayList();
        queryTagReq.getAggregators().stream().forEach(aggregator -> metrics.add(aggregator.getColumn()));
        String user = this.getUserName(facadeUser);
        try {
            queryStatInfo.setTraceId(traceId).setDataSetId(queryTagReq.getDataSetId()).setUser(user).setQueryType(QueryMethod.STRUCT.getValue()).setQueryTypeBack(QueryTypeBack.NORMAL.getState()).setQueryStructCmd(queryTagReq.toString()).setQueryStructCmdMd5(DigestUtils.md5Hex((String)queryTagReq.toString())).setStartTime(Long.valueOf(System.currentTimeMillis())).setNativeQuery(Boolean.valueOf(CollectionUtils.isEmpty((Collection)queryTagReq.getAggregators()))).setGroupByCols(this.objectMapper.writeValueAsString((Object)queryTagReq.getGroups())).setAggCols(this.objectMapper.writeValueAsString((Object)queryTagReq.getAggregators())).setOrderByCols(this.objectMapper.writeValueAsString((Object)queryTagReq.getOrders())).setFilterCols(this.objectMapper.writeValueAsString((Object)this.sqlFilterUtils.getFiltersCol(queryTagReq.getTagFilters()))).setUseResultCache(Boolean.valueOf(true)).setUseSqlCache(Boolean.valueOf(true)).setMetrics(this.objectMapper.writeValueAsString(metrics)).setDimensions(this.objectMapper.writeValueAsString((Object)dimensions)).setQueryOptMode(QueryOptMode.NONE.name());
            if (!CollectionUtils.isEmpty((Collection)queryTagReq.getModelIds())) {
                queryStatInfo.setModelId((Long)queryTagReq.getModelIds().get(0));
            }
        }
        catch (JsonProcessingException e) {
            log.error("", (Throwable)e);
        }
        StatUtils.set(queryStatInfo);
    }

    public void initSqlStatInfo(QuerySqlReq querySqlReq, User facadeUser) {
        QueryStat queryStatInfo = new QueryStat();
        List aggFields = SqlSelectHelper.getAggregateFields((String)querySqlReq.getSql());
        List allFields = SqlSelectHelper.getAllFields((String)querySqlReq.getSql());
        List dimensions = allFields.stream().filter(aggFields::contains).collect(Collectors.toList());
        String userName = this.getUserName(facadeUser);
        try {
            queryStatInfo.setTraceId("").setUser(userName).setDataSetId(querySqlReq.getDataSetId()).setQueryType(QueryMethod.SQL.getValue()).setQueryTypeBack(QueryTypeBack.NORMAL.getState()).setQuerySqlCmd(querySqlReq.toString()).setQuerySqlCmdMd5(DigestUtils.md5Hex((String)querySqlReq.toString())).setStartTime(Long.valueOf(System.currentTimeMillis())).setUseResultCache(Boolean.valueOf(true)).setUseSqlCache(Boolean.valueOf(true)).setMetrics(this.objectMapper.writeValueAsString((Object)aggFields)).setDimensions(this.objectMapper.writeValueAsString(dimensions));
            if (!CollectionUtils.isEmpty((Collection)querySqlReq.getModelIds())) {
                queryStatInfo.setModelId((Long)querySqlReq.getModelIds().get(0));
            }
        }
        catch (JsonProcessingException e) {
            log.error("initStatInfo:{}", (Throwable)e);
        }
        StatUtils.set(queryStatInfo);
    }

    public void initStructStatInfo(QueryStructReq queryStructReq, User facadeUser) {
        QueryStat queryStatInfo = new QueryStat();
        String traceId = "";
        List dimensions = queryStructReq.getGroups();
        ArrayList metrics = new ArrayList();
        queryStructReq.getAggregators().stream().forEach(aggregator -> metrics.add(aggregator.getColumn()));
        String user = this.getUserName(facadeUser);
        try {
            queryStatInfo.setTraceId(traceId).setDataSetId(queryStructReq.getDataSetId()).setUser(user).setQueryType(QueryMethod.STRUCT.getValue()).setQueryTypeBack(QueryTypeBack.NORMAL.getState()).setQueryStructCmd(queryStructReq.toString()).setQueryStructCmdMd5(DigestUtils.md5Hex((String)queryStructReq.toString())).setStartTime(Long.valueOf(System.currentTimeMillis())).setNativeQuery(Boolean.valueOf(queryStructReq.getQueryType().isNativeAggQuery())).setGroupByCols(this.objectMapper.writeValueAsString((Object)queryStructReq.getGroups())).setAggCols(this.objectMapper.writeValueAsString((Object)queryStructReq.getAggregators())).setOrderByCols(this.objectMapper.writeValueAsString((Object)queryStructReq.getOrders())).setFilterCols(this.objectMapper.writeValueAsString((Object)this.sqlFilterUtils.getFiltersCol(queryStructReq.getOriginalFilter()))).setUseResultCache(Boolean.valueOf(true)).setUseSqlCache(Boolean.valueOf(true)).setMetrics(this.objectMapper.writeValueAsString(metrics)).setDimensions(this.objectMapper.writeValueAsString((Object)dimensions)).setQueryOptMode(QueryOptMode.NONE.name());
            if (!CollectionUtils.isEmpty((Collection)queryStructReq.getModelIds())) {
                queryStatInfo.setModelId((Long)queryStructReq.getModelIds().get(0));
            }
        }
        catch (JsonProcessingException e) {
            log.error("", (Throwable)e);
        }
        StatUtils.set(queryStatInfo);
    }

    private List<String> getFieldNames(List<String> allFields, List<? extends SchemaItem> schemaItems) {
        Set fieldNames = schemaItems.stream().map(dimSchemaResp -> dimSchemaResp.getBizName()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(fieldNames)) {
            return allFields.stream().filter(fieldName -> fieldNames.contains(fieldName)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private String getUserName(User facadeUser) {
        return Objects.nonNull(facadeUser) && StringUtils.isNotEmpty((CharSequence)facadeUser.getName()) ? facadeUser.getName() : "Admin";
    }

    public List<ItemUseResp> getStatInfo(ItemUseReq itemUseCommend) {
        return this.statRepository.getStatInfo(itemUseCommend);
    }
}

