/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.CanvasReq;
import com.tencent.supersonic.headless.api.pojo.response.CanvasSchemaResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.CanvasDO;
import com.tencent.supersonic.headless.server.web.service.CanvasService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/viewInfo"})
public class CanvasController {
    @Autowired
    private CanvasService canvasService;

    @PostMapping(value={"/createOrUpdateViewInfo"})
    public CanvasDO createOrUpdateCanvas(@RequestBody CanvasReq canvasReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.canvasService.createOrUpdateCanvas(canvasReq, user);
    }

    @GetMapping(value={"/getViewInfoList/{domainId}"})
    public List<CanvasDO> getCanvasList(@PathVariable(value="domainId") Long domainId) {
        return this.canvasService.getCanvasList(domainId);
    }

    @DeleteMapping(value={"/deleteViewInfo/{id}"})
    public void deleteCanvas(@PathVariable(value="id") Long id) {
        this.canvasService.deleteCanvas(id);
    }

    @GetMapping(value={"/getDomainSchemaRela/{domainId}"})
    public List<CanvasSchemaResp> getDomainSchema(@PathVariable(value="domainId") Long domainId, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.canvasService.getCanvasSchema(domainId, user);
    }
}

