/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.DataSetReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/dataSet"})
public class DataSetController {
    @Autowired
    private DataSetService dataSetService;

    @PostMapping
    public DataSetResp save(@RequestBody DataSetReq dataSetReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.dataSetService.save(dataSetReq, user);
    }

    @PutMapping
    public DataSetResp update(@RequestBody DataSetReq dataSetReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.dataSetService.update(dataSetReq, user);
    }

    @GetMapping(value={"/{id}"})
    public DataSetResp getDataSet(@PathVariable(value="id") Long id) {
        return this.dataSetService.getDataSet(id);
    }

    @GetMapping(value={"/getDataSetList"})
    public List<DataSetResp> getDataSetList(@RequestParam(value="domainId") Long domainId) {
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setDomainId(domainId);
        return this.dataSetService.getDataSetList(metaFilter);
    }

    @DeleteMapping(value={"/{id}"})
    public Boolean delete(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.dataSetService.delete(id, user);
        return true;
    }
}

