/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.DomainReq;
import com.tencent.supersonic.headless.api.pojo.request.DomainUpdateReq;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.server.web.service.DomainService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/domain"})
public class DomainController {
    private DomainService domainService;

    public DomainController(DomainService domainService) {
        this.domainService = domainService;
    }

    @PostMapping(value={"/createDomain"})
    public DomainResp createDomain(@RequestBody DomainReq domainReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.domainService.createDomain(domainReq, user);
    }

    @PostMapping(value={"/updateDomain"})
    public DomainResp updateDomain(@RequestBody DomainUpdateReq domainUpdateReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.domainService.updateDomain(domainUpdateReq, user);
    }

    @DeleteMapping(value={"/deleteDomain/{domainId}"})
    public Boolean deleteDomain(@PathVariable(value="domainId") Long domainId) {
        this.domainService.deleteDomain(domainId);
        return true;
    }

    @GetMapping(value={"/getDomainList"})
    public List<DomainResp> getDomainList(HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.domainService.getDomainListWithAdminAuth(user);
    }

    @GetMapping(value={"/getDomain/{id}"})
    public DomainResp getDomain(@PathVariable(value="id") Long id) {
        return this.domainService.getDomain(id);
    }

    @GetMapping(value={"/getDomainListByIds/{domainIds}"})
    public List<DomainResp> getDomainListByIds(@PathVariable(value="domainIds") String domainIds) {
        return this.domainService.getDomainList(Arrays.stream(domainIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
    }
}

