/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.common.pojo.enums.SensitiveLevelEnum;
import com.tencent.supersonic.headless.api.pojo.DrillDownDimension;
import com.tencent.supersonic.headless.api.pojo.MetricQueryDefaultConfig;
import com.tencent.supersonic.headless.api.pojo.request.MetaBatchReq;
import com.tencent.supersonic.headless.api.pojo.request.MetricBaseReq;
import com.tencent.supersonic.headless.api.pojo.request.MetricReq;
import com.tencent.supersonic.headless.api.pojo.request.PageMetricReq;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.pojo.MetricFilter;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/metric"})
public class MetricController {
    private MetricService metricService;

    public MetricController(MetricService metricService) {
        this.metricService = metricService;
    }

    @PostMapping(value={"/createMetric"})
    public MetricResp createMetric(@RequestBody MetricReq metricReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.metricService.createMetric(metricReq, user);
    }

    @PostMapping(value={"/updateMetric"})
    public MetricResp updateMetric(@RequestBody MetricReq metricReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.metricService.updateMetric(metricReq, user);
    }

    @PostMapping(value={"/batchUpdateStatus"})
    public Boolean batchUpdateStatus(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.batchUpdateStatus(metaBatchReq, user);
        return true;
    }

    @PostMapping(value={"/batchPublish"})
    public Boolean batchPublish(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.batchPublish(metaBatchReq.getIds(), user);
        return true;
    }

    @PostMapping(value={"/batchUnPublish"})
    public Boolean batchUnPublish(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.batchUnPublish(metaBatchReq.getIds(), user);
        return true;
    }

    @PostMapping(value={"/batchUpdateClassifications"})
    public Boolean batchUpdateClassifications(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.batchUpdateClassifications(metaBatchReq, user);
        return true;
    }

    @PostMapping(value={"/batchUpdateSensitiveLevel"})
    public Boolean batchUpdateSensitiveLevel(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.batchUpdateSensitiveLevel(metaBatchReq, user);
        return true;
    }

    @PostMapping(value={"/mockMetricAlias"})
    public List<String> mockMetricAlias(@RequestBody MetricBaseReq metricReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.metricService.mockAlias(metricReq, "indicator", user);
    }

    @GetMapping(value={"/getMetricList/{modelId}"})
    public List<MetricResp> getMetricList(@PathVariable(value="modelId") Long modelId) {
        MetaFilter metaFilter = new MetaFilter(Lists.newArrayList((Object[])new Long[]{modelId}));
        return this.metricService.getMetrics(metaFilter);
    }

    @GetMapping(value={"/getMetricsToCreateNewMetric/{modelId}"})
    public List<MetricResp> getMetricsToCreateNewMetric(@PathVariable(value="modelId") Long modelId) {
        return this.metricService.getMetricsToCreateNewMetric(modelId);
    }

    @PostMapping(value={"/queryMetric"})
    public PageInfo<MetricResp> queryMetric(@RequestBody PageMetricReq pageMetricReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.metricService.queryMetricMarket(pageMetricReq, user);
    }

    @Deprecated
    @GetMapping(value={"getMetric/{modelId}/{bizName}"})
    public MetricResp getMetric(@PathVariable(value="modelId") Long modelId, @PathVariable(value="bizName") String bizName) {
        return this.metricService.getMetric(modelId, bizName);
    }

    @GetMapping(value={"getMetric/{id}"})
    public MetricResp getMetric(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.metricService.getMetric(id, user);
    }

    @DeleteMapping(value={"deleteMetric/{id}"})
    public Boolean deleteMetric(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.deleteMetric(id, user);
        return true;
    }

    @GetMapping(value={"/getAllHighSensitiveMetric"})
    public List<MetricResp> getAllHighSensitiveMetric() {
        MetricFilter metricFilter = new MetricFilter();
        metricFilter.setSensitiveLevel(SensitiveLevelEnum.HIGH.getCode());
        return this.metricService.getMetrics(metricFilter);
    }

    @Deprecated
    @GetMapping(value={"/getMetricTags"})
    public Set<String> getMetricTags() {
        return this.metricService.getMetricTags();
    }

    @GetMapping(value={"/getMetricClassifications"})
    public Set<String> getMetricClassifications() {
        return this.metricService.getMetricTags();
    }

    @GetMapping(value={"/getDrillDownDimension"})
    public List<DrillDownDimension> getDrillDownDimension(Long metricId) {
        return this.metricService.getDrillDownDimension(metricId);
    }

    @PostMapping(value={"/saveMetricQueryDefaultConfig"})
    public boolean saveMetricQueryDefaultConfig(@RequestBody MetricQueryDefaultConfig queryDefaultConfig, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.metricService.saveMetricQueryDefaultConfig(queryDefaultConfig, user);
        return true;
    }

    @RequestMapping(value={"getMetricQueryDefaultConfig/{metricId}"})
    public MetricQueryDefaultConfig getMetricQueryDefaultConfig(@PathVariable(value="metricId") Long metricId, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.metricService.getMetricQueryDefaultConfig(metricId, user);
    }
}

