/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.QueryRuleFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryRuleReq;
import com.tencent.supersonic.headless.api.pojo.response.QueryRuleResp;
import com.tencent.supersonic.headless.server.web.service.QueryRuleService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/query/rule"})
public class QueryRuleController {
    private final QueryRuleService queryRuleService;

    public QueryRuleController(QueryRuleService queryRuleService) {
        this.queryRuleService = queryRuleService;
    }

    @PostMapping(value={"/create"})
    public QueryRuleResp create(@RequestBody @Validated QueryRuleReq queryRuleReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.queryRuleService.addQueryRule(queryRuleReq, user);
    }

    @PostMapping(value={"/update"})
    public QueryRuleResp update(@RequestBody @Validated QueryRuleReq queryRuleReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.queryRuleService.updateQueryRule(queryRuleReq, user);
    }

    @DeleteMapping(value={"delete/{id}"})
    public Boolean delete(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.queryRuleService.dropQueryRule(id, user);
    }

    @PostMapping(value={"query"})
    public List<QueryRuleResp> query(@RequestBody @Validated QueryRuleFilter queryRuleFilter, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.queryRuleService.getQueryRuleList(queryRuleFilter, user);
    }
}

