/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.ItemValueReq;
import com.tencent.supersonic.headless.api.pojo.request.TagDeleteReq;
import com.tencent.supersonic.headless.api.pojo.request.TagFilterPageReq;
import com.tencent.supersonic.headless.api.pojo.request.TagReq;
import com.tencent.supersonic.headless.api.pojo.response.ItemValueResp;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.TagDO;
import com.tencent.supersonic.headless.server.pojo.TagFilter;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import com.tencent.supersonic.headless.server.web.service.TagQueryService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/tag"})
public class TagController {
    private final TagMetaService tagMetaService;
    private final TagQueryService tagQueryService;

    public TagController(TagMetaService tagMetaService, TagQueryService tagQueryService) {
        this.tagMetaService = tagMetaService;
        this.tagQueryService = tagQueryService;
    }

    @PostMapping(value={"/create"})
    public TagResp create(@RequestBody TagReq tagReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagMetaService.create(tagReq, user);
    }

    @PostMapping(value={"/create/batch"})
    public Integer createBatch(@RequestBody @Valid List<TagReq> tagReqList, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagMetaService.createBatch(tagReqList, user);
    }

    @PostMapping(value={"/delete/batch"})
    public Boolean deleteBatch(@RequestBody @Valid List<TagDeleteReq> tagDeleteReqList, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagMetaService.deleteBatch(tagDeleteReqList, user);
    }

    @DeleteMapping(value={"delete/{id}"})
    public Boolean delete(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.tagMetaService.delete(id, user);
        return true;
    }

    @GetMapping(value={"getTag/{id}"})
    public TagResp getTag(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagMetaService.getTag(id, user);
    }

    @PostMapping(value={"/queryTag"})
    public List<TagDO> queryPage(@RequestBody TagFilter tagFilter) {
        return this.tagMetaService.getTagDOList(tagFilter);
    }

    @PostMapping(value={"/value/distribution"})
    public ItemValueResp queryTagValue(@RequestBody ItemValueReq itemValueReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagQueryService.queryTagValue(itemValueReq, user);
    }

    @PostMapping(value={"/queryTag/market"})
    public PageInfo<TagResp> queryTagMarketPage(@RequestBody TagFilterPageReq tagMarketPageReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagMetaService.queryTagMarketPage(tagMarketPageReq, user);
    }
}

