/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.TagObjectReq;
import com.tencent.supersonic.headless.api.pojo.response.TagObjectResp;
import com.tencent.supersonic.headless.server.pojo.TagObjectFilter;
import com.tencent.supersonic.headless.server.web.service.TagObjectService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/tagObject"})
public class TagObjectController {
    private final TagObjectService tagObjectService;

    public TagObjectController(TagObjectService tagObjectService) {
        this.tagObjectService = tagObjectService;
    }

    @PostMapping(value={"/create"})
    public TagObjectResp create(@RequestBody TagObjectReq tagObjectReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagObjectService.create(tagObjectReq, user);
    }

    @PostMapping(value={"/update"})
    public TagObjectResp update(@RequestBody TagObjectReq tagObjectReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagObjectService.update(tagObjectReq, user);
    }

    @DeleteMapping(value={"delete/{id}"})
    public Boolean delete(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.tagObjectService.delete(id, user, true);
        return true;
    }

    @PostMapping(value={"/query"})
    public List<TagObjectResp> queryTagObject(@RequestBody TagObjectFilter filter, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.tagObjectService.getTagObjects(filter, user);
    }
}

