/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.pojo.exception.InvalidPermissionException;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.common.util.PageUtils;
import com.tencent.supersonic.headless.api.pojo.AppConfig;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.AppStatus;
import com.tencent.supersonic.headless.api.pojo.request.AppQueryReq;
import com.tencent.supersonic.headless.api.pojo.request.AppReq;
import com.tencent.supersonic.headless.api.pojo.response.AppDetailResp;
import com.tencent.supersonic.headless.api.pojo.response.AppResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.AppDO;
import com.tencent.supersonic.headless.server.persistence.mapper.AppMapper;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.AppService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppServiceImpl
extends ServiceImpl<AppMapper, AppDO>
implements AppService {
    private AppMapper appMapper;
    private MetricService metricService;
    private DimensionService dimensionService;

    public AppServiceImpl(AppMapper appMapper, MetricService metricService, DimensionService dimensionService) {
        this.appMapper = appMapper;
        this.metricService = metricService;
        this.dimensionService = dimensionService;
    }

    @Override
    public AppDetailResp save(AppReq app, User user) {
        app.createdBy(user.getName());
        AppDO appDO = new AppDO();
        BeanMapper.mapper((Object)app, (Object)appDO);
        appDO.setStatus(AppStatus.INIT.getCode());
        appDO.setConfig(JSONObject.toJSONString((Object)app.getConfig()));
        appDO.setAppSecret(this.getUniqueId());
        this.appMapper.insert(appDO);
        return this.convertDetail(appDO);
    }

    @Override
    public AppDetailResp update(AppReq app, User user) {
        app.updatedBy(user.getName());
        AppDO appDO = (AppDO)this.getById(app.getId());
        this.checkAuth(appDO, user);
        BeanMapper.mapper((Object)app, (Object)appDO);
        appDO.setConfig(JSONObject.toJSONString((Object)app.getConfig()));
        this.appMapper.updateById(appDO);
        return this.convertDetail(appDO);
    }

    @Override
    public void online(Integer id, User user) {
        AppDO appDO = this.getAppDO(id);
        this.checkAuth(appDO, user);
        appDO.setStatus(AppStatus.ONLINE.getCode());
        appDO.setUpdatedAt(new Date());
        appDO.setUpdatedBy(user.getName());
        this.updateById(appDO);
    }

    @Override
    public void offline(Integer id, User user) {
        AppDO appDO = this.getAppDO(id);
        this.checkAuth(appDO, user);
        appDO.setStatus(AppStatus.OFFLINE.getCode());
        appDO.setUpdatedAt(new Date());
        appDO.setUpdatedBy(user.getName());
        this.updateById(appDO);
    }

    @Override
    public void delete(Integer id, User user) {
        AppDO appDO = this.getAppDO(id);
        this.checkAuth(appDO, user);
        appDO.setStatus(AppStatus.DELETED.getCode());
        appDO.setUpdatedAt(new Date());
        appDO.setUpdatedBy(user.getName());
        this.updateById(appDO);
    }

    @Override
    public PageInfo<AppResp> pageApp(AppQueryReq appQueryReq, User user) {
        PageInfo appDOPageInfo = PageHelper.startPage((int)appQueryReq.getCurrent(), (int)appQueryReq.getPageSize()).doSelectPageInfo(() -> this.queryApp(appQueryReq));
        PageInfo appPageInfo = PageUtils.pageInfo2PageInfoVo((PageInfo)appDOPageInfo);
        Map<Long, MetricResp> metricResps = this.metricService.getMetrics(new MetaFilter()).stream().collect(Collectors.toMap(SchemaItem::getId, m -> m));
        Map<Long, DimensionResp> dimensionResps = this.dimensionService.getDimensions(new MetaFilter()).stream().collect(Collectors.toMap(SchemaItem::getId, m -> m));
        appPageInfo.setList(appDOPageInfo.getList().stream().map(appDO -> this.convert((AppDO)appDO, dimensionResps, metricResps, user)).collect(Collectors.toList()));
        return appPageInfo;
    }

    public List<AppDO> queryApp(AppQueryReq appQueryReq) {
        QueryWrapper appDOQueryWrapper = new QueryWrapper();
        appDOQueryWrapper.lambda().ne(AppDO::getStatus, (Object)AppStatus.DELETED.getCode());
        if (StringUtils.isNotBlank((CharSequence)appQueryReq.getName())) {
            appDOQueryWrapper.lambda().like(AppDO::getName, (Object)appQueryReq.getName());
        }
        if (!CollectionUtils.isEmpty((Collection)appQueryReq.getStatus())) {
            appDOQueryWrapper.lambda().in(AppDO::getStatus, (Collection)appQueryReq.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)appQueryReq.getCreatedBy())) {
            appDOQueryWrapper.lambda().eq(AppDO::getCreatedBy, (Object)appQueryReq.getCreatedBy());
        }
        return this.list((Wrapper)appDOQueryWrapper);
    }

    @Override
    public AppDetailResp getApp(Integer id, User user) {
        AppDO appDO = this.getAppDO(id);
        Map<Long, MetricResp> metricResps = this.metricService.getMetrics(new MetaFilter()).stream().collect(Collectors.toMap(SchemaItem::getId, m -> m));
        Map<Long, DimensionResp> dimensionResps = this.dimensionService.getDimensions(new MetaFilter()).stream().collect(Collectors.toMap(SchemaItem::getId, m -> m));
        this.checkAuth(appDO, user);
        return this.convertDetail(appDO, dimensionResps, metricResps);
    }

    @Override
    public AppDetailResp getApp(Integer id) {
        AppDO appDO = this.getAppDO(id);
        return this.convertDetail(appDO, new HashMap<Long, DimensionResp>(), new HashMap<Long, MetricResp>());
    }

    private AppDO getAppDO(Integer id) {
        AppDO appDO = (AppDO)this.getById(id);
        if (appDO == null) {
            throw new InvalidArgumentException("\u8be5\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        return appDO;
    }

    private void checkAuth(AppDO appDO, User user) {
        if (!this.hasAuth(appDO, user)) {
            throw new InvalidPermissionException("\u60a8\u4e0d\u662f\u8be5\u5e94\u7528\u7684\u8d1f\u8d23\u4eba, \u6682\u65e0\u6743\u67e5\u770b\u6216\u8005\u4fee\u6539");
        }
    }

    private boolean hasAuth(AppDO appDO, User user) {
        if (appDO.getCreatedBy().equalsIgnoreCase(user.getName())) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)appDO.getOwner()) && appDO.getOwner().contains(user.getName());
    }

    private AppResp convert(AppDO appDO, Map<Long, DimensionResp> dimensionMap, Map<Long, MetricResp> metricMap, User user) {
        AppResp app = new AppResp();
        BeanMapper.mapper((Object)appDO, (Object)app);
        AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)appDO.getConfig(), AppConfig.class);
        this.fillItemName(appConfig, dimensionMap, metricMap);
        app.setConfig(appConfig);
        app.setAppStatus(AppStatus.fromCode((Integer)appDO.getStatus()));
        app.setHasAdminRes(this.hasAuth(appDO, user));
        return app;
    }

    private AppDetailResp convertDetail(AppDO appDO) {
        return this.convertDetail(appDO, new HashMap<Long, DimensionResp>(), new HashMap<Long, MetricResp>());
    }

    private AppDetailResp convertDetail(AppDO appDO, Map<Long, DimensionResp> dimensionMap, Map<Long, MetricResp> metricMap) {
        AppDetailResp app = new AppDetailResp();
        BeanMapper.mapper((Object)appDO, (Object)app);
        AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)appDO.getConfig(), AppConfig.class);
        this.fillItemName(appConfig, dimensionMap, metricMap);
        app.setConfig(appConfig);
        app.setAppStatus(AppStatus.fromCode((Integer)appDO.getStatus()));
        return app;
    }

    private void fillItemName(AppConfig appConfig, Map<Long, DimensionResp> dimensionMap, Map<Long, MetricResp> metricMap) {
        appConfig.getItems().forEach(metricItem -> {
            metricItem.setName(metricMap.getOrDefault(metricItem.getId(), new MetricResp()).getName());
            metricItem.setBizName(metricMap.getOrDefault(metricItem.getId(), new MetricResp()).getBizName());
            metricItem.setCreatedBy(metricMap.getOrDefault(metricItem.getId(), new MetricResp()).getCreatedBy());
            metricItem.getRelateItems().forEach(dimensionItem -> {
                dimensionItem.setName(dimensionMap.getOrDefault(dimensionItem.getId(), new DimensionResp()).getName());
                dimensionItem.setBizName(dimensionMap.getOrDefault(dimensionItem.getId(), new DimensionResp()).getBizName());
                dimensionItem.setCreatedBy(dimensionMap.getOrDefault(dimensionItem.getId(), new DimensionResp()).getCreatedBy());
            });
        });
    }

    private String getUniqueId() {
        return UUID.randomUUID().toString().replaceAll("_", "");
    }
}

