/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.server.persistence.repository.ChatContextRepository;
import com.tencent.supersonic.headless.server.web.service.ChatContextService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChatContextServiceImpl
implements ChatContextService {
    private static final Logger log = LoggerFactory.getLogger(ChatContextServiceImpl.class);
    private ChatContextRepository chatContextRepository;

    public ChatContextServiceImpl(ChatContextRepository chatContextRepository) {
        this.chatContextRepository = chatContextRepository;
    }

    @Override
    public Long getContextModel(Integer chatId) {
        if (Objects.isNull(chatId)) {
            return null;
        }
        ChatContext chatContext = this.getOrCreateContext(chatId);
        if (Objects.isNull(chatContext)) {
            return null;
        }
        SemanticParseInfo originalSemanticParse = chatContext.getParseInfo();
        if (Objects.nonNull(originalSemanticParse) && Objects.nonNull(originalSemanticParse.getDataSetId())) {
            return originalSemanticParse.getDataSetId();
        }
        return null;
    }

    @Override
    public ChatContext getOrCreateContext(Integer chatId) {
        return this.chatContextRepository.getOrCreateContext(chatId);
    }

    @Override
    public void updateContext(ChatContext chatCtx) {
        log.debug("save ChatContext {}", (Object)chatCtx);
        this.chatContextRepository.updateContext(chatCtx);
    }
}

