/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.request.ClassReq;
import com.tencent.supersonic.headless.api.pojo.response.ClassResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.ClassDO;
import com.tencent.supersonic.headless.server.persistence.repository.ClassRepository;
import com.tencent.supersonic.headless.server.pojo.ClassFilter;
import com.tencent.supersonic.headless.server.utils.ClassConverter;
import com.tencent.supersonic.headless.server.web.service.ClassService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class ClassServiceImpl
implements ClassService {
    private final ClassRepository classRepository;
    private final ClassConverter converter;

    public ClassServiceImpl(ClassRepository classRepository, ClassConverter converter) {
        this.classRepository = classRepository;
        this.converter = converter;
    }

    @Override
    public ClassResp create(ClassReq classReq, User user) {
        ClassDO classDO = this.converter.convert(classReq);
        classDO.setId(null);
        Date date = new Date();
        classDO.setCreatedBy(user.getName());
        classDO.setCreatedAt(date);
        classDO.setUpdatedBy(user.getName());
        classDO.setUpdatedAt(date);
        classDO.setStatus(StatusEnum.ONLINE.getCode());
        this.classRepository.create(classDO);
        ClassDO classDOById = this.classRepository.getClassById(classDO.getId());
        return this.converter.convert2Resp(classDOById);
    }

    @Override
    public ClassResp update(ClassReq classReq, User user) {
        ClassDO classDO = this.classRepository.getClassById(classReq.getId());
        BeanMapper.mapper((Object)classReq, (Object)classDO);
        classDO.setUpdatedAt(new Date());
        classDO.setUpdatedBy(user.getName());
        this.classRepository.update(classDO);
        return this.converter.convert2Resp(this.classRepository.getClassById(classReq.getId()));
    }

    @Override
    public Boolean delete(Long id, Boolean force, User user) throws Exception {
        ClassDO classDO = this.classRepository.getClassById(id);
        this.checkDeletePermission(classDO, user);
        this.checkDeleteValid(classDO, force);
        this.classRepository.delete(new ArrayList<Long>(Arrays.asList(id)));
        if (force.booleanValue()) {
            List<ClassDO> classDOList = this.classRepository.getAllClassDOList();
            Set<Long> deleteClassList = this.extractSubClass(id, classDOList);
            this.classRepository.delete(new ArrayList<Long>(deleteClassList));
        }
        return true;
    }

    private Set<Long> extractSubClass(Long id, List<ClassDO> classDOList) {
        HashSet<Long> classIdSet = new HashSet<Long>();
        for (ClassDO classDO : classDOList) {
            if (!id.equals(classDO.getParentId())) continue;
            classIdSet.add(classDO.getId());
            classIdSet.addAll(this.extractSubClass(classDO.getId(), classDOList));
        }
        return classIdSet;
    }

    private void checkDeleteValid(ClassDO classDelete, Boolean force) {
        List<ClassDO> classDOList = this.classRepository.getAllClassDOList();
        for (ClassDO classDO : classDOList) {
            if (!classDO.getParentId().equals(classDelete.getId()) || force.booleanValue()) continue;
            throw new RuntimeException("\u8be5\u5206\u7c7b\u4e0b\u8fd8\u5b58\u5728\u5b50\u5206\u7c7b, \u6682\u4e0d\u80fd\u5220\u9664, \u8bf7\u786e\u8ba4");
        }
    }

    private void checkDeletePermission(ClassDO classDO, User user) throws Exception {
        if (user.getName().equalsIgnoreCase(classDO.getCreatedBy()) || user.isSuperAdmin()) {
            return;
        }
        throw new Exception("delete operation is not supported at the moment. Please contact the admin.");
    }

    @Override
    public List<ClassResp> getClassList(ClassFilter filter, User user) {
        List<ClassDO> classDOList = this.classRepository.getClassDOList(filter);
        return this.converter.convert2RespList(classDOList);
    }
}

