/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.headless.server.persistence.dataobject.CollectDO;
import com.tencent.supersonic.headless.server.persistence.mapper.CollectMapper;
import com.tencent.supersonic.headless.server.web.service.CollectService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CollectServiceImpl
implements CollectService {
    private static final Logger log = LoggerFactory.getLogger(CollectServiceImpl.class);
    public static final String type = "metric";
    @Resource
    private CollectMapper collectMapper;

    @Override
    public Boolean collect(User user, CollectDO collectReq) {
        CollectDO collect = new CollectDO();
        collect.setType(StringUtils.isEmpty((CharSequence)collectReq.getType()) ? type : collectReq.getType());
        collect.setUsername(user.getName());
        collect.setCollectId(collectReq.getCollectId());
        this.collectMapper.insert(collect);
        return true;
    }

    @Override
    public Boolean unCollect(User user, Long id) {
        QueryWrapper collectDOQueryWrapper = new QueryWrapper();
        collectDOQueryWrapper.lambda().eq(CollectDO::getUsername, (Object)user.getName());
        collectDOQueryWrapper.lambda().eq(CollectDO::getId, (Object)id);
        collectDOQueryWrapper.lambda().eq(CollectDO::getType, (Object)type);
        this.collectMapper.delete((Wrapper)collectDOQueryWrapper);
        return true;
    }

    @Override
    public Boolean unCollect(User user, CollectDO collectReq) {
        QueryWrapper collectDOQueryWrapper = new QueryWrapper();
        collectDOQueryWrapper.lambda().eq(CollectDO::getUsername, (Object)user.getName());
        collectDOQueryWrapper.lambda().eq(CollectDO::getCollectId, (Object)collectReq.getCollectId());
        collectDOQueryWrapper.lambda().eq(CollectDO::getType, (Object)collectReq.getType());
        this.collectMapper.delete((Wrapper)collectDOQueryWrapper);
        return true;
    }

    @Override
    public List<CollectDO> getCollectionList(String username) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((CharSequence)username)) {
            queryWrapper.lambda().eq(CollectDO::getUsername, (Object)username);
        }
        return this.collectMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<CollectDO> getCollectionList(String username, TypeEnums typeEnums) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((CharSequence)username)) {
            queryWrapper.lambda().eq(CollectDO::getUsername, (Object)username);
        }
        queryWrapper.lambda().eq(CollectDO::getType, (Object)typeEnums.name().toLowerCase());
        return this.collectMapper.selectList((Wrapper)queryWrapper);
    }
}

