/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.Pair;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.DatabaseReq;
import com.tencent.supersonic.headless.api.pojo.request.SqlExecuteReq;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.core.adaptor.db.DbAdaptor;
import com.tencent.supersonic.headless.core.adaptor.db.DbAdaptorFactory;
import com.tencent.supersonic.headless.core.pojo.Database;
import com.tencent.supersonic.headless.core.utils.JdbcDataSourceUtils;
import com.tencent.supersonic.headless.core.utils.SqlUtils;
import com.tencent.supersonic.headless.core.utils.SqlVariableParseUtils;
import com.tencent.supersonic.headless.server.persistence.dataobject.DatabaseDO;
import com.tencent.supersonic.headless.server.persistence.mapper.DatabaseDOMapper;
import com.tencent.supersonic.headless.server.pojo.DatabaseParameter;
import com.tencent.supersonic.headless.server.pojo.DbParameterFactory;
import com.tencent.supersonic.headless.server.pojo.DbParametersBuilder;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.utils.DatabaseConverter;
import com.tencent.supersonic.headless.server.web.service.DatabaseService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DatabaseServiceImpl
extends ServiceImpl<DatabaseDOMapper, DatabaseDO>
implements DatabaseService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseServiceImpl.class);
    @Autowired
    private SqlUtils sqlUtils;
    @Lazy
    @Autowired
    private ModelService datasourceService;

    @Override
    public boolean testConnect(DatabaseReq databaseReq, User user) {
        Database database = DatabaseConverter.convert(databaseReq);
        return JdbcDataSourceUtils.testDatabase((Database)database);
    }

    @Override
    public DatabaseResp createOrUpdateDatabase(DatabaseReq databaseReq, User user) {
        Database database = DatabaseConverter.convert(databaseReq);
        DatabaseDO databaseDO = this.getDatabaseDO(databaseReq.getId());
        if (databaseDO != null) {
            database.updatedBy(user.getName());
            DatabaseConverter.convert(database, databaseDO);
            this.updateById(databaseDO);
            return DatabaseConverter.convertWithPassword(databaseDO);
        }
        database.createdBy(user.getName());
        databaseDO = DatabaseConverter.convert(database);
        this.save(databaseDO);
        return DatabaseConverter.convertWithPassword(databaseDO);
    }

    @Override
    public List<DatabaseResp> getDatabaseList(User user) {
        List<DatabaseResp> databaseResps = this.list().stream().map(DatabaseConverter::convert).collect(Collectors.toList());
        this.fillPermission(databaseResps, user);
        return databaseResps;
    }

    private void fillPermission(List<DatabaseResp> databaseResps, User user) {
        databaseResps.forEach(databaseResp -> {
            if (databaseResp.getAdmins().contains(user.getName()) || user.getName().equalsIgnoreCase(databaseResp.getCreatedBy()) || user.isSuperAdmin()) {
                databaseResp.setHasPermission(true);
                databaseResp.setHasEditPermission(true);
                databaseResp.setHasUsePermission(true);
            }
            if (databaseResp.getViewers().contains(user.getName())) {
                databaseResp.setHasUsePermission(true);
            }
        });
    }

    @Override
    public void deleteDatabase(Long databaseId) {
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setDatabaseId(databaseId);
        modelFilter.setIncludesDetail(false);
        List<ModelResp> modelResps = this.datasourceService.getModelList(modelFilter);
        if (!CollectionUtils.isEmpty(modelResps)) {
            List datasourceNames = modelResps.stream().map(SchemaItem::getName).collect(Collectors.toList());
            String message = String.format("\u8be5\u6570\u636e\u5e93\u88ab\u6a21\u578b%s\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664", datasourceNames);
            throw new RuntimeException(message);
        }
        this.removeById(databaseId);
    }

    @Override
    public DatabaseResp getDatabase(Long id) {
        DatabaseDO databaseDO = (DatabaseDO)this.getById(id);
        return DatabaseConverter.convertWithPassword(databaseDO);
    }

    @Override
    public DatabaseResp getDatabase(Long id, User user) {
        DatabaseResp databaseResp = this.getDatabase(id);
        this.checkPermission(databaseResp, user);
        return databaseResp;
    }

    @Override
    public SemanticQueryResp executeSql(SqlExecuteReq sqlExecuteReq, Long id, User user) {
        DatabaseResp databaseResp = this.getDatabase(id);
        if (databaseResp == null) {
            return new SemanticQueryResp();
        }
        this.checkPermission(databaseResp, user);
        String sql = sqlExecuteReq.getSql();
        sql = SqlVariableParseUtils.parse((String)sql, (List)sqlExecuteReq.getSqlVariables(), (List)Lists.newArrayList());
        SemanticQueryResp semanticQueryResp = this.executeSql(sql, databaseResp);
        this.fillColumnComment(sql, databaseResp, semanticQueryResp);
        return semanticQueryResp;
    }

    @Override
    public SemanticQueryResp executeSql(String sql, DatabaseResp databaseResp) {
        return this.queryWithColumns(sql, DatabaseConverter.convert(databaseResp));
    }

    private void fillColumnComment(String sql, DatabaseResp databaseResp, SemanticQueryResp semanticQueryResp) {
        Pair<String, String> dbTableName = this.getDbTableName(sql, databaseResp);
        String db = (String)dbTableName.first;
        String table = (String)dbTableName.second;
        if (StringUtils.isBlank((CharSequence)db) || StringUtils.isBlank((CharSequence)table)) {
            return;
        }
        SemanticQueryResp columnsWithComment = this.getColumns(databaseResp, db, table);
        Map<String, String> columnCommentMap = this.getColumnCommentMap(columnsWithComment.getResultList());
        List columns = semanticQueryResp.getColumns();
        for (QueryColumn column : columns) {
            column.setComment(columnCommentMap.get(column.getNameEn()));
        }
    }

    private Map<String, String> getColumnCommentMap(List<Map<String, Object>> resultList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map<String, Object> result : resultList) {
            map.put(String.valueOf(result.get("name")), String.valueOf(result.get("comment")));
        }
        return map;
    }

    private Pair<String, String> getDbTableName(String sql, DatabaseResp databaseResp) {
        String dbTableName = SqlSelectHelper.getDbTableName((String)sql);
        if (StringUtils.isBlank((CharSequence)dbTableName)) {
            return Pair.pair((Object)"", (Object)"");
        }
        if (dbTableName.contains(".")) {
            String db = dbTableName.split("\\.")[0];
            String table = dbTableName.split("\\.")[1];
            return Pair.pair((Object)db, (Object)table);
        }
        return Pair.pair((Object)databaseResp.getDatabase(), (Object)dbTableName);
    }

    @Override
    public Map<String, List<DatabaseParameter>> getDatabaseParameters() {
        return DbParameterFactory.getMap().entrySet().stream().collect(LinkedHashMap::new, (map, entry) -> map.put((String)entry.getKey(), ((DbParametersBuilder)entry.getValue()).build()), HashMap::putAll);
    }

    private SemanticQueryResp queryWithColumns(String sql, Database database) {
        SemanticQueryResp queryResultWithColumns = new SemanticQueryResp();
        SqlUtils sqlUtils = this.sqlUtils.init(database);
        log.info("query SQL: {}", (Object)sql);
        sqlUtils.queryInternal(sql, queryResultWithColumns);
        return queryResultWithColumns;
    }

    private DatabaseDO getDatabaseDO(Long id) {
        return (DatabaseDO)this.getById(id);
    }

    @Override
    public SemanticQueryResp getDbNames(Long id) {
        DatabaseResp databaseResp = this.getDatabase(id);
        DbAdaptor engineAdaptor = DbAdaptorFactory.getEngineAdaptor((String)databaseResp.getType());
        String metaQueryTpl = engineAdaptor.getDbMetaQueryTpl();
        return this.queryWithColumns(metaQueryTpl, DatabaseConverter.convert(databaseResp));
    }

    @Override
    public SemanticQueryResp getTables(Long id, String db) {
        DatabaseResp databaseResp = this.getDatabase(id);
        DbAdaptor engineAdaptor = DbAdaptorFactory.getEngineAdaptor((String)databaseResp.getType());
        String metaQueryTpl = engineAdaptor.getTableMetaQueryTpl();
        String metaQuerySql = String.format(metaQueryTpl, db);
        return this.queryWithColumns(metaQuerySql, DatabaseConverter.convert(databaseResp));
    }

    @Override
    public SemanticQueryResp getColumns(Long id, String db, String table) {
        DatabaseResp databaseResp = this.getDatabase(id);
        DbAdaptor engineAdaptor = DbAdaptorFactory.getEngineAdaptor((String)databaseResp.getType());
        String metaQueryTpl = engineAdaptor.getColumnMetaQueryTpl();
        String metaQuerySql = String.format(metaQueryTpl, db, table);
        return this.queryWithColumns(metaQuerySql, DatabaseConverter.convert(databaseResp));
    }

    public SemanticQueryResp getColumns(DatabaseResp databaseResp, String db, String table) {
        DbAdaptor engineAdaptor = DbAdaptorFactory.getEngineAdaptor((String)databaseResp.getType());
        String metaQueryTpl = engineAdaptor.getColumnMetaQueryTpl();
        String metaQuerySql = String.format(metaQueryTpl, db, table);
        return this.queryWithColumns(metaQuerySql, DatabaseConverter.convert(databaseResp));
    }

    private void checkPermission(DatabaseResp databaseResp, User user) {
        List admins = databaseResp.getAdmins();
        List viewers = databaseResp.getViewers();
        if (!(admins.contains(user.getName()) || viewers.contains(user.getName()) || databaseResp.getCreatedBy().equalsIgnoreCase(user.getName()) || user.isSuperAdmin())) {
            String message = String.format("\u60a8\u6682\u65e0\u5f53\u524d\u6570\u636e\u5e93%s\u6743\u9650, \u8bf7\u8054\u7cfb\u6570\u636e\u5e93\u521b\u5efa\u4eba:%s\u5f00\u901a", databaseResp.getName(), databaseResp.getCreatedBy());
            throw new RuntimeException(message);
        }
    }
}

