/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.knowledge.builder.WordBuilderFactory;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DictWordService {
    private static final Logger log = LoggerFactory.getLogger(DictWordService.class);
    @Autowired
    private SchemaService schemaService;
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    private List<DictWord> preDictWords = new ArrayList<DictWord>();

    public void loadDictWord() {
        List<DictWord> dictWords = this.getAllDictWords();
        this.setPreDictWords(dictWords);
        this.knowledgeBaseService.reloadAllData(dictWords);
    }

    public void reloadDictWord() {
        List<DictWord> preDictWords;
        long startTime = System.currentTimeMillis();
        List<DictWord> dictWords = this.getAllDictWords();
        if (org.apache.commons.collections.CollectionUtils.isEqualCollection(dictWords, preDictWords = this.getPreDictWords())) {
            log.debug("Dictionary hasn't been reloaded.");
            return;
        }
        this.setPreDictWords(dictWords);
        this.knowledgeBaseService.updateOnlineKnowledge(this.getAllDictWords());
        long duration = System.currentTimeMillis() - startTime;
        log.info("Dictionary has been regularly reloaded in {} milliseconds", (Object)duration);
    }

    public List<DictWord> getAllDictWords() {
        SemanticSchema semanticSchema = this.schemaService.getSemanticSchema();
        ArrayList<DictWord> words = new ArrayList<DictWord>();
        this.addWordsByType(DictWordType.DIMENSION, semanticSchema.getDimensions(), words);
        this.addWordsByType(DictWordType.METRIC, semanticSchema.getMetrics(), words);
        this.addWordsByType(DictWordType.ENTITY, semanticSchema.getEntities(), words);
        this.addWordsByType(DictWordType.VALUE, semanticSchema.getDimensionValues(), words);
        this.addWordsByType(DictWordType.TERM, semanticSchema.getTerms(), words);
        return words;
    }

    private void addWordsByType(DictWordType value, List<SchemaElement> metas, List<DictWord> natures) {
        metas = this.distinct(metas);
        List natureList = WordBuilderFactory.get((DictWordType)value).getDictWords(metas);
        log.debug("nature type:{} , nature size:{}", (Object)value.name(), (Object)natureList.size());
        natures.addAll(natureList);
    }

    public List<DictWord> getPreDictWords() {
        return this.preDictWords;
    }

    public void setPreDictWords(List<DictWord> preDictWords) {
        this.preDictWords = preDictWords;
    }

    private List<SchemaElement> distinct(List<SchemaElement> metas) {
        if (CollectionUtils.isEmpty(metas)) {
            return metas;
        }
        if (SchemaElementType.TERM.equals((Object)metas.get(0).getType())) {
            return metas;
        }
        return metas.stream().collect(Collectors.toMap(SchemaElement::getId, Function.identity(), (e1, e2) -> e1)).values().stream().collect(Collectors.toList());
    }
}

