/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.DataEvent;
import com.tencent.supersonic.common.pojo.DataItem;
import com.tencent.supersonic.common.pojo.ModelRela;
import com.tencent.supersonic.common.pojo.enums.EventType;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.headless.api.pojo.DimValueMap;
import com.tencent.supersonic.headless.api.pojo.ModelDetail;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.TagDefineType;
import com.tencent.supersonic.headless.api.pojo.request.DimensionReq;
import com.tencent.supersonic.headless.api.pojo.request.MetaBatchReq;
import com.tencent.supersonic.headless.api.pojo.request.PageDimensionReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.TagItem;
import com.tencent.supersonic.headless.server.persistence.dataobject.DimensionDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.TagDO;
import com.tencent.supersonic.headless.server.persistence.mapper.DimensionDOMapper;
import com.tencent.supersonic.headless.server.persistence.repository.DimensionRepository;
import com.tencent.supersonic.headless.server.pojo.DimensionFilter;
import com.tencent.supersonic.headless.server.pojo.DimensionsFilter;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.pojo.TagFilter;
import com.tencent.supersonic.headless.server.utils.AliasGenerateHelper;
import com.tencent.supersonic.headless.server.utils.DimensionConverter;
import com.tencent.supersonic.headless.server.utils.NameCheckUtils;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.DatabaseService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.ModelRelaService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DimensionServiceImpl
extends ServiceImpl<DimensionDOMapper, DimensionDO>
implements DimensionService {
    private static final Logger log = LoggerFactory.getLogger(DimensionServiceImpl.class);
    private DimensionRepository dimensionRepository;
    private ModelService modelService;
    private AliasGenerateHelper aliasGenerateHelper;
    private DatabaseService databaseService;
    private ModelRelaService modelRelaService;
    private DataSetService dataSetService;
    private TagMetaService tagMetaService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public DimensionServiceImpl(DimensionRepository dimensionRepository, ModelService modelService, AliasGenerateHelper aliasGenerateHelper, DatabaseService databaseService, ModelRelaService modelRelaService, DataSetService dataSetService, TagMetaService tagMetaService) {
        this.modelService = modelService;
        this.dimensionRepository = dimensionRepository;
        this.aliasGenerateHelper = aliasGenerateHelper;
        this.databaseService = databaseService;
        this.modelRelaService = modelRelaService;
        this.dataSetService = dataSetService;
        this.tagMetaService = tagMetaService;
    }

    @Override
    public DimensionResp createDimension(DimensionReq dimensionReq, User user) {
        this.checkExist(Lists.newArrayList((Object[])new DimensionReq[]{dimensionReq}));
        dimensionReq.createdBy(user.getName());
        DimensionDO dimensionDO = DimensionConverter.convert2DimensionDO(dimensionReq);
        this.dimensionRepository.createDimension(dimensionDO);
        this.sendEventBatch(Lists.newArrayList((Object[])new DimensionDO[]{dimensionDO}), EventType.ADD);
        return DimensionConverter.convert2DimensionResp(dimensionDO);
    }

    @Override
    public void createDimensionBatch(List<DimensionReq> dimensionReqs, User user) {
        if (CollectionUtils.isEmpty(dimensionReqs)) {
            return;
        }
        Long modelId = dimensionReqs.get(0).getModelId();
        List<DimensionResp> dimensionResps = this.getDimensions(modelId);
        Map<String, DimensionResp> bizNameMap = dimensionResps.stream().collect(Collectors.toMap(SchemaItem::getBizName, a -> a, (k1, k2) -> k1));
        Map<String, DimensionResp> nameMap = dimensionResps.stream().collect(Collectors.toMap(SchemaItem::getName, a -> a, (k1, k2) -> k1));
        List dimensionToInsert = dimensionReqs.stream().filter(dimension -> !bizNameMap.containsKey(dimension.getBizName()) && !nameMap.containsKey(dimension.getName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dimensionToInsert)) {
            return;
        }
        List<DimensionDO> dimensionDOS = dimensionToInsert.stream().peek(dimension -> dimension.createdBy(user.getName())).map(DimensionConverter::convert2DimensionDO).collect(Collectors.toList());
        this.dimensionRepository.createDimensionBatch(dimensionDOS);
        this.sendEventBatch(dimensionDOS, EventType.ADD);
    }

    @Override
    public void updateDimension(DimensionReq dimensionReq, User user) {
        this.checkExist(Lists.newArrayList((Object[])new DimensionReq[]{dimensionReq}));
        DimensionDO dimensionDO = this.dimensionRepository.getDimensionById(dimensionReq.getId());
        dimensionReq.updatedBy(user.getName());
        String oldName = dimensionDO.getName();
        DimensionConverter.convert(dimensionDO, dimensionReq);
        this.dimensionRepository.updateDimension(dimensionDO);
        if (!oldName.equals(dimensionDO.getName())) {
            this.sendEvent(DataItem.builder().modelId(dimensionDO.getModelId() + "_").newName(dimensionReq.getName()).name(oldName).type(TypeEnums.DIMENSION).id(dimensionDO.getId() + "_").build(), EventType.UPDATE);
        }
    }

    @Override
    public void batchUpdateStatus(MetaBatchReq metaBatchReq, User user) {
        if (CollectionUtils.isEmpty((Collection)metaBatchReq.getIds())) {
            return;
        }
        DimensionFilter dimensionFilter = new DimensionFilter();
        dimensionFilter.setIds(metaBatchReq.getIds());
        List<DimensionDO> dimensionDOS = this.dimensionRepository.getDimension(dimensionFilter);
        if (CollectionUtils.isEmpty(dimensionDOS)) {
            return;
        }
        dimensionDOS = dimensionDOS.stream().peek(dimensionDO -> {
            dimensionDO.setStatus(metaBatchReq.getStatus());
            dimensionDO.setUpdatedAt(new Date());
            dimensionDO.setUpdatedBy(user.getName());
        }).collect(Collectors.toList());
        this.dimensionRepository.batchUpdateStatus(dimensionDOS);
        if (StatusEnum.OFFLINE.getCode().equals(metaBatchReq.getStatus()) || StatusEnum.DELETED.getCode().equals(metaBatchReq.getStatus())) {
            this.sendEventBatch(dimensionDOS, EventType.DELETE);
        } else if (StatusEnum.ONLINE.getCode().equals(metaBatchReq.getStatus())) {
            this.sendEventBatch(dimensionDOS, EventType.ADD);
        }
    }

    @Override
    public void batchUpdateSensitiveLevel(MetaBatchReq metaBatchReq, User user) {
        DimensionFilter metaFilter = new DimensionFilter();
        metaFilter.setIds(metaBatchReq.getIds());
        List<DimensionDO> dimensionDOS = this.queryDimension(metaFilter);
        for (DimensionDO dimensionDO : dimensionDOS) {
            dimensionDO.setUpdatedAt(new Date());
            dimensionDO.setUpdatedBy(user.getName());
            dimensionDO.setSensitiveLevel(metaBatchReq.getSensitiveLevel());
        }
        this.updateBatchById(dimensionDOS);
    }

    @Override
    public void deleteDimension(Long id, User user) {
        DimensionDO dimensionDO = this.dimensionRepository.getDimensionById(id);
        if (dimensionDO == null) {
            throw new RuntimeException(String.format("the dimension %s not exist", id));
        }
        dimensionDO.setStatus(StatusEnum.DELETED.getCode());
        dimensionDO.setUpdatedAt(new Date());
        dimensionDO.setUpdatedBy(user.getName());
        this.dimensionRepository.updateDimension(dimensionDO);
        this.sendEventBatch(Lists.newArrayList((Object[])new DimensionDO[]{dimensionDO}), EventType.DELETE);
    }

    @Override
    public DimensionResp getDimension(String bizName, Long modelId) {
        List<DimensionResp> dimensionResps = this.getDimensions(modelId);
        if (CollectionUtils.isEmpty(dimensionResps)) {
            return null;
        }
        for (DimensionResp dimensionResp : dimensionResps) {
            if (!dimensionResp.getBizName().equalsIgnoreCase(bizName)) continue;
            return dimensionResp;
        }
        return null;
    }

    @Override
    public DimensionResp getDimension(Long id) {
        DimensionDO dimensionDO = this.dimensionRepository.getDimensionById(id);
        if (dimensionDO == null) {
            return null;
        }
        return DimensionConverter.convert2DimensionResp(dimensionDO, new HashMap<Long, ModelResp>());
    }

    @Override
    public PageInfo<DimensionResp> queryDimension(PageDimensionReq pageDimensionReq) {
        DimensionFilter dimensionFilter = new DimensionFilter();
        BeanUtils.copyProperties((Object)pageDimensionReq, (Object)dimensionFilter);
        dimensionFilter.setModelIds(pageDimensionReq.getModelIds());
        PageInfo dimensionDOPageInfo = PageHelper.startPage((int)pageDimensionReq.getCurrent(), (int)pageDimensionReq.getPageSize()).doSelectPageInfo(() -> this.queryDimension(dimensionFilter));
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)dimensionDOPageInfo, (Object)pageInfo);
        pageInfo.setList(this.convertList(dimensionDOPageInfo.getList()));
        return pageInfo;
    }

    private List<DimensionDO> queryDimension(DimensionFilter dimensionFilter) {
        return this.dimensionRepository.getDimension(dimensionFilter);
    }

    @Override
    public List<DimensionResp> queryDimensions(DimensionsFilter dimensionsFilter) {
        List<DimensionDO> dimensions = this.dimensionRepository.getDimensions(dimensionsFilter);
        return this.convertList(dimensions);
    }

    @Override
    public List<DimensionResp> getDimensions(MetaFilter metaFilter) {
        DimensionFilter dimensionFilter = new DimensionFilter();
        BeanUtils.copyProperties((Object)metaFilter, (Object)dimensionFilter);
        List<DimensionDO> dimensionDOS = this.dimensionRepository.getDimension(dimensionFilter);
        List<DimensionResp> dimensionResps = this.convertList(dimensionDOS);
        List<Long> dimensionIds = dimensionResps.stream().map(dimensionResp -> dimensionResp.getId()).collect(Collectors.toList());
        List<TagItem> tagItems = this.tagMetaService.getTagItems(dimensionIds, TagDefineType.DIMENSION);
        Map<Long, TagItem> itemIdToTagItem = tagItems.stream().collect(Collectors.toMap(tag -> tag.getItemId(), tag -> tag, (newTag, oldTag) -> newTag));
        if (Objects.nonNull(itemIdToTagItem)) {
            dimensionResps.stream().forEach(dimensionResp -> {
                Long metricRespId = dimensionResp.getId();
                if (itemIdToTagItem.containsKey(metricRespId)) {
                    dimensionResp.setIsTag(((TagItem)itemIdToTagItem.get(metricRespId)).getIsTag());
                }
            });
        }
        if (!CollectionUtils.isEmpty(metaFilter.getFieldsDepend())) {
            return this.filterByField(dimensionResps, metaFilter.getFieldsDepend());
        }
        if (metaFilter.getDataSetId() != null) {
            DataSetResp dataSetResp = this.dataSetService.getDataSet(metaFilter.getDataSetId());
            return DimensionConverter.filterByDataSet(dimensionResps, dataSetResp);
        }
        return dimensionResps;
    }

    private List<DimensionResp> getDimensions(Long modelId) {
        return this.getDimensions(new MetaFilter(Lists.newArrayList((Object[])new Long[]{modelId})));
    }

    private List<DimensionResp> filterByField(List<DimensionResp> dimensionResps, List<String> fields) {
        ArrayList dimensionFiltered = Lists.newArrayList();
        for (DimensionResp dimensionResp : dimensionResps) {
            for (String field : fields) {
                if (!dimensionResp.getExpr().contains(field)) continue;
                dimensionFiltered.add(dimensionResp);
            }
        }
        return dimensionFiltered;
    }

    @Override
    public List<DimensionResp> getDimensionInModelCluster(Long modelId) {
        ModelResp modelResp = this.modelService.getModel(modelId);
        List<ModelRela> modelRelas = this.modelRelaService.getModelRelaList(modelResp.getDomainId());
        ArrayList<Long> modelIds = new ArrayList<Long>();
        modelIds.add(modelId);
        for (ModelRela modelRela : modelRelas) {
            modelIds.add(modelRela.getFromModelId());
            modelIds.add(modelRela.getToModelId());
        }
        DimensionFilter dimensionFilter = new DimensionFilter();
        dimensionFilter.setModelIds(modelIds);
        return this.getDimensions(dimensionFilter);
    }

    private List<DimensionResp> convertList(List<DimensionDO> dimensionDOS) {
        List<Long> modelIds = dimensionDOS.stream().map(DimensionDO::getModelId).collect(Collectors.toList());
        ModelFilter modelFilter = new ModelFilter(false, modelIds);
        Map<Long, ModelResp> modelMap = this.modelService.getModelMap(modelFilter);
        List<Object> dimensionResps = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(dimensionDOS)) {
            dimensionResps = dimensionDOS.stream().map(dimensionDO -> DimensionConverter.convert2DimensionResp(dimensionDO, modelMap)).collect(Collectors.toList());
        }
        this.fillTagInfo(dimensionResps);
        return dimensionResps;
    }

    private void fillTagInfo(List<DimensionResp> dimensionResps) {
        if (CollectionUtils.isEmpty(dimensionResps)) {
            return;
        }
        TagFilter tagFilter = new TagFilter();
        tagFilter.setTagDefineType(TagDefineType.DIMENSION);
        List<Long> dimensionIds = dimensionResps.stream().map(dimension -> dimension.getId()).collect(Collectors.toList());
        tagFilter.setItemIds(dimensionIds);
        Map<Long, TagDO> keyAndTagMap = this.tagMetaService.getTagDOList(tagFilter).stream().collect(Collectors.toMap(tag -> tag.getItemId(), tag -> tag, (newTag, oldTag) -> newTag));
        if (Objects.nonNull(keyAndTagMap)) {
            dimensionResps.stream().forEach(dim -> {
                if (keyAndTagMap.containsKey(dim.getId())) {
                    dim.setIsTag(1);
                } else {
                    dim.setIsTag(0);
                }
            });
        }
    }

    @Override
    public List<String> mockAlias(DimensionReq dimensionReq, String mockType, User user) {
        String mockAlias = this.aliasGenerateHelper.generateAlias(mockType, dimensionReq.getName(), dimensionReq.getBizName(), "", dimensionReq.getDescription(), false);
        return (List)JSONObject.parseObject((String)mockAlias, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public List<DimValueMap> mockDimensionValueAlias(DimensionReq dimensionReq, User user) {
        ModelResp modelResp = this.modelService.getModel(dimensionReq.getModelId());
        ModelDetail modelDetail = modelResp.getModelDetail();
        String sqlQuery = modelDetail.getSqlQuery();
        DatabaseResp database = this.databaseService.getDatabase(modelResp.getDatabaseId());
        String sql = "select ai_talk." + dimensionReq.getBizName() + " from (" + sqlQuery + ") as ai_talk group by ai_talk." + dimensionReq.getBizName();
        SemanticQueryResp semanticQueryResp = this.databaseService.executeSql(sql, database);
        List resultList = semanticQueryResp.getResultList();
        ArrayList<String> valueList = new ArrayList<String>();
        for (Map stringObjectMap : resultList) {
            String value = (String)stringObjectMap.get(dimensionReq.getBizName());
            valueList.add(value);
        }
        String json = this.aliasGenerateHelper.generateDimensionValueAlias(JSON.toJSONString(valueList));
        log.info("return llm res is :{}", (Object)json);
        JSONObject jsonObject = JSON.parseObject((String)json);
        ArrayList<DimValueMap> dimValueMapsResp = new ArrayList<DimValueMap>();
        int i = 0;
        for (Map stringObjectMap : resultList) {
            DimValueMap dimValueMap = new DimValueMap();
            dimValueMap.setTechName(String.valueOf(stringObjectMap.get(dimensionReq.getBizName())));
            try {
                String tran = jsonObject.getJSONArray("tran").getString(i);
                dimValueMap.setBizName(tran);
            }
            catch (Exception exception) {
                dimValueMap.setBizName("");
            }
            try {
                dimValueMap.setAlias(jsonObject.getJSONObject("alias").getJSONArray("" + stringObjectMap.get(dimensionReq.getBizName())).toJavaList(String.class));
            }
            catch (Exception exception) {
                dimValueMap.setAlias(null);
            }
            dimValueMapsResp.add(dimValueMap);
            ++i;
        }
        return dimValueMapsResp;
    }

    private void checkExist(List<DimensionReq> dimensionReqs) {
        Long modelId = dimensionReqs.get(0).getModelId();
        List<DimensionResp> dimensionResps = this.getDimensions(modelId);
        Map<String, DimensionResp> bizNameMap = dimensionResps.stream().collect(Collectors.toMap(SchemaItem::getBizName, a -> a, (k1, k2) -> k1));
        Map<String, DimensionResp> nameMap = dimensionResps.stream().collect(Collectors.toMap(SchemaItem::getName, a -> a, (k1, k2) -> k1));
        for (DimensionReq dimensionReq : dimensionReqs) {
            DimensionResp dimensionResp;
            String forbiddenCharacters = NameCheckUtils.findForbiddenCharacters(dimensionReq.getName());
            if (StringUtils.isNotBlank((CharSequence)forbiddenCharacters)) {
                throw new InvalidArgumentException(String.format("\u540d\u79f0\u5305\u542b\u7279\u6b8a\u5b57\u7b26, \u8bf7\u4fee\u6539: %s\uff0c\u7279\u6b8a\u5b57\u7b26: %s", dimensionReq.getName(), forbiddenCharacters));
            }
            if (bizNameMap.containsKey(dimensionReq.getBizName()) && !(dimensionResp = bizNameMap.get(dimensionReq.getBizName())).getId().equals(dimensionReq.getId())) {
                throw new RuntimeException(String.format("\u8be5\u4e3b\u9898\u57df\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u5b57\u6bb5\u540d:%s \u521b\u5efa\u4eba:%s", dimensionReq.getBizName(), dimensionResp.getCreatedBy()));
            }
            if (!nameMap.containsKey(dimensionReq.getName()) || (dimensionResp = nameMap.get(dimensionReq.getName())).getId().equals(dimensionReq.getId())) continue;
            throw new RuntimeException(String.format("\u8be5\u4e3b\u9898\u57df\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u540d:%s \u521b\u5efa\u4eba:%s", dimensionReq.getName(), dimensionResp.getCreatedBy()));
        }
    }

    @Override
    public void sendDimensionEventBatch(List<Long> modelIds, EventType eventType) {
        DimensionFilter dimensionFilter = new DimensionFilter();
        dimensionFilter.setModelIds(modelIds);
        List<DimensionDO> dimensionDOS = this.queryDimension(dimensionFilter);
        this.sendEventBatch(dimensionDOS, eventType);
    }

    private void sendEventBatch(List<DimensionDO> dimensionDOS, EventType eventType) {
        DataEvent dataEvent = this.getDataEvent(dimensionDOS, eventType);
        this.eventPublisher.publishEvent((ApplicationEvent)dataEvent);
    }

    @Override
    public DataEvent getDataEvent() {
        DimensionFilter dimensionFilter = new DimensionFilter();
        List<DimensionDO> dimensionDOS = this.queryDimension(dimensionFilter);
        return this.getDataEvent(dimensionDOS, EventType.ADD);
    }

    private DataEvent getDataEvent(List<DimensionDO> dimensionDOS, EventType eventType) {
        List dataItems = dimensionDOS.stream().map(dimensionDO -> DataItem.builder().id(dimensionDO.getId() + "_").name(dimensionDO.getName()).modelId(dimensionDO.getModelId() + "_").type(TypeEnums.DIMENSION).build()).collect(Collectors.toList());
        return new DataEvent((Object)this, dataItems, eventType);
    }

    private void sendEvent(DataItem dataItem, EventType eventType) {
        this.eventPublisher.publishEvent((ApplicationEvent)new DataEvent((Object)this, (List)Lists.newArrayList((Object[])new DataItem[]{dataItem}), eventType));
    }
}

