/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.TagDefineType;
import com.tencent.supersonic.headless.api.pojo.request.TagDeleteReq;
import com.tencent.supersonic.headless.api.pojo.request.TagFilterPageReq;
import com.tencent.supersonic.headless.api.pojo.request.TagReq;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.TagItem;
import com.tencent.supersonic.headless.api.pojo.response.TagObjectResp;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.CollectDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.TagDO;
import com.tencent.supersonic.headless.server.persistence.repository.TagRepository;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.pojo.TagFilter;
import com.tencent.supersonic.headless.server.pojo.TagObjectFilter;
import com.tencent.supersonic.headless.server.web.service.CollectService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.DomainService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import com.tencent.supersonic.headless.server.web.service.TagObjectService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TagMetaServiceImpl
implements TagMetaService {
    private static final Logger log = LoggerFactory.getLogger(TagMetaServiceImpl.class);
    private final TagRepository tagRepository;
    private final ModelService modelService;
    private final CollectService collectService;
    private final DimensionService dimensionService;
    private final MetricService metricService;
    private final TagObjectService tagObjectService;
    private final DomainService domainService;

    public TagMetaServiceImpl(TagRepository tagRepository, ModelService modelService, CollectService collectService, @Lazy DimensionService dimensionService, @Lazy MetricService metricService, TagObjectService tagObjectService, DomainService domainService) {
        this.tagRepository = tagRepository;
        this.modelService = modelService;
        this.collectService = collectService;
        this.dimensionService = dimensionService;
        this.metricService = metricService;
        this.tagObjectService = tagObjectService;
        this.domainService = domainService;
    }

    @Override
    public TagResp create(TagReq tagReq, User user) {
        this.checkExist(tagReq);
        this.checkTagObject(tagReq);
        TagDO tagDO = this.convert(tagReq);
        Date date = new Date();
        tagDO.setId(null);
        tagDO.setCreatedBy(user.getName());
        tagDO.setCreatedAt(date);
        tagDO.setUpdatedBy(user.getName());
        tagDO.setUpdatedAt(date);
        this.tagRepository.create(tagDO);
        return this.getTag(tagDO.getId(), user);
    }

    @Override
    public Integer createBatch(List<TagReq> tagReqList, User user) {
        for (TagReq tagReq : tagReqList) {
            try {
                this.create(tagReq, user);
            }
            catch (Exception e) {
                log.warn("createBatch, e:{}", (Throwable)e);
            }
        }
        return tagReqList.size();
    }

    @Override
    public Boolean delete(Long id, User user) {
        this.tagRepository.delete(id);
        return true;
    }

    @Override
    public Boolean deleteBatch(List<TagDeleteReq> tagDeleteReqList, User user) {
        for (TagDeleteReq tagDeleteReq : tagDeleteReqList) {
            try {
                this.tagRepository.deleteBatch(tagDeleteReq);
            }
            catch (Exception e) {
                log.warn("createBatch, e:{}", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public TagResp getTag(Long id, User user) {
        TagDO tagDO = this.tagRepository.getTagById(id);
        if (Objects.isNull(tagDO)) {
            return null;
        }
        TagResp tagResp = this.convert2Resp(tagDO);
        List<TagResp> tagRespList = Arrays.asList(tagResp);
        this.fillModelInfo(tagRespList);
        this.fillDomainInfo(tagRespList);
        this.fillTagObjectInfo(tagRespList, user);
        this.fillCollectAndAdminInfo(tagRespList, user);
        return tagRespList.get(0);
    }

    @Override
    public List<TagResp> getTags(TagFilter tagFilter) {
        List<TagResp> tagRespList = this.tagRepository.queryTagRespList(tagFilter);
        return tagRespList;
    }

    @Override
    public List<TagDO> getTagDOList(TagFilter tagFilter) {
        return this.tagRepository.getTagDOList(tagFilter);
    }

    @Override
    public PageInfo<TagResp> queryTagMarketPage(TagFilterPageReq tagMarketPageReq, User user) {
        List<Object> modelRespList = this.getRelatedModel(tagMarketPageReq);
        if (CollectionUtils.isEmpty(modelRespList)) {
            return new PageInfo();
        }
        if (Objects.nonNull(tagMarketPageReq.getTagObjectId())) {
            modelRespList = modelRespList.stream().filter(modelResp -> tagMarketPageReq.getTagObjectId().equals(modelResp.getTagObjectId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(modelRespList)) {
            return new PageInfo();
        }
        List<Long> modelIds = modelRespList.stream().map(model -> model.getId()).collect(Collectors.toList());
        TagFilter tagFilter = new TagFilter();
        BeanUtils.copyProperties((Object)tagMarketPageReq, (Object)tagFilter);
        List<CollectDO> collectList = this.collectService.getCollectionList(user.getName());
        if (tagMarketPageReq.isHasCollect()) {
            List<Long> collectIds = collectList.stream().filter(collectDO -> SchemaElementType.TAG.name().equalsIgnoreCase(collectDO.getType())).map(CollectDO::getCollectId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collectIds)) {
                tagFilter.setIds(Lists.newArrayList((Object[])new Long[]{-1L}));
            } else {
                tagFilter.setIds(collectIds);
            }
        }
        tagFilter.setModelIds(modelIds);
        PageInfo tagDOPageInfo = PageHelper.startPage((int)tagMarketPageReq.getCurrent(), (int)tagMarketPageReq.getPageSize()).doSelectPageInfo(() -> this.getTags(tagFilter));
        List tagRespList = tagDOPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)tagRespList)) {
            return tagDOPageInfo;
        }
        this.fillModelInfo(tagRespList);
        this.fillDomainInfo(tagRespList);
        this.fillTagObjectInfo(tagRespList, user);
        this.fillCollectAndAdminInfo(tagRespList, user);
        tagDOPageInfo.setList(tagRespList);
        return tagDOPageInfo;
    }

    private void fillTagObjectInfo(List<TagResp> tagRespList, User user) {
        TagObjectFilter filter = new TagObjectFilter();
        List<TagObjectResp> tagObjects = this.tagObjectService.getTagObjects(filter, user);
        if (CollectionUtils.isEmpty(tagObjects)) {
            return;
        }
        Map<Long, TagObjectResp> tagObjectMap = tagObjects.stream().collect(Collectors.toMap(SchemaItem::getId, tagObject -> tagObject, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(tagRespList)) {
            tagRespList.stream().forEach(tagResp -> {
                if (tagObjectMap.containsKey(tagResp.getTagObjectId())) {
                    tagResp.setTagObjectName(((TagObjectResp)tagObjectMap.get(tagResp.getTagObjectId())).getName());
                }
            });
        }
    }

    private TagResp fillTagObjectInfo(TagResp tagResp, User user) {
        Long modelId = tagResp.getModelId();
        ModelResp model = this.modelService.getModel(modelId);
        TagObjectResp tagObject = this.tagObjectService.getTagObject(model.getTagObjectId(), user);
        tagResp.setTagObjectId(tagObject.getId());
        tagResp.setTagObjectName(tagObject.getName());
        return tagResp;
    }

    private void fillDomainInfo(List<TagResp> tagRespList) {
        Map<Long, DomainResp> domainMap = this.domainService.getDomainList().stream().collect(Collectors.toMap(SchemaItem::getId, domain -> domain, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(tagRespList) && Objects.nonNull(domainMap)) {
            tagRespList.stream().forEach(tagResp -> {
                if (domainMap.containsKey(tagResp.getDomainId())) {
                    tagResp.setDomainName(((DomainResp)domainMap.get(tagResp.getDomainId())).getName());
                }
            });
        }
    }

    private TagResp convert2Resp(TagDO tagDO) {
        TagResp tagResp = new TagResp();
        BeanUtils.copyProperties((Object)tagDO, (Object)tagResp);
        tagResp.setTagDefineType(tagDO.getType());
        if (TagDefineType.METRIC.name().equalsIgnoreCase(tagDO.getType())) {
            MetricResp metric = this.metricService.getMetric(tagDO.getItemId());
            tagResp.setBizName(metric.getBizName());
            tagResp.setName(metric.getName());
            tagResp.setModelId(metric.getModelId());
            tagResp.setModelName(metric.getModelName());
            tagResp.setDomainId(metric.getDomainId());
            tagResp.setSensitiveLevel(metric.getSensitiveLevel());
            tagResp.setExt(metric.getExt());
        }
        if (TagDefineType.DIMENSION.name().equalsIgnoreCase(tagDO.getType())) {
            DimensionResp dimensionResp = this.dimensionService.getDimension(tagDO.getItemId());
            tagResp.setBizName(dimensionResp.getBizName());
            tagResp.setName(dimensionResp.getName());
            tagResp.setModelId(dimensionResp.getModelId());
            tagResp.setModelName(dimensionResp.getModelName());
            tagResp.setSensitiveLevel(dimensionResp.getSensitiveLevel());
            tagResp.setExt(dimensionResp.getExt());
        }
        return tagResp;
    }

    private List<ModelResp> getRelatedModel(TagFilterPageReq tagMarketPageReq) {
        ArrayList<ModelResp> modelRespList = new ArrayList<ModelResp>();
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setDomainIds(tagMarketPageReq.getDomainIds());
        modelFilter.setIds(tagMarketPageReq.getModelIds());
        Map<Long, ModelResp> modelMap = this.modelService.getModelMap(modelFilter);
        for (Long modelId : modelMap.keySet()) {
            ModelResp modelResp = modelMap.get(modelId);
            if (Objects.isNull(modelResp) || CollectionUtils.isNotEmpty((Collection)tagMarketPageReq.getDomainIds()) && !tagMarketPageReq.getDomainIds().contains(modelResp.getDomainId()) || CollectionUtils.isNotEmpty((Collection)tagMarketPageReq.getModelIds()) && !tagMarketPageReq.getModelIds().contains(modelResp.getId())) continue;
            modelRespList.add(modelResp);
        }
        return modelRespList;
    }

    private void fillModelInfo(List<TagResp> tagRespList) {
        List<Long> modelIds = tagRespList.stream().map(TagResp::getModelId).collect(Collectors.toList());
        ModelFilter modelFilter = new ModelFilter(false, modelIds);
        Map<Long, ModelResp> modelIdAndRespMap = this.modelService.getModelMap(modelFilter);
        tagRespList.stream().forEach(tagResp -> {
            if (Objects.nonNull(modelIdAndRespMap) && modelIdAndRespMap.containsKey(tagResp.getModelId())) {
                tagResp.setModelName(((ModelResp)modelIdAndRespMap.get(tagResp.getModelId())).getName());
                tagResp.setDomainId(((ModelResp)modelIdAndRespMap.get(tagResp.getModelId())).getDomainId());
                tagResp.setTagObjectId(((ModelResp)modelIdAndRespMap.get(tagResp.getModelId())).getTagObjectId());
            }
        });
    }

    private TagResp fillCollectAndAdminInfo(TagResp tagResp, User user) {
        List collectIds = this.collectService.getCollectionList(user.getName()).stream().filter(collectDO -> TypeEnums.TAG.name().equalsIgnoreCase(collectDO.getType())).map(CollectDO::getCollectId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collectIds) && collectIds.contains(tagResp.getId())) {
            tagResp.setIsCollect(Boolean.valueOf(true));
        } else {
            tagResp.setIsCollect(Boolean.valueOf(false));
        }
        List<TagResp> tagRespList = Arrays.asList(tagResp);
        this.fillAdminRes(tagRespList, user);
        return tagRespList.get(0);
    }

    private TagResp fillCollectAndAdminInfo(List<TagResp> tagRespList, User user) {
        List collectIds = this.collectService.getCollectionList(user.getName()).stream().filter(collectDO -> TypeEnums.TAG.name().equalsIgnoreCase(collectDO.getType())).map(CollectDO::getCollectId).collect(Collectors.toList());
        tagRespList.stream().forEach(tagResp -> {
            if (CollectionUtils.isNotEmpty((Collection)collectIds) && collectIds.contains(tagResp.getId())) {
                tagResp.setIsCollect(Boolean.valueOf(true));
            } else {
                tagResp.setIsCollect(Boolean.valueOf(false));
            }
        });
        this.fillAdminRes(tagRespList, user);
        return tagRespList.get(0);
    }

    private void fillAdminRes(List<TagResp> tagRespList, User user) {
        List<ModelResp> modelRespList = this.modelService.getModelListWithAuth(user, null, AuthType.ADMIN);
        if (CollectionUtils.isEmpty(modelRespList)) {
            return;
        }
        Set modelIdSet = modelRespList.stream().map(SchemaItem::getId).collect(Collectors.toSet());
        for (TagResp tagResp : tagRespList) {
            if (modelIdSet.contains(tagResp.getModelId()) || tagResp.getCreatedBy().equalsIgnoreCase(user.getName())) {
                tagResp.setHasAdminRes(true);
                continue;
            }
            tagResp.setHasAdminRes(false);
        }
    }

    private void checkExist(TagReq tagReq) {
        List<TagDO> tagRespList;
        TagFilter tagFilter = new TagFilter();
        tagFilter.setTagDefineType(tagReq.getTagDefineType());
        if (Objects.nonNull(tagReq.getItemId())) {
            tagFilter.setItemIds(Arrays.asList(tagReq.getItemId()));
        }
        if (!CollectionUtils.isEmpty(tagRespList = this.tagRepository.getTagDOList(tagFilter))) {
            throw new RuntimeException(String.format("the tag is exit, itemId:%s", tagReq.getItemId()));
        }
    }

    private void checkTagObject(TagReq tagReq) {
        MetricResp metric;
        DimensionResp dimension;
        ModelResp model;
        if (TagDefineType.DIMENSION.equals((Object)tagReq.getTagDefineType()) && Objects.isNull((model = this.modelService.getModel((dimension = this.dimensionService.getDimension(tagReq.getItemId())).getModelId())).getTagObjectId())) {
            throw new RuntimeException(String.format("this dimension:%s is not supported to create tag, no related tag object", tagReq.getItemId()));
        }
        if (TagDefineType.METRIC.equals((Object)tagReq.getTagDefineType()) && Objects.isNull((model = this.modelService.getModel((metric = this.metricService.getMetric(tagReq.getItemId())).getModelId())).getTagObjectId())) {
            throw new RuntimeException(String.format("this metric:%s is not supported to create tag, no related tag object", tagReq.getItemId()));
        }
    }

    private TagDO convert(TagReq tagReq) {
        TagDO tagDO = new TagDO();
        BeanUtils.copyProperties((Object)tagReq, (Object)tagDO);
        tagDO.setType(tagReq.getTagDefineType().name());
        return tagDO;
    }

    @Override
    public List<TagItem> getTagItems(List<Long> itemIds, TagDefineType tagDefineType) {
        TagFilter tagFilter = new TagFilter();
        tagFilter.setTagDefineType(tagDefineType);
        tagFilter.setItemIds(itemIds);
        Set dimensionItemSet = this.getTagDOList(tagFilter).stream().map(TagDO::getItemId).collect(Collectors.toSet());
        return itemIds.stream().map(entry -> {
            TagItem tagItem = new TagItem();
            tagItem.setIsTag(Boolean.compare(dimensionItemSet.contains(entry), false));
            tagItem.setItemId(entry);
            return tagItem;
        }).collect(Collectors.toList());
    }
}

