/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.TagFilterPageReq;
import com.tencent.supersonic.headless.api.pojo.request.TagObjectReq;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.TagObjectResp;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.TagObjectDO;
import com.tencent.supersonic.headless.server.persistence.repository.TagObjectRepository;
import com.tencent.supersonic.headless.server.pojo.TagObjectFilter;
import com.tencent.supersonic.headless.server.utils.TagObjectConverter;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import com.tencent.supersonic.headless.server.web.service.TagObjectService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TagObjectServiceImpl
implements TagObjectService {
    private final TagObjectRepository tagObjectRepository;
    private final ModelService modelService;
    private final TagMetaService tagMetaService;

    public TagObjectServiceImpl(TagObjectRepository tagObjectRepository, ModelService modelService, @Lazy TagMetaService tagMetaService) {
        this.tagObjectRepository = tagObjectRepository;
        this.modelService = modelService;
        this.tagMetaService = tagMetaService;
    }

    @Override
    public TagObjectResp create(TagObjectReq tagObjectReq, User user) throws Exception {
        this.checkParam(tagObjectReq, user);
        TagObjectDO tagObjectDO = TagObjectConverter.convert(tagObjectReq);
        Date date = new Date();
        tagObjectDO.setCreatedBy(user.getName());
        tagObjectDO.setCreatedAt(date);
        tagObjectDO.setUpdatedBy(user.getName());
        tagObjectDO.setUpdatedAt(date);
        tagObjectDO.setStatus(StatusEnum.ONLINE.getCode());
        this.tagObjectRepository.create(tagObjectDO);
        TagObjectDO tagObjectById = this.tagObjectRepository.getTagObjectById(tagObjectDO.getId());
        return TagObjectConverter.convert2Resp(tagObjectById);
    }

    private void checkParam(TagObjectReq tagObjectReq, User user) throws Exception {
        TagObjectFilter filter = new TagObjectFilter();
        filter.setDomainId(tagObjectReq.getDomainId());
        List<Object> tagObjectRespList = this.getTagObjects(filter, user);
        if (CollectionUtils.isEmpty(tagObjectRespList)) {
            return;
        }
        tagObjectRespList = tagObjectRespList.stream().filter(tagObjectResp -> StatusEnum.ONLINE.getCode().equals(tagObjectResp.getStatus())).collect(Collectors.toList());
        for (TagObjectResp tagObjectResp2 : tagObjectRespList) {
            if (tagObjectResp2.getBizName().equalsIgnoreCase(tagObjectReq.getBizName())) {
                throw new Exception(String.format("the bizName %s is exist", tagObjectReq.getBizName()));
            }
            if (!tagObjectResp2.getName().equalsIgnoreCase(tagObjectReq.getName())) continue;
            throw new Exception(String.format("the name %s is exist", tagObjectReq.getName()));
        }
    }

    @Override
    public TagObjectResp update(TagObjectReq tagObjectReq, User user) {
        TagObjectDO tagObjectDO = this.tagObjectRepository.getTagObjectById(tagObjectReq.getId());
        BeanMapper.mapper((Object)tagObjectReq, (Object)tagObjectDO);
        tagObjectDO.setUpdatedAt(new Date());
        tagObjectDO.setUpdatedBy(user.getName());
        this.tagObjectRepository.update(tagObjectDO);
        TagObjectDO tagObjectById = this.tagObjectRepository.getTagObjectById(tagObjectReq.getId());
        return TagObjectConverter.convert2Resp(tagObjectById);
    }

    @Override
    public Boolean delete(Long id, User user) throws Exception {
        TagObjectDO tagObjectDO = this.tagObjectRepository.getTagObjectById(id);
        this.checkDeletePermission(tagObjectDO, user);
        this.checkTagObjectStatus(tagObjectDO, user);
        tagObjectDO.setUpdatedAt(new Date());
        tagObjectDO.setUpdatedBy(user.getName());
        tagObjectDO.setStatus(StatusEnum.DELETED.getCode());
        this.tagObjectRepository.update(tagObjectDO);
        return true;
    }

    @Override
    public Boolean delete(Long id, User user, Boolean checkStatus) throws Exception {
        TagObjectDO tagObjectDO = this.tagObjectRepository.getTagObjectById(id);
        this.checkDeletePermission(tagObjectDO, user);
        if (checkStatus.booleanValue()) {
            this.checkTagObjectStatus(tagObjectDO, user);
        }
        tagObjectDO.setUpdatedAt(new Date());
        tagObjectDO.setUpdatedBy(user.getName());
        tagObjectDO.setStatus(StatusEnum.DELETED.getCode());
        this.tagObjectRepository.update(tagObjectDO);
        return true;
    }

    private void checkTagObjectStatus(TagObjectDO tagObjectDO, User user) throws Exception {
        List tagRespList;
        List<ModelResp> allModelByDomainIds = this.modelService.getAllModelByDomainIds(Arrays.asList(tagObjectDO.getDomainId()));
        if (!CollectionUtils.isEmpty(allModelByDomainIds)) {
            List modelIds = allModelByDomainIds.stream().map(SchemaItem::getId).collect(Collectors.toList());
            throw new Exception("delete operation is not supported at the moment. related modelIds:" + modelIds);
        }
        TagFilterPageReq tagMarketPageReq = new TagFilterPageReq();
        tagMarketPageReq.setTagObjectId(tagObjectDO.getId());
        PageInfo<TagResp> respPageInfo = this.tagMetaService.queryTagMarketPage(tagMarketPageReq, user);
        if (Objects.nonNull(respPageInfo) && !CollectionUtils.isEmpty((Collection)(tagRespList = respPageInfo.getList()))) {
            List tagIds = tagRespList.stream().map(TagResp::getId).collect(Collectors.toList());
            throw new Exception("delete operation is not supported at the moment. related tagIds:" + tagIds);
        }
    }

    private void checkDeletePermission(TagObjectDO tagObjectDO, User user) throws Exception {
        if (user.getName().equalsIgnoreCase(tagObjectDO.getCreatedBy()) || user.isSuperAdmin()) {
            return;
        }
        throw new Exception("delete operation is not supported at the moment. Please contact the admin.");
    }

    @Override
    public TagObjectResp getTagObject(Long id, User user) {
        TagObjectDO tagObjectDO = this.tagObjectRepository.getTagObjectById(id);
        return TagObjectConverter.convert2Resp(tagObjectDO);
    }

    @Override
    public List<TagObjectResp> getTagObjects(TagObjectFilter filter, User user) {
        List<TagObjectDO> tagObjectDOList = this.tagObjectRepository.query(filter);
        return TagObjectConverter.convert2RespList(tagObjectDOList);
    }

    @Override
    public Map<Long, TagObjectResp> getAllTagObjectMap() {
        TagObjectFilter filter = new TagObjectFilter();
        List<TagObjectDO> tagObjectDOList = this.tagObjectRepository.query(filter);
        List<TagObjectResp> tagObjectRespList = TagObjectConverter.convert2RespList(tagObjectDOList);
        Map<Long, TagObjectResp> map = tagObjectRespList.stream().collect(Collectors.toMap(SchemaItem::getId, a -> a, (k1, k2) -> k1));
        return map;
    }
}

