/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.headless.api.pojo.Dim;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.ValueDistribution;
import com.tencent.supersonic.headless.api.pojo.enums.TagDefineType;
import com.tencent.supersonic.headless.api.pojo.request.ItemValueReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.ItemValueResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.core.utils.SqlGenerateUtils;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import com.tencent.supersonic.headless.server.web.service.TagQueryService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TagQueryServiceImpl
implements TagQueryService {
    private static final Logger log = LoggerFactory.getLogger(TagQueryServiceImpl.class);
    @Value(value="${item.value.date.before:3}")
    private Integer dayBefore;
    private final String tagValueAlias = "internalTagCount";
    private final String maxDateAlias = "internalMaxDate";
    private final TagMetaService tagMetaService;
    private final SemanticLayerService queryService;
    private final ModelService modelService;
    private final SqlGenerateUtils sqlGenerateUtils;

    public TagQueryServiceImpl(TagMetaService tagMetaService, SemanticLayerService queryService, ModelService modelService, SqlGenerateUtils sqlGenerateUtils) {
        this.tagMetaService = tagMetaService;
        this.queryService = queryService;
        this.modelService = modelService;
        this.sqlGenerateUtils = sqlGenerateUtils;
    }

    @Override
    public ItemValueResp queryTagValue(ItemValueReq itemValueReq, User user) throws Exception {
        ItemValueResp itemValueResp = new ItemValueResp();
        itemValueResp.setItemId(itemValueReq.getId());
        itemValueResp.setType(SchemaElementType.TAG);
        TagResp tag = this.tagMetaService.getTag(itemValueReq.getId(), user);
        if (Objects.isNull(tag)) {
            return null;
        }
        this.checkTag(tag);
        itemValueResp.setName(tag.getName());
        itemValueResp.setBizName(tag.getBizName());
        this.correctDateConf(itemValueReq, tag, user);
        Long totalCount = this.queryTagTotalCount(tag, itemValueReq, user);
        QuerySqlReq querySqlReq = this.generateReq(tag, itemValueReq);
        SemanticQueryResp semanticQueryResp = this.queryService.queryByReq((SemanticQueryReq)querySqlReq, user);
        this.fillTagValueInfo(itemValueResp, semanticQueryResp, totalCount);
        return itemValueResp;
    }

    private void checkTag(TagResp tag) throws Exception {
        if (Objects.nonNull(tag) && TagDefineType.METRIC.name().equalsIgnoreCase(tag.getTagDefineType())) {
            throw new Exception("do not support value distribution query for tag (from metric): " + tag.getBizName());
        }
    }

    private void correctDateConf(ItemValueReq itemValueReq, TagResp tag, User user) throws Exception {
        ModelResp model = this.modelService.getModel(tag.getModelId());
        List timeDimension = model.getTimeDimension();
        if (CollectionUtils.isEmpty((Collection)timeDimension)) {
            itemValueReq.setDateConf(null);
            return;
        }
        if (Objects.nonNull(itemValueReq.getDateConf())) {
            return;
        }
        String endDate = this.queryTagDateFromDbBySql((Dim)timeDimension.get(0), tag, user);
        DateConf dateConf = new DateConf();
        dateConf.setDateMode(DateConf.DateMode.BETWEEN);
        dateConf.setStartDate(endDate);
        dateConf.setEndDate(endDate);
        itemValueReq.setDateConf(dateConf);
    }

    private String queryTagDate(Dim dim) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dim.getDateFormat());
        return LocalDate.now().plusDays(-this.dayBefore.intValue()).format(formatter);
    }

    private String queryTagDateFromDbBySql(Dim dim, TagResp tag, User user) throws Exception {
        String sqlPattern = "select max(%s)  as %s from tbl where %s is not null";
        String sql = String.format(sqlPattern, TimeDimensionEnum.DAY.getName(), "internalMaxDate", tag.getBizName());
        HashSet<Long> modelIds = new HashSet<Long>();
        modelIds.add(tag.getModelId());
        QuerySqlReq querySqlReq = new QuerySqlReq();
        querySqlReq.setSql(sql);
        querySqlReq.setNeedAuth(false);
        querySqlReq.setModelIds(modelIds);
        log.info("queryTagDateFromDbBySql, QuerySqlReq:{}", (Object)querySqlReq.toCustomizedString());
        try {
            Object date;
            SemanticQueryResp semanticQueryResp = this.queryService.queryByReq((SemanticQueryReq)querySqlReq, user);
            if (!CollectionUtils.isEmpty((Collection)semanticQueryResp.getResultList()) && Objects.nonNull(date = ((Map)semanticQueryResp.getResultList().get(0)).get("internalMaxDate"))) {
                return date.toString();
            }
        }
        catch (Exception e) {
            log.warn("queryTagDateFromDbBySql date info e, e:{}", (Throwable)e);
        }
        String dateDefault = this.queryTagDate(dim);
        log.info("queryTagDate by default, dateDefault:{}.", (Object)dateDefault);
        return dateDefault;
    }

    private Long queryTagTotalCount(TagResp tag, ItemValueReq itemValueReq, User user) throws Exception {
        Object total;
        String sqlPattern = "select count(1)  as %s from tbl where %s is not null %s";
        String dateFilter = this.getDateFilter(itemValueReq);
        String sql = String.format(sqlPattern, "internalTagCount", tag.getBizName(), dateFilter);
        HashSet<Long> modelIds = new HashSet<Long>();
        modelIds.add(tag.getModelId());
        QuerySqlReq querySqlReq = new QuerySqlReq();
        querySqlReq.setSql(sql);
        querySqlReq.setNeedAuth(false);
        querySqlReq.setModelIds(modelIds);
        SemanticQueryResp semanticQueryResp = this.queryService.queryByReq((SemanticQueryReq)querySqlReq, user);
        if (!CollectionUtils.isEmpty((Collection)semanticQueryResp.getResultList()) && Objects.nonNull(total = ((Map)semanticQueryResp.getResultList().get(0)).get("internalTagCount"))) {
            long tagCount = Long.parseLong(total.toString());
            log.info("queryTagTotalCount, tagCount:{}, tagId:{}", (Object)tagCount, (Object)tag.getId());
            return Long.parseLong(total.toString());
        }
        throw new RuntimeException("queryTagTotalCount error");
    }

    private String getDateFilter(ItemValueReq itemValueReq) {
        if (Objects.isNull(itemValueReq.getDateConf())) {
            return "";
        }
        String dateWhereClause = this.sqlGenerateUtils.getDateWhereClause(itemValueReq.getDateConf(), null);
        return " and " + dateWhereClause;
    }

    private void fillTagValueInfo(ItemValueResp itemValueResp, SemanticQueryResp semanticQueryResp, Long totalCount) {
        ArrayList valueDistributionList = new ArrayList();
        List resultList = semanticQueryResp.getResultList();
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            resultList.stream().forEach(line -> {
                Object tagValue = line.get(itemValueResp.getBizName());
                Long tagValueCount = Long.parseLong(line.get("internalTagCount").toString());
                valueDistributionList.add(ValueDistribution.builder().totalCount(totalCount).valueMap(tagValue).valueCount(tagValueCount).ratio(Double.valueOf(1.0 * (double)tagValueCount.longValue() / (double)totalCount.longValue())).build());
            });
        }
        itemValueResp.setValueDistributionList(valueDistributionList);
    }

    private QuerySqlReq generateReq(TagResp tag, ItemValueReq itemValueReq) {
        String sqlPattern = "select %s, count(1)  as %s from tbl where %s is not null %s group by %s order by %s desc";
        String sql = String.format(sqlPattern, tag.getBizName(), "internalTagCount", tag.getBizName(), this.getDateFilter(itemValueReq), tag.getBizName(), tag.getBizName());
        HashSet<Long> modelIds = new HashSet<Long>();
        modelIds.add(tag.getModelId());
        QuerySqlReq querySqlReq = new QuerySqlReq();
        querySqlReq.setSql(sql);
        querySqlReq.setNeedAuth(false);
        querySqlReq.setModelIds(modelIds);
        return querySqlReq;
    }

    private DateConf generateDateConf(ItemValueReq itemValueReq) {
        DateConf dateConf = itemValueReq.getDateConf();
        if (Objects.isNull(dateConf)) {
            dateConf = new DateConf();
            dateConf.setDateMode(DateConf.DateMode.RECENT);
            dateConf.setUnit(Integer.valueOf(1));
        }
        return dateConf;
    }
}

