/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.enums.WorkflowState;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.chat.QueryContext;
import com.tencent.supersonic.headless.chat.corrector.SemanticCorrector;
import com.tencent.supersonic.headless.chat.mapper.SchemaMapper;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.chat.query.rule.RuleSemanticQuery;
import com.tencent.supersonic.headless.server.processor.ResultProcessor;
import com.tencent.supersonic.headless.server.utils.ComponentFactory;
import com.tencent.supersonic.headless.server.web.service.WorkflowService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private List<SchemaMapper> schemaMappers = ComponentFactory.getSchemaMappers();
    private List<SemanticParser> semanticParsers = ComponentFactory.getSemanticParsers();
    private List<SemanticCorrector> semanticCorrectors = ComponentFactory.getSemanticCorrectors();
    private List<ResultProcessor> resultProcessors = ComponentFactory.getResultProcessors();

    @Override
    public void startWorkflow(QueryContext queryCtx, ChatContext chatCtx, ParseResp parseResult) {
        queryCtx.setWorkflowState(WorkflowState.MAPPING);
        block5: while (queryCtx.getWorkflowState() != WorkflowState.FINISHED) {
            switch (queryCtx.getWorkflowState()) {
                case MAPPING: {
                    this.performMapping(queryCtx);
                    queryCtx.setWorkflowState(WorkflowState.PARSING);
                    continue block5;
                }
                case PARSING: {
                    this.performParsing(queryCtx, chatCtx);
                    queryCtx.setWorkflowState(WorkflowState.CORRECTING);
                    continue block5;
                }
                case CORRECTING: {
                    this.performCorrecting(queryCtx);
                    queryCtx.setWorkflowState(WorkflowState.PROCESSING);
                    continue block5;
                }
            }
            this.performProcessing(queryCtx, chatCtx, parseResult);
            queryCtx.setWorkflowState(WorkflowState.FINISHED);
        }
    }

    public void performMapping(QueryContext queryCtx) {
        if (Objects.isNull(queryCtx.getMapInfo()) || MapUtils.isEmpty((Map)queryCtx.getMapInfo().getDataSetElementMatches())) {
            this.schemaMappers.forEach(mapper -> mapper.map(queryCtx));
        }
    }

    public void performParsing(QueryContext queryCtx, ChatContext chatCtx) {
        this.semanticParsers.forEach(parser -> {
            parser.parse(queryCtx, chatCtx);
            log.debug("{} result:{}", (Object)parser.getClass().getSimpleName(), (Object)JsonUtil.toString((Object)queryCtx));
        });
    }

    public void performCorrecting(QueryContext queryCtx) {
        List candidateQueries = queryCtx.getCandidateQueries();
        if (CollectionUtils.isNotEmpty((Collection)candidateQueries)) {
            block0: for (SemanticQuery semanticQuery : candidateQueries) {
                if (semanticQuery instanceof RuleSemanticQuery) continue;
                for (SemanticCorrector corrector : this.semanticCorrectors) {
                    corrector.correct(queryCtx, semanticQuery.getParseInfo());
                    if (WorkflowState.CORRECTING.equals((Object)queryCtx.getWorkflowState())) continue;
                    continue block0;
                }
            }
        }
    }

    public void performProcessing(QueryContext queryCtx, ChatContext chatCtx, ParseResp parseResult) {
        this.resultProcessors.forEach(processor -> processor.process(parseResult, queryCtx, chatCtx));
    }
}

