/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.aspect;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.jsqlparser.FieldExpression;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.DimValueMap;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class DimValueAspect {
    private static final Logger log = LoggerFactory.getLogger(DimValueAspect.class);
    @Value(value="${s2.dimension.value.map.enable:true}")
    private Boolean dimensionValueMapEnable;
    @Autowired
    private DimensionService dimensionService;

    @Around(value="execution(* com.tencent.supersonic.headless.server.facade.service.SemanticLayerService.queryByReq(..))")
    public Object handleDimValue(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.dimensionValueMapEnable.booleanValue()) {
            log.debug("dimensionValueMapEnable is false, skip dimensionValueMap");
            SemanticQueryResp queryResultWithColumns = (SemanticQueryResp)joinPoint.proceed();
            return queryResultWithColumns;
        }
        Object[] args = joinPoint.getArgs();
        SemanticQueryReq queryReq = (SemanticQueryReq)args[0];
        if (queryReq instanceof QueryStructReq) {
            return this.handleStructDimValue(joinPoint);
        }
        if (queryReq instanceof QuerySqlReq) {
            return this.handleSqlDimValue(joinPoint);
        }
        throw new InvalidArgumentException("queryReq is not Invalid:" + queryReq);
    }

    private SemanticQueryResp handleStructDimValue(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        QueryStructReq queryStructReq = (QueryStructReq)args[0];
        MetaFilter metaFilter = new MetaFilter(Lists.newArrayList((Iterable)queryStructReq.getModelIds()));
        List<DimensionResp> dimensions = this.dimensionService.getDimensions(metaFilter);
        Map<String, Map<String, String>> dimAndAliasAndTechNamePair = this.getAliasAndBizNameToTechName(dimensions);
        Map<String, Map<String, String>> dimAndTechNameAndBizNamePair = this.getTechNameToBizName(dimensions);
        this.rewriteFilter(queryStructReq.getDimensionFilters(), dimAndAliasAndTechNamePair);
        SemanticQueryResp semanticQueryResp = (SemanticQueryResp)joinPoint.proceed();
        if (Objects.nonNull(semanticQueryResp)) {
            this.rewriteDimValue(semanticQueryResp, dimAndTechNameAndBizNamePair);
        }
        return semanticQueryResp;
    }

    public Object handleSqlDimValue(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        QuerySqlReq querySqlReq = (QuerySqlReq)args[0];
        MetaFilter metaFilter = new MetaFilter(Lists.newArrayList((Iterable)querySqlReq.getModelIds()));
        String sql = querySqlReq.getSql();
        log.debug("correctorSql before replacing:{}", (Object)sql);
        List fieldExpressionList = SqlSelectHelper.getWhereExpressions((String)sql);
        List<DimensionResp> dimensions = this.dimensionService.getDimensions(metaFilter);
        Set fieldNames = dimensions.stream().map(SchemaItem::getName).collect(Collectors.toSet());
        HashMap<String, Map<String, String>> filedNameToValueMap = new HashMap<String, Map<String, String>>();
        for (FieldExpression expression : fieldExpressionList) {
            if (!fieldNames.contains(expression.getFieldName())) continue;
            for (DimensionResp dimension : dimensions) {
                if (!expression.getFieldName().equals(dimension.getName()) || CollectionUtils.isEmpty((Collection)dimension.getDimValueMaps())) continue;
                if (expression.getOperator().equals(FilterOperatorEnum.EQUALS.getValue())) {
                    dimension.getDimValueMaps().stream().forEach(dimValue -> {
                        if (!CollectionUtils.isEmpty((Collection)dimValue.getAlias()) && dimValue.getAlias().contains(expression.getFieldValue().toString())) {
                            this.getFiledNameToValueMap(filedNameToValueMap, expression.getFieldValue().toString(), dimValue.getTechName(), expression.getFieldName());
                        }
                    });
                }
                this.replaceInCondition(expression, dimension, filedNameToValueMap);
            }
        }
        sql = SqlReplaceHelper.replaceValue((String)sql, filedNameToValueMap);
        log.debug("correctorSql after replacing:{}", (Object)sql);
        querySqlReq.setSql(sql);
        Map<String, Map<String, String>> techNameToBizName = this.getTechNameToBizName(dimensions);
        SemanticQueryResp queryResultWithColumns = (SemanticQueryResp)joinPoint.proceed();
        if (Objects.nonNull(queryResultWithColumns)) {
            this.rewriteDimValue(queryResultWithColumns, techNameToBizName);
        }
        return queryResultWithColumns;
    }

    public void replaceInCondition(FieldExpression expression, DimensionResp dimension, Map<String, Map<String, String>> filedNameToValueMap) {
        if (expression.getOperator().equals(FilterOperatorEnum.IN.getValue())) {
            String fieldValue = JsonUtil.toString((Object)expression.getFieldValue());
            fieldValue = fieldValue.replace("'", "");
            List values = JsonUtil.toList((String)fieldValue, String.class);
            ArrayList<String> revisedValues = new ArrayList<String>();
            for (int i = 0; i < values.size(); ++i) {
                Boolean flag = new Boolean(false);
                for (DimValueMap dimValueMap : dimension.getDimValueMaps()) {
                    if (CollectionUtils.isEmpty((Collection)dimValueMap.getAlias()) || !dimValueMap.getAlias().contains(values.get(i))) continue;
                    flag = true;
                    revisedValues.add(dimValueMap.getTechName());
                    break;
                }
                if (flag.booleanValue()) continue;
                revisedValues.add((String)values.get(i));
            }
            if (!revisedValues.equals(values)) {
                this.getFiledNameToValueMap(filedNameToValueMap, JsonUtil.toString((Object)values), JsonUtil.toString(revisedValues), expression.getFieldName());
            }
        }
    }

    public void getFiledNameToValueMap(Map<String, Map<String, String>> filedNameToValueMap, String oldValue, String newValue, String fieldName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(oldValue, newValue);
        filedNameToValueMap.put(fieldName, map);
    }

    private void rewriteDimValue(SemanticQueryResp semanticQueryResp, Map<String, Map<String, String>> dimAndTechNameAndBizNamePair) {
        if (!this.selectDimValueMap(semanticQueryResp.getColumns(), dimAndTechNameAndBizNamePair)) {
            return;
        }
        log.debug("start rewriteDimValue for resultList");
        for (Map line : semanticQueryResp.getResultList()) {
            for (String bizName : line.keySet()) {
                String bizValueName;
                if (!dimAndTechNameAndBizNamePair.containsKey(bizName) || !Objects.nonNull(line.get(bizName))) continue;
                String techName = line.get(bizName).toString();
                Map<String, String> techAndBizPair = dimAndTechNameAndBizNamePair.get(bizName);
                if (CollectionUtils.isEmpty(techAndBizPair) || !techAndBizPair.containsKey(techName) || !StringUtils.isNotEmpty((CharSequence)(bizValueName = techAndBizPair.get(techName)))) continue;
                line.put(bizName, bizValueName);
            }
        }
    }

    private boolean selectDimValueMap(List<QueryColumn> columns, Map<String, Map<String, String>> dimAndTechNameAndBizNamePair) {
        if (CollectionUtils.isEmpty(dimAndTechNameAndBizNamePair) || CollectionUtils.isEmpty(dimAndTechNameAndBizNamePair)) {
            return false;
        }
        for (QueryColumn queryColumn : columns) {
            if (!dimAndTechNameAndBizNamePair.containsKey(queryColumn.getNameEn())) continue;
            return true;
        }
        return false;
    }

    private void rewriteFilter(List<Filter> dimensionFilters, Map<String, Map<String, String>> aliasAndTechNamePair) {
        for (Filter filter : dimensionFilters) {
            if (Objects.isNull(filter)) continue;
            if (CollectionUtils.isEmpty((Collection)filter.getChildren())) {
                Object value = filter.getValue();
                String bizName = filter.getBizName();
                if (aliasAndTechNamePair.containsKey(bizName)) {
                    Map<String, String> aliasPair = aliasAndTechNamePair.get(bizName);
                    if (Objects.nonNull(value)) {
                        if (value instanceof List) {
                            List values = (List)value;
                            ArrayList<String> valuesNew = new ArrayList<String>();
                            for (String valueSingle : values) {
                                if (aliasPair.containsKey(valueSingle)) {
                                    valuesNew.add(aliasPair.get(valueSingle));
                                    continue;
                                }
                                valuesNew.add(valueSingle);
                            }
                            filter.setValue(valuesNew);
                        }
                        if (value instanceof String && aliasPair.containsKey(value)) {
                            filter.setValue((Object)aliasPair.get(value));
                        }
                    }
                }
                return;
            }
            this.rewriteFilter(filter.getChildren(), aliasAndTechNamePair);
        }
    }

    private Map<String, Map<String, String>> getAliasAndBizNameToTechName(List<DimensionResp> dimensions) {
        if (CollectionUtils.isEmpty(dimensions)) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (DimensionResp dimension : dimensions) {
            if (this.needSkipDimension(dimension)) continue;
            String bizName = dimension.getBizName();
            List dimValueMaps = dimension.getDimValueMaps();
            HashMap<String, String> aliasAndBizNameToTechName = new HashMap<String, String>();
            for (DimValueMap dimValueMap : dimValueMaps) {
                if (this.needSkipDimValue(dimValueMap)) continue;
                if (StringUtils.isNotEmpty((CharSequence)dimValueMap.getBizName())) {
                    aliasAndBizNameToTechName.put(dimValueMap.getBizName(), dimValueMap.getTechName());
                }
                if (CollectionUtils.isEmpty((Collection)dimValueMap.getAlias())) continue;
                dimValueMap.getAlias().stream().forEach(alias -> {
                    if (StringUtils.isNotEmpty((CharSequence)alias)) {
                        aliasAndBizNameToTechName.put((String)alias, dimValueMap.getTechName());
                    }
                });
            }
            if (CollectionUtils.isEmpty(aliasAndBizNameToTechName)) continue;
            result.put(bizName, aliasAndBizNameToTechName);
        }
        return result;
    }

    private boolean needSkipDimValue(DimValueMap dimValueMap) {
        return Objects.isNull(dimValueMap) || StringUtils.isEmpty((CharSequence)dimValueMap.getTechName());
    }

    private Map<String, Map<String, String>> getTechNameToBizName(List<DimensionResp> dimensions) {
        if (CollectionUtils.isEmpty(dimensions)) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (DimensionResp dimension : dimensions) {
            if (this.needSkipDimension(dimension)) continue;
            String bizName = dimension.getBizName();
            List dimValueMaps = dimension.getDimValueMaps();
            HashMap<String, String> techNameToBizName = new HashMap<String, String>();
            for (DimValueMap dimValueMap : dimValueMaps) {
                if (this.needSkipDimValue(dimValueMap) || !StringUtils.isNotEmpty((CharSequence)dimValueMap.getBizName())) continue;
                techNameToBizName.put(dimValueMap.getTechName(), dimValueMap.getBizName());
            }
            if (CollectionUtils.isEmpty(techNameToBizName)) continue;
            result.put(bizName, techNameToBizName);
        }
        return result;
    }

    private boolean needSkipDimension(DimensionResp dimension) {
        return Objects.isNull(dimension) || StringUtils.isEmpty((CharSequence)dimension.getBizName()) || CollectionUtils.isEmpty((Collection)dimension.getDimValueMaps());
    }
}

