/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.aspect;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthRes;
import com.tencent.supersonic.auth.api.authorization.request.QueryAuthResReq;
import com.tencent.supersonic.auth.api.authorization.response.AuthorizedResourceResp;
import com.tencent.supersonic.auth.api.authorization.service.AuthService;
import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.QueryAuthorization;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.SensitiveLevelEnum;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.pojo.exception.InvalidPermissionException;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SchemaFilterReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.utils.QueryStructUtils;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Aspect
public class S2DataPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(S2DataPermissionAspect.class);
    @Autowired
    private QueryStructUtils queryStructUtils;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SchemaService schemaService;
    @Autowired
    private AuthService authService;

    @Pointcut(value="@annotation(com.tencent.supersonic.headless.server.annotation.S2DataPermission)")
    private void s2PermissionCheck() {
    }

    @Around(value="s2PermissionCheck()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] objects = joinPoint.getArgs();
        boolean needQueryData = true;
        SemanticQueryReq queryReq = null;
        if (objects[0] instanceof SemanticQueryReq) {
            queryReq = (SemanticQueryReq)objects[0];
        }
        if (queryReq == null) {
            throw new InvalidArgumentException("queryReq is not Invalid");
        }
        if (!queryReq.isNeedAuth()) {
            log.info("needAuth is false, there is no need to check permissions.");
            return joinPoint.proceed();
        }
        User user = (User)objects[1];
        if (Objects.isNull(user) || StringUtils.isEmpty((CharSequence)user.getName())) {
            throw new RuntimeException("please provide user information");
        }
        SemanticSchemaResp semanticSchemaResp = this.getSemanticSchemaResp(queryReq);
        List<Long> modelIds = this.getModelIds(semanticSchemaResp);
        if (this.checkModelAdmin(user, modelIds)) {
            return joinPoint.proceed();
        }
        this.checkModelVisible(user, modelIds);
        AuthorizedResourceResp authorizedResource = this.getAuthorizedResource(user, modelIds);
        if (needQueryData) {
            this.checkColPermission(queryReq, authorizedResource, modelIds, semanticSchemaResp);
        }
        this.checkRowPermission(queryReq, authorizedResource);
        Object result = joinPoint.proceed();
        if (result instanceof SemanticQueryResp) {
            this.addHint(modelIds, (SemanticQueryResp)result, authorizedResource);
        }
        return result;
    }

    private void checkColPermission(SemanticQueryReq semanticQueryReq, AuthorizedResourceResp authorizedResource, List<Long> modelIds, SemanticSchemaResp semanticSchemaResp) {
        Set<String> bizNamesInQueryReq = this.getBizNameInQueryReq(semanticQueryReq, semanticSchemaResp);
        Set<String> sensitiveBizNamesByModel = this.getHighSensitiveBizNamesByModelId(semanticSchemaResp);
        Set sensitiveBizNameInQuery = bizNamesInQueryReq.parallelStream().filter(sensitiveBizNamesByModel::contains).collect(Collectors.toSet());
        Set sensitiveBizNameUserAuthed = authorizedResource.getAuthResList().stream().map(AuthRes::getName).collect(Collectors.toSet());
        sensitiveBizNameInQuery.removeAll(sensitiveBizNameUserAuthed);
        if (!CollectionUtils.isEmpty(sensitiveBizNameInQuery)) {
            Set sensitiveResNames = semanticSchemaResp.getNameFromBizNames(sensitiveBizNameInQuery);
            List<String> modelAdmin = this.modelService.getModelAdmin(modelIds.get(0));
            String message = String.format("\u5b58\u5728\u4ee5\u4e0b\u654f\u611f\u8d44\u6e90:%s\u60a8\u6682\u65e0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s\u7533\u8bf7", sensitiveResNames, modelAdmin);
            throw new InvalidPermissionException(message);
        }
    }

    private void checkRowPermission(SemanticQueryReq queryReq, AuthorizedResourceResp authorizedResource) {
        if (queryReq instanceof QuerySqlReq) {
            this.doRowPermission((QuerySqlReq)queryReq, authorizedResource);
        }
        if (queryReq instanceof QueryStructReq) {
            this.doRowPermission((QueryStructReq)queryReq, authorizedResource);
        }
    }

    private Set<String> getBizNameInQueryReq(SemanticQueryReq queryReq, SemanticSchemaResp semanticSchemaResp) {
        if (queryReq instanceof QuerySqlReq) {
            return this.queryStructUtils.getBizNameFromSql((QuerySqlReq)queryReq, semanticSchemaResp);
        }
        if (queryReq instanceof QueryStructReq) {
            return this.queryStructUtils.getBizNameFromStruct((QueryStructReq)queryReq);
        }
        throw new InvalidArgumentException("queryReq is not Invalid:" + queryReq);
    }

    private SemanticSchemaResp getSemanticSchemaResp(SemanticQueryReq semanticQueryReq) {
        SchemaFilterReq filter = new SchemaFilterReq();
        filter.setModelIds(semanticQueryReq.getModelIds());
        filter.setDataSetId(semanticQueryReq.getDataSetId());
        return this.schemaService.fetchSemanticSchema(filter);
    }

    private List<Long> getModelIds(SemanticSchemaResp semanticSchemaResp) {
        return semanticSchemaResp.getModelResps().stream().map(SchemaItem::getId).collect(Collectors.toList());
    }

    private void doRowPermission(QuerySqlReq querySqlReq, AuthorizedResourceResp authorizedResource) {
        log.debug("start doRowPermission logic");
        StringJoiner joiner = new StringJoiner(" OR ");
        ArrayList dimensionFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)authorizedResource.getFilters())) {
            authorizedResource.getFilters().stream().forEach(filter -> dimensionFilters.addAll(filter.getExpressions()));
        }
        if (CollectionUtils.isEmpty(dimensionFilters)) {
            log.debug("dimensionFilters is empty");
            return;
        }
        dimensionFilters.stream().forEach(filter -> {
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtils.isNotEmpty((CharSequence)filter.trim())) {
                joiner.add(" ( " + filter + " ) ");
            }
        });
        try {
            Expression expression = CCJSqlParserUtil.parseCondExpression((String)(" ( " + joiner + " ) "));
            if (StringUtils.isNotEmpty((CharSequence)joiner.toString())) {
                String sql = SqlAddHelper.addWhere((String)querySqlReq.getSql(), (Expression)expression);
                log.info("before doRowPermission, queryS2SQLReq:{}", (Object)querySqlReq.getSql());
                querySqlReq.setSql(sql);
                log.info("after doRowPermission, queryS2SQLReq:{}", (Object)querySqlReq.getSql());
            }
        }
        catch (JSQLParserException jsqlParserException) {
            log.info("jsqlParser has an exception:{}", (Object)jsqlParserException.toString());
        }
    }

    private void doRowPermission(QueryStructReq queryStructReq, AuthorizedResourceResp authorizedResource) {
        log.debug("start doRowPermission logic");
        StringJoiner joiner = new StringJoiner(" OR ");
        ArrayList dimensionFilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)authorizedResource.getFilters())) {
            authorizedResource.getFilters().stream().forEach(filter -> dimensionFilters.addAll(filter.getExpressions()));
        }
        if (CollectionUtils.isEmpty(dimensionFilters)) {
            log.debug("dimensionFilters is empty");
            return;
        }
        dimensionFilters.stream().forEach(filter -> {
            if (StringUtils.isNotEmpty((CharSequence)filter) && StringUtils.isNotEmpty((CharSequence)filter.trim())) {
                joiner.add(" ( " + filter + " ) ");
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)joiner.toString())) {
            log.info("before doRowPermission, queryStructReq:{}", (Object)queryStructReq);
            Filter filter2 = new Filter("", FilterOperatorEnum.SQL_PART, (Object)joiner.toString());
            List<Filter> filters = Objects.isNull(queryStructReq.getOriginalFilter()) ? new ArrayList() : queryStructReq.getOriginalFilter();
            filters.add(filter2);
            queryStructReq.setDimensionFilters(filters);
            log.info("after doRowPermission, queryStructReq:{}", (Object)queryStructReq);
        }
    }

    public boolean checkModelAdmin(User user, List<Long> modelIds) {
        List<ModelResp> modelListAdmin = this.modelService.getModelListWithAuth(user, null, AuthType.ADMIN);
        if (CollectionUtils.isEmpty(modelListAdmin)) {
            return false;
        }
        Set modelAdmins = modelListAdmin.stream().map(SchemaItem::getId).collect(Collectors.toSet());
        return !CollectionUtils.isEmpty(modelAdmins) && modelAdmins.containsAll(modelIds);
    }

    public void checkModelVisible(User user, List<Long> modelIds) {
        List modelListVisible = this.modelService.getModelListWithAuth(user, null, AuthType.VISIBLE).stream().map(SchemaItem::getId).collect(Collectors.toList());
        ArrayList<Long> modelIdCopied = new ArrayList<Long>(modelIds);
        modelIdCopied.removeAll(modelListVisible);
        if (!CollectionUtils.isEmpty(modelIdCopied)) {
            MetaFilter metaFilter = new MetaFilter();
            metaFilter.setIds(modelIdCopied);
            List<ModelResp> modelResps = this.modelService.getModelList(metaFilter);
            ModelResp modelResp = modelResps.stream().findFirst().orElse(null);
            if (modelResp == null) {
                throw new InvalidArgumentException("\u67e5\u8be2\u7684\u6a21\u578b\u4e0d\u5b58\u5728");
            }
            String message = String.format("\u60a8\u6ca1\u6709\u6a21\u578b[%s]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s\u5f00\u901a", modelResp.getName(), modelResp.getAdmins());
            throw new InvalidPermissionException(message);
        }
    }

    public Set<String> getHighSensitiveBizNamesByModelId(SemanticSchemaResp semanticSchemaResp) {
        HashSet<String> highSensitiveCols = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)semanticSchemaResp.getDimensions())) {
            semanticSchemaResp.getDimensions().stream().filter(dimSchemaResp -> SensitiveLevelEnum.HIGH.getCode().equals(dimSchemaResp.getSensitiveLevel())).forEach(dim -> highSensitiveCols.add(dim.getBizName()));
        }
        if (!CollectionUtils.isEmpty((Collection)semanticSchemaResp.getMetrics())) {
            semanticSchemaResp.getMetrics().stream().filter(metricSchemaResp -> SensitiveLevelEnum.HIGH.getCode().equals(metricSchemaResp.getSensitiveLevel())).forEach(metric -> highSensitiveCols.add(metric.getBizName()));
        }
        return highSensitiveCols;
    }

    public AuthorizedResourceResp getAuthorizedResource(User user, List<Long> modelIds) {
        QueryAuthResReq queryAuthResReq = new QueryAuthResReq();
        queryAuthResReq.setModelIds(modelIds);
        AuthorizedResourceResp authorizedResource = this.fetchAuthRes(queryAuthResReq, user);
        log.info("user:{}, domainId:{}, after queryAuthorizedResources:{}", new Object[]{user.getName(), modelIds, authorizedResource});
        return authorizedResource;
    }

    private AuthorizedResourceResp fetchAuthRes(QueryAuthResReq queryAuthResReq, User user) {
        log.info("queryAuthResReq:{}", (Object)queryAuthResReq);
        return this.authService.queryAuthorizedResources(queryAuthResReq, user);
    }

    public void addHint(List<Long> modelIds, SemanticQueryResp queryResultWithColumns, AuthorizedResourceResp authorizedResource) {
        List filters = authorizedResource.getFilters();
        if (CollectionUtils.isEmpty((Collection)filters)) {
            return;
        }
        List<String> admins = this.modelService.getModelAdmin(modelIds.get(0));
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            ModelResp modelResp = this.modelService.getModel(modelIds.get(0));
            ArrayList exprList = new ArrayList();
            ArrayList descList = new ArrayList();
            filters.stream().forEach(filter -> {
                if (StringUtils.isNotEmpty((CharSequence)filter.getDescription())) {
                    descList.add(filter.getDescription());
                }
                exprList.add(filter.getExpressions().toString());
            });
            String promptInfo = "\u5f53\u524d\u7ed3\u679c\u5df2\u7ecf\u8fc7\u884c\u6743\u9650\u8fc7\u6ee4\uff0c\u8be6\u7ec6\u8fc7\u6ee4\u6761\u4ef6\u5982\u4e0b:%s, \u7533\u8bf7\u6743\u9650\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458%s";
            String message = String.format(promptInfo, CollectionUtils.isEmpty(descList) ? exprList : descList, admins);
            queryResultWithColumns.setQueryAuthorization(new QueryAuthorization(modelResp.getName(), exprList, descList, message));
        }
    }
}

