/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryNLReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.server.facade.service.ChatLayerService;
import com.tencent.supersonic.headless.server.facade.service.RetrieveService;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/query"})
public class ChatQueryApiController {
    private static final Logger log = LoggerFactory.getLogger(ChatQueryApiController.class);
    @Autowired
    private ChatLayerService chatLayerService;
    @Autowired
    private RetrieveService retrieveService;
    @Autowired
    private SemanticLayerService semanticLayerService;

    @PostMapping(value={"/chat/search"})
    public Object search(@RequestBody QueryNLReq queryNLReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        queryNLReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.retrieveService.retrieve(queryNLReq);
    }

    @PostMapping(value={"/chat/map"})
    public Object map(@RequestBody QueryNLReq queryNLReq, HttpServletRequest request, HttpServletResponse response) {
        queryNLReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatLayerService.performMapping(queryNLReq);
    }

    @PostMapping(value={"/chat/parse"})
    public Object parse(@RequestBody QueryNLReq queryNLReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        queryNLReq.setUser(UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response));
        return this.chatLayerService.performParsing(queryNLReq);
    }

    @PostMapping(value={"/chat"})
    public Object queryByNL(@RequestBody QueryNLReq queryNLReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        ParseResp parseResp = this.chatLayerService.performParsing(queryNLReq);
        if (parseResp.getState().equals((Object)ParseResp.ParseState.COMPLETED)) {
            SemanticParseInfo parseInfo = (SemanticParseInfo)parseResp.getSelectedParses().get(0);
            QuerySqlReq sqlReq = new QuerySqlReq();
            sqlReq.setSql(parseInfo.getSqlInfo().getCorrectedS2SQL());
            sqlReq.setSqlInfo(parseInfo.getSqlInfo());
            return this.semanticLayerService.queryByReq((SemanticQueryReq)sqlReq, user);
        }
        throw new RuntimeException("Failed to parse natural language query: " + queryNLReq.getQueryText());
    }
}

