/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.common.util.StringUtil;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlsReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.server.facade.service.ChatLayerService;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/query"})
public class SqlQueryApiController {
    private static final Logger log = LoggerFactory.getLogger(SqlQueryApiController.class);
    @Autowired
    private SemanticLayerService semanticLayerService;
    @Autowired
    private ChatLayerService chatLayerService;

    @PostMapping(value={"/sql"})
    public Object queryBySql(@RequestBody QuerySqlReq querySqlReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        String sql = querySqlReq.getSql();
        querySqlReq.setSql(StringUtil.replaceBackticks((String)sql));
        this.chatLayerService.correct(querySqlReq, user);
        return this.semanticLayerService.queryByReq((SemanticQueryReq)querySqlReq, user);
    }

    @PostMapping(value={"/sqls"})
    public Object queryBySqls(@RequestBody QuerySqlsReq querySqlsReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        List semanticQueryReqs = querySqlsReq.getSqls().stream().map(sql -> {
            QuerySqlReq querySqlReq = new QuerySqlReq();
            BeanUtils.copyProperties((Object)querySqlsReq, (Object)querySqlReq);
            querySqlReq.setSql(StringUtil.replaceBackticks((String)sql));
            this.chatLayerService.correct(querySqlReq, user);
            return querySqlReq;
        }).collect(Collectors.toList());
        List futures = semanticQueryReqs.stream().map(querySqlReq -> CompletableFuture.supplyAsync(() -> {
            try {
                return this.semanticLayerService.queryByReq((SemanticQueryReq)querySqlReq, user);
            }
            catch (Exception e) {
                log.error("querySqlReq:{},queryByReq error:", querySqlReq, (Object)e);
                return new SemanticQueryResp();
            }
        })).collect(Collectors.toList());
        return futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    @PostMapping(value={"/sqlsWithException"})
    public Object queryBySqlsWithException(@RequestBody QuerySqlsReq querySqlsReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        List semanticQueryReqs = querySqlsReq.getSqls().stream().map(sql -> {
            QuerySqlReq querySqlReq = new QuerySqlReq();
            BeanUtils.copyProperties((Object)querySqlsReq, (Object)querySqlReq);
            querySqlReq.setSql(StringUtil.replaceBackticks((String)sql));
            this.chatLayerService.correct(querySqlReq, user);
            return querySqlReq;
        }).collect(Collectors.toList());
        ArrayList<SemanticQueryResp> semanticQueryRespList = new ArrayList<SemanticQueryResp>();
        try {
            for (SemanticQueryReq semanticQueryReq : semanticQueryReqs) {
                SemanticQueryResp semanticQueryResp = this.semanticLayerService.queryByReq(semanticQueryReq, user);
                semanticQueryRespList.add(semanticQueryResp);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getCause().getMessage());
        }
        return semanticQueryRespList;
    }

    @PostMapping(value={"/validate"})
    public Object validate(@RequestBody QuerySqlReq querySqlReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        String sql = querySqlReq.getSql();
        querySqlReq.setSql(StringUtil.replaceBackticks((String)sql));
        return this.chatLayerService.validate(querySqlReq, user);
    }
}

