/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.facade.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.TaskStatusEnum;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.headless.api.pojo.DataInfo;
import com.tencent.supersonic.headless.api.pojo.DataSetInfo;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.EntityInfo;
import com.tencent.supersonic.headless.api.pojo.QueryParam;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.TagTypeDefaultConfig;
import com.tencent.supersonic.headless.api.pojo.TimeDefaultConfig;
import com.tencent.supersonic.headless.api.pojo.enums.SemanticType;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryMultiStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SchemaFilterReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.ItemResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticTranslateResp;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.knowledge.MapResult;
import com.tencent.supersonic.headless.chat.knowledge.SearchService;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import com.tencent.supersonic.headless.chat.utils.QueryReqBuilder;
import com.tencent.supersonic.headless.core.cache.QueryCache;
import com.tencent.supersonic.headless.core.executor.QueryExecutor;
import com.tencent.supersonic.headless.core.pojo.QueryStatement;
import com.tencent.supersonic.headless.core.translator.SemanticTranslator;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.SemanticModel;
import com.tencent.supersonic.headless.core.utils.ComponentFactory;
import com.tencent.supersonic.headless.server.annotation.S2DataPermission;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.manager.SemanticSchemaManager;
import com.tencent.supersonic.headless.server.utils.MetricDrillDownChecker;
import com.tencent.supersonic.headless.server.utils.QueryReqConverter;
import com.tencent.supersonic.headless.server.utils.QueryUtils;
import com.tencent.supersonic.headless.server.utils.StatUtils;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class S2SemanticLayerService
implements SemanticLayerService {
    private static final Logger log = LoggerFactory.getLogger(S2SemanticLayerService.class);
    private StatUtils statUtils;
    private final QueryUtils queryUtils;
    private final QueryReqConverter queryReqConverter;
    private final SemanticSchemaManager semanticSchemaManager;
    private final DataSetService dataSetService;
    private final SchemaService schemaService;
    private final SemanticTranslator semanticTranslator;
    private final MetricDrillDownChecker metricDrillDownChecker;
    private final KnowledgeBaseService knowledgeBaseService;
    private QueryCache queryCache = ComponentFactory.getQueryCache();
    private List<QueryExecutor> queryExecutors = ComponentFactory.getQueryExecutors();

    public S2SemanticLayerService(StatUtils statUtils, QueryUtils queryUtils, QueryReqConverter queryReqConverter, SemanticSchemaManager semanticSchemaManager, DataSetService dataSetService, SchemaService schemaService, SemanticTranslator semanticTranslator, MetricDrillDownChecker metricDrillDownChecker, KnowledgeBaseService knowledgeBaseService) {
        this.statUtils = statUtils;
        this.queryUtils = queryUtils;
        this.queryReqConverter = queryReqConverter;
        this.semanticSchemaManager = semanticSchemaManager;
        this.dataSetService = dataSetService;
        this.schemaService = schemaService;
        this.semanticTranslator = semanticTranslator;
        this.metricDrillDownChecker = metricDrillDownChecker;
        this.knowledgeBaseService = knowledgeBaseService;
    }

    @Override
    public DataSetSchema getDataSetSchema(Long id) {
        return this.schemaService.getDataSetSchema(id);
    }

    @Override
    @S2DataPermission
    public SemanticTranslateResp translate(SemanticQueryReq queryReq, User user) throws Exception {
        QueryStatement queryStatement = this.buildQueryStatement(queryReq, user);
        this.semanticTranslator.translate(queryStatement);
        return SemanticTranslateResp.builder().querySQL(queryStatement.getSql()).isOk(queryStatement.isOk()).errMsg(queryStatement.getErrMsg()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @S2DataPermission
    public SemanticQueryResp queryByReq(SemanticQueryReq queryReq, User user) {
        TaskStatusEnum state = TaskStatusEnum.SUCCESS;
        log.info("[queryReq:{}]", (Object)queryReq);
        try {
            this.statUtils.initStatInfo(queryReq, user);
            String cacheKey = this.queryCache.getCacheKey(queryReq);
            log.debug("cacheKey:{}", (Object)cacheKey);
            Object query = this.queryCache.query(queryReq, cacheKey);
            if (Objects.nonNull(query)) {
                SemanticQueryResp queryResp = (SemanticQueryResp)query;
                queryResp.setUseCache(true);
                SemanticQueryResp semanticQueryResp = queryResp;
                return semanticQueryResp;
            }
            StatUtils.get().setUseResultCache(Boolean.valueOf(false));
            QueryStatement queryStatement = this.buildQueryStatement(queryReq, user);
            SemanticQueryResp queryResp = null;
            if (!queryStatement.isTranslated()) {
                this.semanticTranslator.translate(queryStatement);
            }
            this.queryPreCheck(queryStatement);
            for (QueryExecutor queryExecutor : this.queryExecutors) {
                if (!queryExecutor.accept(queryStatement)) continue;
                queryResp = queryExecutor.execute(queryStatement);
                this.queryUtils.fillItemNameInfo(queryResp, queryStatement.getSemanticSchemaResp());
            }
            Boolean setCacheSuccess = this.queryCache.put(cacheKey, queryResp);
            if (setCacheSuccess.booleanValue()) {
                this.statUtils.updateResultCacheKey(cacheKey);
            }
            if (Objects.isNull(queryResp)) {
                state = TaskStatusEnum.ERROR;
            }
            SemanticQueryResp semanticQueryResp = queryResp;
            return semanticQueryResp;
        }
        catch (Exception e) {
            log.error("exception in queryByStruct, e: ", (Throwable)e);
            state = TaskStatusEnum.ERROR;
            throw e;
        }
        finally {
            this.statUtils.statInfo2DbAsync(state);
        }
    }

    @Override
    public SemanticQueryResp queryDimensionValue(DimensionValueReq dimensionValueReq, User user) {
        SemanticQueryResp semanticQueryResp = new SemanticQueryResp();
        DimensionResp dimensionResp = this.getDimension(dimensionValueReq);
        Set dataSetIds = dimensionValueReq.getDataSetIds();
        dimensionValueReq.setModelId(dimensionResp.getModelId());
        List<String> dimensionValues = this.getDimensionValuesFromDict(dimensionValueReq, dataSetIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dimensionValues)) {
            semanticQueryResp = this.getDimensionValuesFromDb(dimensionValueReq, user);
            return semanticQueryResp;
        }
        ArrayList<QueryColumn> columns = new ArrayList<QueryColumn>();
        QueryColumn queryColumn = new QueryColumn();
        queryColumn.setNameEn(dimensionValueReq.getBizName());
        queryColumn.setShowType(SemanticType.CATEGORY.name());
        queryColumn.setAuthorized(Boolean.valueOf(true));
        queryColumn.setType("CHAR");
        columns.add(queryColumn);
        ArrayList resultList = new ArrayList();
        dimensionValues.stream().forEach(o -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(dimensionValueReq.getBizName(), (String)o);
            resultList.add(map);
        });
        semanticQueryResp.setColumns(columns);
        semanticQueryResp.setResultList(resultList);
        return semanticQueryResp;
    }

    private List<String> getDimensionValuesFromDict(DimensionValueReq dimensionValueReq, Set<Long> dataSetIds) {
        if (StringUtils.isBlank((CharSequence)dimensionValueReq.getValue())) {
            return SearchService.getDimensionValue((DimensionValueReq)dimensionValueReq);
        }
        HashMap<Long, ArrayList<Long>> modelIdToDataSetIds = new HashMap<Long, ArrayList<Long>>();
        modelIdToDataSetIds.put(dimensionValueReq.getModelId(), new ArrayList<Long>(dataSetIds));
        List hanlpMapResultList = this.knowledgeBaseService.prefixSearch(dimensionValueReq.getValue(), 2000, modelIdToDataSetIds, dataSetIds);
        HanlpHelper.transLetterOriginal((List)hanlpMapResultList);
        return hanlpMapResultList.stream().filter(o -> {
            for (String nature : o.getNatures()) {
                Long elementID = NatureHelper.getElementID((String)nature);
                if (!dimensionValueReq.getElementID().equals(elementID)) continue;
                return true;
            }
            return false;
        }).map(MapResult::getName).collect(Collectors.toList());
    }

    private SemanticQueryResp getDimensionValuesFromDb(DimensionValueReq dimensionValueReq, User user) {
        QuerySqlReq querySqlReq = this.buildQuerySqlReq(dimensionValueReq);
        return this.queryByReq((SemanticQueryReq)querySqlReq, user);
    }

    private DimensionResp getDimension(DimensionValueReq dimensionValueReq) {
        DimensionResp dimensionResp = this.schemaService.getDimension(dimensionValueReq.getElementID());
        if (dimensionResp == null) {
            return this.schemaService.getDimension(dimensionValueReq.getBizName(), dimensionValueReq.getModelId());
        }
        return dimensionResp;
    }

    @Override
    public EntityInfo getEntityInfo(SemanticParseInfo parseInfo, DataSetSchema dataSetSchema, User user) {
        if (parseInfo != null && parseInfo.getDataSetId() != null && parseInfo.getDataSetId() > 0L) {
            EntityInfo entityInfo = this.getEntityBasicInfo(dataSetSchema);
            if (parseInfo.getDimensionFilters().size() <= 0 || entityInfo.getDataSetInfo() == null) {
                entityInfo.setMetrics(null);
                entityInfo.setDimensions(null);
                return entityInfo;
            }
            String primaryKey = entityInfo.getDataSetInfo().getPrimaryKey();
            if (StringUtils.isNotBlank((CharSequence)primaryKey)) {
                String entityId = "";
                for (QueryFilter chatFilter : parseInfo.getDimensionFilters()) {
                    if (chatFilter == null || chatFilter.getBizName() == null || !chatFilter.getBizName().equals(primaryKey) || !chatFilter.getOperator().equals((Object)FilterOperatorEnum.EQUALS)) continue;
                    entityId = chatFilter.getValue().toString();
                }
                entityInfo.setEntityId(entityId);
                try {
                    this.fillEntityInfoValue(entityInfo, dataSetSchema, user);
                    return entityInfo;
                }
                catch (Exception e) {
                    log.error("setMainModel error", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public List<ItemResp> getDomainDataSetTree() {
        return this.schemaService.getDomainDataSetTree();
    }

    private QueryStatement buildSqlQueryStatement(QuerySqlReq querySqlReq, User user) throws Exception {
        if (querySqlReq.needGetDataSetId()) {
            Long dataSetId = this.dataSetService.getDataSetIdFromSql(querySqlReq.getSql(), user);
            querySqlReq.setDataSetId(dataSetId);
        }
        SchemaFilterReq filter = this.buildSchemaFilterReq((SemanticQueryReq)querySqlReq);
        SemanticSchemaResp semanticSchemaResp = this.schemaService.fetchSemanticSchema(filter);
        QueryStatement queryStatement = this.queryReqConverter.convert(querySqlReq, semanticSchemaResp);
        queryStatement.setModelIds(querySqlReq.getModelIds());
        queryStatement.setEnableOptimize(this.queryUtils.enableOptimize());
        queryStatement.setSemanticSchemaResp(semanticSchemaResp);
        queryStatement.setSemanticModel(this.semanticSchemaManager.getSemanticModel(semanticSchemaResp));
        return queryStatement;
    }

    private QueryStatement buildQueryStatement(SemanticQueryReq semanticQueryReq, User user) throws Exception {
        QueryStatement queryStatement = null;
        if (semanticQueryReq instanceof QuerySqlReq) {
            queryStatement = this.buildSqlQueryStatement((QuerySqlReq)semanticQueryReq, user);
        }
        if (semanticQueryReq instanceof QueryStructReq) {
            queryStatement = this.buildStructQueryStatement((QueryStructReq)semanticQueryReq);
        }
        if (semanticQueryReq instanceof QueryMultiStructReq) {
            queryStatement = this.buildMultiStructQueryStatement((QueryMultiStructReq)semanticQueryReq, user);
        }
        if (Objects.nonNull(queryStatement) && Objects.nonNull(semanticQueryReq.getSqlInfo()) && StringUtils.isNotBlank((CharSequence)semanticQueryReq.getSqlInfo().getQuerySQL())) {
            queryStatement.setSql(semanticQueryReq.getSqlInfo().getQuerySQL());
            queryStatement.setDataSetId(semanticQueryReq.getDataSetId());
            queryStatement.setIsTranslated(Boolean.valueOf(true));
        }
        return queryStatement;
    }

    private QueryStatement buildStructQueryStatement(QueryStructReq queryStructReq) {
        SchemaFilterReq filter = this.buildSchemaFilterReq((SemanticQueryReq)queryStructReq);
        SemanticSchemaResp semanticSchemaResp = this.schemaService.fetchSemanticSchema(filter);
        QueryStatement queryStatement = new QueryStatement();
        QueryParam queryParam = new QueryParam();
        this.queryReqConverter.convert(queryStructReq, queryParam);
        queryStatement.setQueryParam(queryParam);
        queryStatement.setIsS2SQL(Boolean.valueOf(false));
        queryStatement.setEnableOptimize(this.queryUtils.enableOptimize());
        queryStatement.setDataSetId(queryStructReq.getDataSetId());
        queryStatement.setSemanticSchemaResp(semanticSchemaResp);
        queryStatement.setSemanticModel(this.semanticSchemaManager.getSemanticModel(semanticSchemaResp));
        return queryStatement;
    }

    private QueryStatement buildMultiStructQueryStatement(QueryMultiStructReq queryMultiStructReq, User user) throws Exception {
        ArrayList<QueryStatement> sqlParsers = new ArrayList<QueryStatement>();
        for (QueryStructReq queryStructReq : queryMultiStructReq.getQueryStructReqs()) {
            QueryStatement queryStatement = this.buildQueryStatement((SemanticQueryReq)queryStructReq, user);
            SemanticModel semanticModel = queryStatement.getSemanticModel();
            queryStatement.setModelIds(queryStructReq.getModelIds());
            queryStatement.setSemanticModel(semanticModel);
            queryStatement.setEnableOptimize(this.queryUtils.enableOptimize());
            this.semanticTranslator.translate(queryStatement);
            sqlParsers.add(queryStatement);
        }
        log.info("multi sqlParser:{}", sqlParsers);
        return this.queryUtils.sqlParserUnion(queryMultiStructReq, sqlParsers);
    }

    private SchemaFilterReq buildSchemaFilterReq(SemanticQueryReq semanticQueryReq) {
        SchemaFilterReq schemaFilterReq = new SchemaFilterReq();
        schemaFilterReq.setDataSetId(semanticQueryReq.getDataSetId());
        schemaFilterReq.setModelIds(semanticQueryReq.getModelIds());
        return schemaFilterReq;
    }

    private QuerySqlReq buildQuerySqlReq(DimensionValueReq queryDimValueReq) {
        QuerySqlReq querySqlReq = new QuerySqlReq();
        List<ModelResp> modelResps = this.schemaService.getModelList(Lists.newArrayList((Object[])new Long[]{queryDimValueReq.getModelId()}));
        DimensionResp dimensionResp = this.schemaService.getDimension(queryDimValueReq.getBizName(), queryDimValueReq.getModelId());
        ModelResp modelResp = modelResps.get(0);
        Object sql = String.format("select distinct %s from %s where 1=1", dimensionResp.getName(), modelResp.getName());
        List timeDims = modelResp.getTimeDimension();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)timeDims)) {
            sql = String.format("%s and %s >= '%s' and %s <= '%s'", sql, TimeDimensionEnum.DAY.getName(), queryDimValueReq.getDateInfo().getStartDate(), TimeDimensionEnum.DAY.getName(), queryDimValueReq.getDateInfo().getEndDate());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDimValueReq.getValue())) {
            sql = (String)sql + " AND " + queryDimValueReq.getBizName() + " LIKE '%" + queryDimValueReq.getValue() + "%'";
        }
        querySqlReq.setModelIds((Set)Sets.newHashSet((Object[])new Long[]{queryDimValueReq.getModelId()}));
        querySqlReq.setSql((String)sql);
        return querySqlReq;
    }

    private void queryPreCheck(QueryStatement queryStatement) {
        this.metricDrillDownChecker.checkQuery(queryStatement);
    }

    private EntityInfo getEntityBasicInfo(DataSetSchema dataSetSchema) {
        EntityInfo entityInfo = new EntityInfo();
        if (dataSetSchema == null) {
            return entityInfo;
        }
        Long dataSetId = dataSetSchema.getDataSet().getDataSet();
        DataSetInfo dataSetInfo = new DataSetInfo();
        dataSetInfo.setItemId(Integer.valueOf(dataSetId.intValue()));
        dataSetInfo.setName(dataSetSchema.getDataSet().getName());
        dataSetInfo.setWords(dataSetSchema.getDataSet().getAlias());
        dataSetInfo.setBizName(dataSetSchema.getDataSet().getBizName());
        if (Objects.nonNull(dataSetSchema.getEntity())) {
            dataSetInfo.setPrimaryKey(dataSetSchema.getEntity().getBizName());
        }
        entityInfo.setDataSetInfo(dataSetInfo);
        TagTypeDefaultConfig tagTypeDefaultConfig = dataSetSchema.getTagTypeDefaultConfig();
        if (tagTypeDefaultConfig == null || tagTypeDefaultConfig.getDefaultDisplayInfo() == null) {
            return entityInfo;
        }
        List dimensions = tagTypeDefaultConfig.getDefaultDisplayInfo().getDimensionIds().stream().map(id -> {
            SchemaElement element = dataSetSchema.getElement(SchemaElementType.DIMENSION, id.longValue());
            if (element == null) {
                return null;
            }
            return new DataInfo(Integer.valueOf(element.getId().intValue()), element.getName(), element.getBizName(), null);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List metrics = tagTypeDefaultConfig.getDefaultDisplayInfo().getDimensionIds().stream().map(id -> {
            SchemaElement element = dataSetSchema.getElement(SchemaElementType.METRIC, id.longValue());
            if (element == null) {
                return null;
            }
            return new DataInfo(Integer.valueOf(element.getId().intValue()), element.getName(), element.getBizName(), null);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        entityInfo.setDimensions(dimensions);
        entityInfo.setMetrics(metrics);
        return entityInfo;
    }

    private void fillEntityInfoValue(EntityInfo entityInfo, DataSetSchema dataSetSchema, User user) {
        SemanticQueryResp queryResultWithColumns = this.getQueryResultWithSchemaResp(entityInfo, dataSetSchema, user);
        if (queryResultWithColumns != null && !CollectionUtils.isEmpty((Collection)queryResultWithColumns.getResultList()) && queryResultWithColumns.getResultList().size() > 0) {
            Map result = (Map)queryResultWithColumns.getResultList().get(0);
            for (Map.Entry<String, Object> entry : result.entrySet()) {
                String entryKey = this.getEntryKey(entry);
                if (entry.getValue() == null || entryKey == null) continue;
                entityInfo.getDimensions().stream().filter(i -> entryKey.equals(i.getBizName())).forEach(i -> i.setValue(entry.getValue().toString()));
                entityInfo.getMetrics().stream().filter(i -> entryKey.equals(i.getBizName())).forEach(i -> i.setValue(entry.getValue().toString()));
            }
        }
    }

    private SemanticQueryResp getQueryResultWithSchemaResp(EntityInfo entityInfo, DataSetSchema dataSetSchema, User user) {
        SemanticParseInfo semanticParseInfo = new SemanticParseInfo();
        semanticParseInfo.setDataSet(dataSetSchema.getDataSet());
        semanticParseInfo.setQueryType(QueryType.DETAIL);
        semanticParseInfo.setMetrics(this.getMetrics(entityInfo));
        semanticParseInfo.setDimensions(this.getDimensions(entityInfo));
        DateConf dateInfo = new DateConf();
        int unit = 1;
        TimeDefaultConfig timeDefaultConfig = dataSetSchema.getTagTypeTimeDefaultConfig();
        if (Objects.nonNull(timeDefaultConfig)) {
            unit = timeDefaultConfig.getUnit();
            String date = LocalDate.now().plusDays(-unit).toString();
            dateInfo.setDateMode(DateConf.DateMode.BETWEEN);
            dateInfo.setStartDate(date);
            dateInfo.setEndDate(date);
        } else {
            dateInfo.setUnit(Integer.valueOf(unit));
            dateInfo.setDateMode(DateConf.DateMode.RECENT);
        }
        semanticParseInfo.setDateInfo(dateInfo);
        QueryFilter chatFilter = this.getQueryFilter(entityInfo);
        LinkedHashSet<QueryFilter> chatFilters = new LinkedHashSet<QueryFilter>();
        chatFilters.add(chatFilter);
        semanticParseInfo.setDimensionFilters(chatFilters);
        SemanticQueryResp queryResultWithColumns = null;
        try {
            QueryStructReq queryStructReq = QueryReqBuilder.buildStructReq((SemanticParseInfo)semanticParseInfo);
            queryResultWithColumns = this.queryByReq((SemanticQueryReq)queryStructReq, user);
        }
        catch (Exception e) {
            log.warn("setMainModel queryByStruct error, e:", (Throwable)e);
        }
        return queryResultWithColumns;
    }

    private QueryFilter getQueryFilter(EntityInfo entityInfo) {
        QueryFilter chatFilter = new QueryFilter();
        chatFilter.setValue((Object)entityInfo.getEntityId());
        chatFilter.setOperator(FilterOperatorEnum.EQUALS);
        chatFilter.setBizName(this.getEntityPrimaryName(entityInfo));
        return chatFilter;
    }

    private Set<SchemaElement> getDimensions(EntityInfo modelInfo) {
        LinkedHashSet<SchemaElement> dimensions = new LinkedHashSet<SchemaElement>();
        for (DataInfo mainEntityDimension : modelInfo.getDimensions()) {
            SchemaElement dimension = new SchemaElement();
            dimension.setBizName(mainEntityDimension.getBizName());
            dimensions.add(dimension);
        }
        return dimensions;
    }

    private String getEntryKey(Map.Entry<String, Object> entry) {
        String entryKey = entry.getKey();
        if (entryKey.contains("__")) {
            entryKey = entryKey.split("__")[1];
        }
        return entryKey;
    }

    private Set<SchemaElement> getMetrics(EntityInfo modelInfo) {
        LinkedHashSet<SchemaElement> metrics = new LinkedHashSet<SchemaElement>();
        for (DataInfo metricValue : modelInfo.getMetrics()) {
            SchemaElement metric = new SchemaElement();
            BeanUtils.copyProperties((Object)metricValue, (Object)metric);
            metrics.add(metric);
        }
        return metrics;
    }

    private String getEntityPrimaryName(EntityInfo entityInfo) {
        return entityInfo.getDataSetInfo().getPrimaryKey();
    }
}

