/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.listener;

import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.pojo.DataEvent;
import com.tencent.supersonic.common.pojo.enums.EventType;
import com.tencent.supersonic.common.service.EmbeddingService;
import dev.langchain4j.store.embedding.TextSegmentConvert;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MetaEmbeddingListener
implements ApplicationListener<DataEvent> {
    private static final Logger log = LoggerFactory.getLogger(MetaEmbeddingListener.class);
    @Autowired
    private EmbeddingConfig embeddingConfig;
    @Autowired
    private EmbeddingService embeddingService;
    @Value(value="${s2.embedding.operation.sleep.time:3000}")
    private Integer embeddingOperationSleepTime;

    @Async
    public void onApplicationEvent(DataEvent event) {
        List dataItems = event.getDataItems();
        if (CollectionUtils.isEmpty((Collection)dataItems)) {
            return;
        }
        List textSegments = TextSegmentConvert.convertToEmbedding((List)dataItems);
        if (CollectionUtils.isEmpty((Collection)textSegments)) {
            return;
        }
        this.sleep();
        if (event.getEventType().equals((Object)EventType.ADD)) {
            this.embeddingService.addQuery(this.embeddingConfig.getMetaCollectionName(), textSegments);
        } else if (event.getEventType().equals((Object)EventType.DELETE)) {
            this.embeddingService.deleteQuery(this.embeddingConfig.getMetaCollectionName(), textSegments);
        } else if (event.getEventType().equals((Object)EventType.UPDATE)) {
            this.embeddingService.deleteQuery(this.embeddingConfig.getMetaCollectionName(), textSegments);
            this.embeddingService.addQuery(this.embeddingConfig.getMetaCollectionName(), textSegments);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.embeddingOperationSleepTime.intValue());
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
        }
    }
}

